/*
 * Copyright (c) 1995 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI if_tereg.h,v 2.2 1995/10/13 20:36:46 ewv Exp
 */

/*
 * SMC Token Ring Elite
 */

#include <i386/isa/ic/smc83C825.h>
#include <i386/isa/ic/smc83C584.h>


#define	SM_WSIZE	16384		/* Size of RAM window */
#define SM_RSIZE	65536		/* Size of shared RAM */
#define SM_ISCPADDR	0xfff6

#define SM_NPORTS	32
#define SM_MINPORT	0x200
#define SM_MAXPORT	0x3ff
#define SM_PORTMASK	0x1f

/*
 * 8115T specific definitions for 584 bits
 */

/* IRR bits */
#define SMIRR_STP	0
#define SMIRR_UTP	SMIRR_OUT1
#define SMIRR_4M	0
#define SMIRR_16M	SMIRR_OUT2

/*
 * 8115T I/O addresses
 */
#define SMIO_CTL	0x10
#define	SMIO_PAGE	0x11

/* SMIO_CTL write bits */
#define SMCTL_CA	0x01		/* Pulse CA */	
#define SMCTL_WCSS	0x02		/* Control store steering */
#define SMCTL_CLRCBUSY	0x04		/* Clear CBUSY interrupt */
#define SMCTL_CLRTINT	0x08		/* Clear TRC interrupt */
#define SMCTL_MSKCBUSY	0x10		/* Mask CBUSY interrupt */
#define SMCTL_MSKTINT	0x20		/* Mask TRC interrupt */

/* SMIO_CTL read bits */
#define SMCTL_CBUSY	0x01		/* CBUSY from TRC */
#define SMCTL_FAULT	0x02		/* fault from TRC */
#define SMCTL_CSTAT	0x04		/* CBUSY interrupt status */
#define SMCTL_TSTAT	0x08		/* TRC interrupt status */
#define SMCTL_CINT	0x10		/* CBUSY intr stat (maskable) */
#define SMCTL_TINT	0x20		/* TRC intr stat (maskable) */

/* SMIO_PAGE */
#define	SMPG_SHIFT	6		/* Page select shift */
#define SMPG_MASK	0xc0		/* Page select mask */

#define SMPG_PGMASK	(SM_WSIZE - 1)
#define SMPG_NPAGE	4		/* Number of pages */
#define SMPGBITS(x)	((x) & 0xc000)	/* Extract page bits from an address */

/* Standard config values for ISA 8115T */
#define SCP_BSTLEN	0x0e		/* Burst length */
#define SMIAC0_TRIG	0x04		/* DMA FIFO trigger point */
#define SMIAC1_TIF_16	0x03		/* Xmit interframe gap, 6 bytes */
#define SMIAC1_TIF_4	0x01		/* Xmit interframe gap, 2 bytes */
