/*    BSDI if_wlreg.h,v 1.3 1997/10/30 23:45:46 geertj Exp */
/* 
 * HISTORY
 * Log: if_wlpreg.h,v 
 * Revision 1.2  1996/03/03 09:33:39  vixie
 * checked in wavelan.h and if_wlp.h from sklower
 *
 * Revision 1.2  1995/02/24  00:37:55  ss
 * added beacons
 *
 * Revision 1.1  1994/06/02  20:31:11  klemets
 * Initial revision
 *
 */

#define WAVELAN_ADDR_SIZE	6	/* Size of a MAC address */
#define WAVELAN_MTU		1500	/* Maximum size of Wavelan packet */
#define	WL_NBEACONS		8
#define BEACONS

struct beacon_ind {
	u_char		id[2];
	u_char		pdu_type;
	u_char		sequence;
	u_char		domain_id[2];
	u_char		nwid[2];
	u_char		rf_noise;
	u_char		cell_thresh[4];
	u_char		interval[2];
	u_char		timeout[2];
	char		ap_name[32];
};

typedef struct beacon_cntr {
	u_char		eth_addr[WAVELAN_ADDR_SIZE];
	u_char		siglvl;
	u_char		sillvl;
	u_char		sigqual;
} beacon_cntr;

struct wl_cntrs {
	struct {
		u_int xmt, xmti;
		u_int defer;
		u_int busy;
		u_int sleaze, intrinsic, intrinsic_count;
		u_int chain;
		u_int heart;
		u_int coll;
		u_int ncoll;
		u_int nodcd;
		u_int nocts;
		u_int dma;
	} xmt; 
	struct {
		u_int rcv;
		u_int ovw;
		u_int crc;
		u_int frame;
		u_int rscerrs, ovrnerrs;
		u_int partial;
		u_int snr[5];
	} rcv;
	struct {
		u_char cur_nwid[2];
		u_short dce_status;
		u_short nwids;
		u_short badnwids;
		u_short thrpreset;
		u_short siglvl;
		u_short sillvl;
		u_short sigqual;
		u_short netwidl;
		u_short des;
	} mmc;
	beacon_cntr beacons[WL_NBEACONS];
	u_char	nwid[2];
	u_int	watch;
};
typedef	struct wl_cntrs *wl_cntrs_t;

#define	CNTR_NAME	"_wl_cntrs"

/* command unit for wlsetstat */
struct wl_ucmd {
	int cmd;
	int param;
};
typedef struct wl_ucmd *wl_ucmd_t;

#ifdef	IF_CNTRS
/* interface driver specific counters */
struct wl_ifcntrs {
	int pkt_arp;
	int pkt_ein[32];
	int pkt_lin[128/8];
	int pkt_eout[32]; 
	int pkt_lout[128/8]; 
};
typedef struct wl_ifcntrs *wl_ifcntrs_t;
#define	NET_WL_IFCNTRS		(('w'<<16) + 3)
#define NET_WL_IFCNTRS_CNT	(sizeof (struct wl_ifcntrs)/sizeof(int))
#endif	IF_CNTRS

/* local flavor value for wlsetstat and wlgetstat */
#define	NET_WL_CNTRS		(('w'<<16) + 1)
#define	NET_WL_CMD		(('w'<<16) + 2)
#define	NET_WL_PSA		(('w'<<24) + ('l'<<16))
#define NET_WL_CNTRS_CNT	(sizeof (struct wl_cntrs)/sizeof(int))
#define NET_WL_CMD_CNT		(sizeof (struct wl_ucmd)/sizeof(int))
#define	NET_WL_PSA_CNT		1

#ifdef	IF_LINKSTATUS
#define NET_LINKSTATE		(('w'<<16) + 4)
#define NET_LADDR_ADD		(('w'<<16) + 5)
#define NET_LADDR_DEL		(('w'<<16) + 6)
#define NET_LADDR_ADD_CNT	((WAVELAN_ADDR_SIZE + sizeof(int) - 1)/sizeof(int))
#define NET_LADDR_DEL_CNT	((WAVELAN_ADDR_SIZE + sizeof(int) - 1)/sizeof(int))
#define	MAX_LINKADDR		64
#endif	IF_LINKSTATUS


/* local commands */
#define	WLCMD_CLEAR		1
#define WLCMD_SENDCMD		2
#define WLCMD_SETNWID		3
#define WLCMD_SETIRQ		4
#define WLCMD_PARAM		5
#define WLCMD_POWER_DOWN	6
#define WLCMD_POWER_UP		7


/* Allocations in general purpose software block */

#define NETW_ADDR		0x10	/* Factory network address */
#define NETW_ADDR_LOCAL		0x16	/* Local network address */
#define PSA_MAC_SELECT		0x1c	/* 0=factory, 1=local address */
#define PSA_COMP_NUMBER		0x1d	/* 0=PC-AT 915 MHz, 1=PC-MC 915 MHz
					   2=PC-AT 2.4 GHz, 3=PC-MC 2.4 GHz
					   4=PCMCIA 915 MHz */
#define PSA_THR_PRE_SET		0x1e
#define PSA_FEATURE_SELECT	0x1f
#define PSA_SUBBAND		0x20	/* 1=2425 MHz, 2=2460 MHz, 3=2484 MHz
					   4=2430.5 MHz */
#define	PSA_QUALITY_THR		0x21
#define NETW_ID			0x23	/* Network ID */
#define	PSA_NETW_ID_SELECT	0x25
#define PSA_SECURITY_SELECT	0x26
#define PSA_ENCRYPTION_KEY	0x27
#define PSA_DATABUS_WIDTH	0x2f
#define PSA_CALL_CODE		0x30
#define PSA_NWID_PREFIX		0x38
#define PSA_CONF_STATUS		0x3c
#define PSA_CRC			0x3d
#define PSA_CRC_STATUS		0x3f

/* Modem Management Controler write commands */

#define MMC_ENCR_KEY		0x00	/* to 0x07 */
#define MMC_ENCR_ENABLE		0x08
#define MMC_DES_IO_INVERT	0x0a
#define MMC_LOOPT_SEL		0x10
#define MMC_JABBER_ENABLE	0x11
#define MMC_FREEZE		0x12
#define MMC_ANTEN_SEL		0x13
#define MMC_IFS			0x14
#define MMC_MOD_DELAY		0x15
#define MMC_JAM_TIME		0x16
#define MMC_THR_PRE_SET		0x18
#define MMC_DECAY_PRM		0x19
#define MMC_DECAY_UPDAT_PRM	0x1a
#define MMC_QUALITY_THR		0x1b
#define MMC_NETW_ID_L		0x1c
#define MMC_NETW_ID_H		0x1d
#define MMC_MODE_SEL		0x1e
#define	MMC_EE_CTRL		0x20	/* frequency eeprom control */
#define	MMC_EE_ADDR		0x21	/* eeprom address */
#define	MMC_EE_DATA_LO		0x22	/* eeprom data low */
#define	MMC_EE_DATA_HI		0x23	/* eeprom data high */
#define	MMC_EXT_ANT		0x24	/* external attenna */

#define EXT_ANT_EXTANT      0x01    /* Select external antenna */
#define EXT_ANT_POL         0x02    /* Polarity of the antenna */
#define EXT_ANT_INTERNAL    0x00    /* Internal antenna */
#define EXT_ANT_EXTERNAL    0x03    /* External antenna */
#define EXT_ANT_IQ_TEST     0x1C    /* IQ test pattern (set to 0) */

#define EE_ADDR_CHANNEL    0xF0    /* Select the channel */
#define EE_ADDR_OFFSET     0x0F    /* Offset in channel data */
#define EE_ADDR_EN         0xC0    /* EE_CTRL enable operations */
#define EE_ADDR_DS         0x00    /* EE_CTRL disable operations */
#define EE_ADDR_ALL        0x40    /* EE_CTRL all operations */
#define EE_ADDR_CLEAR      0xFF    /* EE_CTRL clear operations */

#define EE_CTRL_WREN       0x04    /* Write enable */
#define EE_CTRL_WRALL      0x04    /* Write data to all addresses */
#define EE_CTRL_WDS        0x04    /* Write disable */
#define EE_CTRL_WRITE      0x05    /* Write data to address */
#define EE_CTRL_READ       0x06    /* Read */
#define EE_CTRL_CMD        0x07    /* EEprom commands : */
#define EE_CTRL_DOWNLOAD   0x08    /* Download eeprom to mmc */
#define EE_CTRL_PRE        0x10    /* Enable protected instructions */
#define EE_CTRL_PREN       0x14    /* Protect register enable */
#define EE_CTRL_PRDS       0x14    /* Protect register disable */
#define EE_CTRL_PRWRITE    0x15    /* Write addr in protect register */
#define EE_CTRL_PRREAD     0x16    /* Read addr from protect register */
#define EE_CTRL_PRCLEAR    0x17    /* Unprotect all registers */


/* MMC read register names */

#define MMC_DES_AVAIL		0x09
#define MMC_DCE_STATUS		0x10
#define MMC_CORRECT_NWID_L	0x14
#define MMC_CORRECT_NWID_H	0x15
#define MMC_WRONG_NWID_L	0x16
#define MMC_WRONG_NWID_H	0x17
#define MMC_THR_PRE_SET		0x18
#define MMC_SIGNAL_LVL		0x19
#define MMC_SILENCE_LVL		0x1a
#define MMC_SIGN_QUAL		0x1b
#define	MMC_EE_STATUS		0x20
#define	MMC_EE_DATA_LO		0x22
#define	MMC_EE_DATA_HI		0x23

#define SIOCSIFBEACON	_IOW('i', 53, struct ifbeacon)
#define SIOCGIFBEACON	_IOWR('i', 54, struct ifbeacon)
#define SIOCSIFNWID	_IOW('i', 55, struct ifnwid)
#define SIOCGIFNWID	_IOWR('i', 56, struct ifnwid)
#define SIOCGIFCNTR	_IOWR('i', 57, struct ifcntr)
#define SIOCSIFGATHER	_IOW('i', 58, struct ifgather)
#define SIOCGIFGATHER	_IOWR('i', 59, struct ifgather)
#define SIOCGIFHWADDR	_IOWR('i', 60, struct ifhwaddr)
#define SIOCGIFWFLAGS	_IOWR('i', 61, struct ifwflags)

#define DEL_BEACON		0x1
#define ADD_BEACON		0x2

#define SET_NWID 0x1
#define SET_MODE 0x2

#if !defined(IFNAMSIZ)
#define	IFNAMSIZ	16
#endif
struct ifbeacon {
	char	ifb_name[IFNAMSIZ];		/* if name, e.g. "wl0" */
	char	cmd;
	beacon_cntr beacon;
};

struct ifcntr {
	char	ifc_name[IFNAMSIZ];
	struct wl_cntrs counters;
};
	
struct ifnwid {
	char	ifn_name[IFNAMSIZ];
	u_char  cmd;
	u_char  nwid_mode;
	u_char	nwid[2];
};

struct ifgather {
	char	ifg_name[IFNAMSIZ];
	int	gather;
};

struct ifhwaddr {
	char	ifh_name[IFNAMSIZ];
	char	eth_addr[ETHER_ADDR_LEN];
};

struct ifwflags {
	char	ifw_name[IFNAMSIZ];
	int	flags;
};


/* 
 * HISTORY
 * Log: if_wlpreg.h,v $
 * Revision 1.2  1996/03/03 09:33:39  vixie
 * checked in wavelan.h and if_wlp.h from sklower
 *
 * Revision 1.1  1994/06/02  20:26:55  klemets
 * Initial revision
 *
 *
 */
/*
 * Definitions for the NCR WaveLAN PCMCIA driver.
 *
 * Copyright 1994, Anders Klemets <klemets@it.kth.se>
 *
 * This software may be freely distributed for noncommercial purposes
 * as long as this notice is retained.
 */

/*#include "ic/i82593.h"*/	/* Definitions for the Intel chip */

/* WaveLAN host interface definitions */

#define	LCCR(base)	(base)		/* LAN Controller Command Register */
#define	LCSR(base)	(base)		/* LAN Controller Status Register */
#define	HACR(base)	(base+0x1)	/* Host Adapter Command Register */
#define	HASR(base)	(base+0x1)	/* Host Adapter Status Register */
#define PIORL(base)	(base+0x2)	/* Program I/O Register Low */
#define RPLL(base)	(base+0x2)	/* Receive Pointer Latched Low */
#define PIORH(base)	(base+0x3)	/* Program I/O Register High */
#define RPLH(base)	(base+0x3)	/* Receive Pointer Latched High */
#define PIOP(base)	(base+0x4)	/* Program I/O Port */
#define MMR(base)	(base+0x6)	/* MMI Address Register */
#define MMD(base)	(base+0x7)	/* MMI Data Register */

/* HACR bit definitions */

#define HACR_LOF	  (1 << 3)	/* Lock Out Flag, toggle every 250ms */
#define HACR_PWR_STAT	  (1 << 4)	/* Power State, 1=active, 0=sleep */
#define HACR_TX_DMA_RESET (1 << 5)	/* Reset transmit DMA ptr on high */
#define HACR_RX_DMA_RESET (1 << 6)	/* Reset receive DMA ptr on high */
#define HACR_ROM_WEN	  (1 << 7)	/* EEPROM write enabled when true */

/* HASR bit definitions */

#define HASR_MMI_BUSY	(1 << 2)	/* MMI is busy when true */
#define HASR_LOF	(1 << 3)	/* Lock out flag status */
#define HASR_NO_CLK	(1 << 4)	/* active when modem not connected */

/* EECTRL bit definitions */

#define	EE_STATUS_ID		0xF0
#define	EE_STATUS_DOWNLOAD	0x08
#define	EE_STATUS_BUSY		0x04

/* Miscellaneous bit definitions */

#define PIORH_SEL_TX	(1 << 5)	/* PIOR points to 0=rx/1=tx buffer */
#define MMR_MMI_WR	(1 << 0)	/* Next MMI cycle is 0=read, 1=write */
#define PIORH_MASK	0x1f		/* only low 5 bits are significant */
#define RPLH_MASK	0x1f		/* only low 5 bits are significant */
#define MMI_ADDR_MASK	0x7e		/* Bits 1-6 of MMR are significant */

/* Attribute Memory map */

#define CIS_ADDR	0x0000		/* Card Information Satus Register */
#define PSA_ADDR	0x0e00		/* Parameter Storage Area address */
#define EEPROM_ADDR	0x1000		/* EEPROM address */
#define COR_ADDR	0x4000		/* Configuration Option Register */

/* Configuration Option Register bit definitions */

#define COR_CONFIG	(1 << 0)	/* Config Index, 0 when unconfigured */
#define COR_SW_RESET	(1 << 7)	/* Software Reset on true */

/* Local Memory map */

#define RX_BASE		0x0000		/* Receive memory, 8 kB */
#define TX_BASE		0x2000		/* Transmit memory, 2 kB */
#define UNUSED_BASE	0x2800		/* Unused, 22 kB */
#define RX_SIZE		(TX_BASE-RX_BASE)	/* Size of receive area */
#define RX_SIZE_SHIFT	6		/* Bits to shift in stop register */

#define MMI_WRITE(cmd, val) \
	while (inb(HASR(sc->wl_base)) & HASR_MMI_BUSY) ; \
	outb(MMR(sc->wl_base), ((cmd) << 1) | MMR_MMI_WR); \
	outb(MMD(sc->wl_base), val);

#define DSF_RUNNING	1

#define MOD_ENAL 1
#define MOD_PROM 2

/* 
 * HISTORY
 * Log: i82593.h,v $
 * Revision 1.2  1994/06/16  23:57:31  klemets
 * Mirrored all the fields in the configuration block.
 *
 * Revision 1.1  1994/06/02  20:25:34  klemets
 * Initial revision
 *
 */
/*
 * Definitions for Intel 82593 CSMA/CD Core LAN Controller
 * The definitions are taken from the 1992 users manual with Intel
 * order number 297125-001.
 *
 * Copyright 1994, Anders Klemets <klemets@it.kth.se>
 *
 * This software may be freely distributed for noncommercial purposes
 * as long as this notice is retained.
 */
/* Intel 82593 CSMA/CD Core LAN Controller */

/* Port 0 Command Register definitions */

/* Execution operations */
#define OP0_NOP			0	/* CHNL = 0 */
#define OP0_SWIT_TO_PORT_1	0	/* CHNL = 1 */
#define OP0_IA_SETUP		1
#define OP0_CONFIGURE		2
#define OP0_MC_SETUP		3
#define OP0_TRANSMIT		4
#define OP0_TDR			5
#define OP0_DUMP		6
#define OP0_DIAGNOSE		7
#define OP0_TRANSMIT_NO_CRC	9
#define OP0_RETRANSMIT		12
#define OP0_ABORT		13
/* Reception operations */
#define OP0_RCV_ENABLE		8
#define OP0_RCV_DISABLE		10
#define OP0_STOP_RCV		11
/* Status pointer control operations */
#define OP0_FIX_PTR		15	/* CHNL = 1 */
#define OP0_RLS_PTR		15	/* CHNL = 0 */
#define OP0_RESET		14

#define CR0_CHNL		(1 << 4)	/* 0=Channel 0, 1=Channel 1 */
#define CR0_STATUS_0		0x00
#define CR0_STATUS_1		0x20
#define CR0_STATUS_2		0x40
#define CR0_STATUS_3		0x60
#define CR0_INT_ACK		(1 << 7)	/* 0=No ack, 1=acknowledge */

/* Port 0 Status Register definitions */

#define SR0_NO_RESULT		0		/* dummy */
#define SR0_EVENT_MASK		0x0f
#define SR0_IA_SETUP_DONE	1
#define SR0_CONFIGURE_DONE	2
#define SR0_MC_SETUP_DONE	3
#define SR0_TRANSMIT_DONE	4
#define SR0_TDR_DONE		5
#define SR0_DUMP_DONE		6
#define SR0_DIAGNOSE_PASSED	7
#define SR0_TRANSMIT_NO_CRC_DONE 9
#define SR0_RETRANSMIT_DONE	12
#define SR0_EXECUTION_ABORTED	13
#define SR0_END_OF_FRAME	8
#define SR0_RECEPTION_ABORTED	10
#define SR0_DIAGNOSE_FAILED	15
#define SR0_STOP_REG_HIT	11

#define SR0_CHNL		(1 << 4)
#define SR0_EXECUTION		(1 << 5)
#define SR0_RECEPTION		(1 << 6)
#define SR0_INTERRUPT		(1 << 7)

#define SR3_EXEC_STATE_MASK	0x03
#define SR3_EXEC_IDLE		0
#define SR3_TX_ABORT_IN_PROGRESS 1
#define SR3_EXEC_ACTIVE		2
#define SR3_ABORT_IN_PROGRESS	3
#define SR3_EXEC_CHNL		(1 << 2)
#define SR3_STP_ON_NO_RSRC	(1 << 3)
#define SR3_RCVING_NO_RSRC	(1 << 4)
#define SR3_RCV_STATE_MASK	0x60
#define SR3_RCV_IDLE		0x00
#define SR3_RCV_READY		0x20
#define SR3_RCV_ACTIVE		0x40
#define SR3_RCV_STOP_IN_PROG	0x60
#define SR3_RCV_CHNL		(1 << 7)

/* Port 1 Command Register definitions */

#define OP1_NOP			0
#define OP1_SWIT_TO_PORT_0	1
#define OP1_INT_DISABLE		2
#define OP1_INT_ENABLE		3
#define OP1_SET_TS		5
#define OP1_RST_TS		7
#define OP1_POWER_DOWN		8
#define OP1_RESET_RING_MNGMT	11
#define OP1_RESET		14
#define OP1_SEL_RST		15

#define CR1_STATUS_4		0x00
#define CR1_STATUS_5		0x20
#define CR1_STATUS_6		0x40
#define CR1_STOP_REG_UPDATE	(1 << 7)

/* Receive frame status bits */

#define	RX_RCLD			(1 << 0)
#define RX_IA_MATCH		(1 << 1)
#define	RX_NO_AD_MATCH		(1 << 2)
#define RX_NO_SFD		(1 << 3)
#define RX_SRT_FRM		(1 << 7)
#define RX_OVRRUN		(1 << 8)
#define RX_ALG_ERR		(1 << 10)
#define RX_CRC_ERR		(1 << 11)
#define RX_LEN_ERR		(1 << 12)
#define RX_RCV_OK		(1 << 13)
#define RX_TYP_LEN		(1 << 15)

/* Transmit status bits */

#define TX_NCOL_MASK		0x0f
#define TX_FRTL			(1 << 4)
#define TX_MAX_COL		(1 << 5)
#define TX_HRT_BEAT		(1 << 6)
#define TX_DEFER		(1 << 7)
#define TX_UND_RUN		(1 << 8)
#define TX_LOST_CTS		(1 << 9)
#define TX_LOST_CRS		(1 << 10)
#define TX_LTCOL		(1 << 11)
#define TX_OK			(1 << 13)
#define TX_COLL			(1 << 15)


struct i82593 {
	u_char	fifo_limit : 4,
		forgnesi   : 1,
		fifo_32    : 1,
		d6mod      : 1,
		throttle_enb : 1;
	u_char	throttle   : 6,
		cntrxint   : 1,
		contin	    : 1;
	u_char	addr_len   : 3,
		acloc 	   : 1,
		preamb_len : 2,
		loopback   : 2;
	u_char	lin_prio   : 3,
		tbofstop   : 1,
		exp_prio   : 3,
		bof_met    : 1;
	u_char		   : 4,
		ifrm_spc   : 4;
	u_char		   : 5,
		slottim_low : 3;
	u_char	slottim_hi : 3,
			   : 1,
		max_retr   : 4;
	u_char	prmisc     : 1,
		bc_dis     : 1,
			   : 1,
		crs_1	   : 1,
		nocrc_ins  : 1,
		crc_1632   : 1,
			   : 1,
		crs_cdt    : 1;
	u_char	cs_filter  : 3,
		crs_src    : 1,
		cd_filter  : 3,
			   : 1;
	u_char		   : 2,
		min_fr_len : 6;
	u_char	lng_typ    : 1,
		lng_fld    : 1,
		rxcrc_xf   : 1,
		artx	   : 1,
		sarec	   : 1,
		tx_jabber  : 1,	/* why is this called max_len in the manual? */
		hash_1	   : 1,
		lbpkpol    : 1;
	u_char		   : 6,
		fdx	   : 1,
			   : 1;
	u_char	dummy_6    : 6,	/* supposed to be ones */
		mult_ia    : 1,
		dis_bof    : 1;
	u_char	dummy_1    : 1,	/* supposed to be one */
		tx_ifs_retrig : 2,
		mc_all     : 1,
		rcv_mon    : 2,
		frag_acpt  : 1,
		tstrttrs   : 1;
	u_char	fretx	   : 1,
		runt_eop   : 1,
		hw_sw_pin  : 1,
		big_endn   : 1,
		syncrqs    : 1,
		sttlen     : 1,
		tx_eop     : 1,
		rx_eop	   : 1;
	u_char	rbuf_size  : 5,
		rcvstop    : 1,
			   : 2;
};
