/*-
 * Copyright (c) 1992, 1994, 1995, 1996, 1998 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI isavar.h,v 2.12 1998/06/03 19:15:02 karels Exp
 *
 * WILDBOAR $Wildboar: isavar.h,v 1.6 1996/02/13 13:01:43 shigeya Exp $
 * 
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 */

#include <machine/frame.h>

/*
 * ISA driver attach arguments
 */
struct isa_attach_args {
	u_short	ia_iobase;		/* base i/o address */
	u_short	ia_iosize;		/* span of ports used */
	int	ia_irq;			/* interrupt request / flags */
	u_short	ia_drq;			/* DMA request */
	caddr_t ia_maddr;		/* physical i/o mem addr */
	u_int	ia_msize;		/* size of i/o memory */
	int	ia_bustype;		/* specific bus type */
	void	*ia_aux;		/* driver specific */
};

/* The following should be moved into a flags field in isa_attach_args */
#define	IOM_SHARE 0x80000000	/* ORed with ia_msize if mem can be shared */

/*
 * per-device ISA variables
 */
struct isadev {
	struct  device *id_dev;		/* back pointer to generic */
	struct	isadev *id_bchain;	/* forward link in bus chain */	
};

/*
 * ISA masterbus 
 */
struct isa_softc {
	struct	device sc_dev;		/* base device */
	struct	isadev *sc_isadev;	/* list of all children */
};

#define	LOC_IOBASE	0
#define	LOC_IOSIZE	1
#define	LOC_MADDR	2
#define	LOC_MSIZE	3
#define	LOC_IRQ		4
#define	LOC_DRQ		5
#define	LOC_BUSTYPE	6	/* one of BUS_* above */

#define	cf_iobase	cf_loc[LOC_IOBASE]
#define	cf_iosize	cf_loc[LOC_IOSIZE]
#define	cf_maddr	cf_loc[LOC_MADDR]
#define	cf_msize	cf_loc[LOC_MSIZE]
#define	cf_irq		cf_loc[LOC_IRQ]
#define	cf_drq		cf_loc[LOC_DRQ]
#define	cf_bustype	cf_loc[LOC_BUSTYPE]


/*
 * Interrupt handler chains.  Interrupt handlers should return 0 for
 * `not I', 1 (`I took care of it'), or -1 (`I guess it was mine, but
 * I wasn't expecting it').  intr_establish() inserts a handler into
 * the list.  The handler is called with its (single) argument.
 */
struct intrhand {
	int	(*ih_fun)();
	void	*ih_arg;
	u_long	ih_count;
	struct	intrhand *ih_next;
	enum devclass ih_class;
	int	ih_flags;
	int	ih_pad[2];	/* make indexing faster */
} *intrhand[32];

/*
 * Flags (set by device driver after registering interrupt
 */
#define	IH_APICLEVEL	0x0001	/* Use level triggering in APIC mode */

void isa_autoirq __P((void));
int matchbyname __P((struct device *parent, struct cfdata *cf, void *aux));
int isa_irqalloc __P((int irqmask));
int icu_read_ir __P((void));
int isa_portcheck __P((int base, int size));
void isa_portalloc __P((int base, int size));
int isa_devprobe __P((struct device *dev, struct cfdata *cf, void *aux));
int isa_devprobe_one __P((struct device *dev, struct cfdata *cf, void *aux));
int isa_probe __P((void));
int isaprint __P((void *aux, char *name));
void isa_establish __P((struct isadev *id, struct device *dev));
void intr_establish __P((int intr, struct intrhand *ih, enum devclass devtype));
void isa_intrswitch __P((struct intrframe frame));
void isa_adintr __P((struct intrframe frame));
int isa_discoverintr __P((void (*force)(), void *arg));
int isa_got_intr __P((void));
void isa_setintrmasks __P((void));
int isa_get_classmask __P((enum devclass cl));
int get_irqmask __P((int irqno));
void isa_build_nonemask __P((void));
void isa_normalirq __P((void));
void tty_net_devices __P((int change));
int isa_drqalloc __P((int drqmask));
void at_setup_dmachan __P((int chan, int maxsz));
void at_dma __P((int flags, caddr_t addr, int nbytes, int chan));
void at_dma_abort __P((int chan));
void at_dma_cascade __P((int chan));
int isa_nmi __P((int cd));
void isa_meminit __P((void));
int isa_memcheck __P((int base, int size));
int isa_memcheckmap __P((int base, int size, u_char *map));
void isa_memalloc __P((int base, int size));

int kvtop __P((caddr_t addr));

/*
 * software conventions
 */

/*
 * Bus types.  More than one type of bus can be present on a system.
 * "isa" locators contain one of these values to indicate the type
 * of bus on which the device was configured.
 */
#define	BUS_ANY		0	/* not normally used */
#define	BUS_ISA		1
#define	BUS_EISA	2
#define	BUS_MCA		3
#define	BUS_PCI		4
#define	BUS_PCMCIA	5
#define BUS_PNP		6

extern int atdevbase;		/* kernel virtual address of "hole" */
extern int eisa_present;	/* set if EISA bus is present */
extern int pci_present;		/* set if PCI bus is present */
extern int elcr_present;	/* do we have edge/level config registers */
extern int pcmcia_present;	/* set if PCMCIA slot(not bus) is present */
extern int do_pic_chk;
extern int old_nonemask;

#define	EISA_PRESENT()	(eisa_present)	/* see if EISA bus is present */
#define	PCI_PRESENT()	(pci_present)	/* see if PCI bus is present */
#define	PCMCIA_PRESENT() (pcmcia_present) /* see if PCMCIA slot is present */

/*
 * Given a kernel virtual address for some location
 * in the "hole" I/O space, return a physical address.
 */
#define	ISA_PHYSADDR(v)	((caddr_t) ((int)(v) - atdevbase + IOM_BEGIN))
/*
 * Given a physical address in the "hole",
 * return a kernel virtual address.
 */
#define	ISA_HOLE_VADDR(p)  ((caddr_t) ((int) (p) - IOM_BEGIN + atdevbase))

/* parameters for checking for I/O port and memory overlaps */
#define	ISA_NPORT_CHECK	0x400

#define	IOM_PGSHIFT	10		/* check I/O memory on 1K boundaries */
#define	IOM_PGSZ	(1 << IOM_PGSHIFT)
/* should use IOM_SIZE, but not everything includes isa.h */
#define	IOM_NPAGE	((0x100000 - 0xa0000) / IOM_PGSZ)

/* structure passed from /boot with isa-related info */
struct isaparam {
	int	isa_irqmap;
	u_char	isa_portmap[ISA_NPORT_CHECK / NBBY];
	u_char	isa_memmap[IOM_NPAGE / NBBY];
	int	pccard_iowait;	/* XXX should create struct pccardparam */
};

/* 
 * The definition of isa_type and extern isa_bustype are only supplied
 * for backwards compatability and will be removed in the future. Only
 * binary compatability is maintained. Re-compilation requires updating
 * the code to the current standard.
 */
typedef enum { OLDBUS_ISA, OLDBUS_EISA} isa_type;
extern isa_type isa_bustype;	/* type of bus */
