/*	BSDI lance.h,v 2.4 2000/05/28 00:57:07 geertj Exp	*/

#ifndef _ISA_LANCE_H
#define	_ISA_LANCE_H

/*
 * Copyright (c) 1994, 1995 Matt Thomas (matt@lkg.dec.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software withough specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * BSDI lance.h,v 2.4 2000/05/28 00:57:07 geertj Exp
 *
 * Id: lance.h,v 1.4 1995/07/13 15:12:46 thomas Exp
 *
 * Log: lance.h,v
 * Revision 1.4  1995/07/13  15:12:46  thomas
 * mask is # of bit (< 0 means from bit 31 down)
 *
 * Revision 1.3  1995/04/24  23:41:44  thomas
 * Eliminate warnings from lance.c when compiling under FreeBSD
 *
 * Revision 1.2  1995/04/24  19:03:43  thomas
 * Fix EISA DE422 support.  Correct Copyright message.
 * Remove unused fields.
 *
 * Revision 1.1  1995/04/23  22:07:13  thomas
 * Initial revision
 *
 */

typedef unsigned lance_addr_t;

typedef struct {
    caddr_t di_addr;			/* address of descriptor */
    lance_addr_t di_bufaddr;		/* LANCE address of buffer owned by descriptor */
    unsigned di_buflen;			/* size of buffer owned by descriptor */
    struct mbuf *di_mbuf;		/* mbuf being transmitted/received */
} lance_descinfo_t;

typedef struct {
    lance_descinfo_t *ri_first;		/* Pointer to first descriptor in ring */
    lance_descinfo_t *ri_last;		/* Pointer to last + 1 descriptor in ring */
    lance_descinfo_t *ri_nextin;	/* Pointer to next one to be given to HOST */
    lance_descinfo_t *ri_nextout;	/* Pointer to next one to be given to LANCE */
    unsigned ri_max;			/* Size of Ring - 1 */
    unsigned ri_free;			/* Number of free rings entires (owned by HOST) */
    lance_addr_t ri_heap;		/* Start of RAM for this ring */
    lance_addr_t ri_heapend;		/* End + 1 of RAM for this ring */
    lance_addr_t ri_outptr;		/* Pointer to first output byte */
    unsigned ri_outsize;		/* Space remaining for output */
} lance_ring_t;

typedef struct {
    struct arpcom lance_ac;		/* Common Ethernet/ARP Structure */
#define	lance_if	lance_ac.ac_if
    caddr_t lance_membase;		/* Starting memory address (virtual) */
    u_char lance_hwaddr[6];		/* local copy of hwaddr */

    unsigned lance_csr1;		/* LANCE Address of init block (low 16) */
    unsigned lance_csr2;		/* LANCE Address of init block (high 8) */
    unsigned lance_csr3;		/* Copy of CSR3 */
    unsigned lance_rap;			/* IO Port Offset of RAP */
    unsigned lance_rdp;			/* IO Port Offset of RDP */
    unsigned lance_ramoffset;		/* Offset to valid LANCE RAM */
    unsigned lance_ramsize;		/* Amount of RAM shared by LANCE */
    unsigned lance_rxbufsize;		/* Size of a receive buffer */
    ln_initb_t lance_initb;		/* local copy of LANCE initblock */
    ln_initb_t *lance_raminitb;		/* pointer to board's LANCE initblock */
    ln_desc_t *lance_ramdesc;		/* pointer to board's LANCE descriptors */
    void (*lance_input)(struct arpcom *ac, caddr_t seg1, size_t total_len,
			size_t len1, caddr_t seg2);
    int (*lance_multicast_filter)(struct arpcom *ac,
				  const int mcbits,
				  unsigned short *mctbl);
    lance_ring_t lance_rxinfo;		/* Receive ring information */
    lance_ring_t lance_txinfo;		/* Transmit ring information */
} lance_softc_t;

#if defined(__bsdi__)
typedef	void ifstart_ret_t;
#else
typedef void ifstart_ret_t;
#endif

extern int  lance_init_adapmem(lance_softc_t *sc, const unsigned skipamount);
extern int  lance_init_ring(lance_softc_t *sc, ln_ring_t *rp, lance_ring_t *ri,
			    unsigned ndescs, unsigned bufoffset,
			    unsigned descoffset);
extern void lance_hwreset(lance_softc_t *sc);
extern void lance_ifinit(void *xsc);
extern void lance_ifreset(lance_softc_t *sc);
extern void lance_intr(lance_softc_t *sc);
static int  lance_rx_intr(lance_softc_t *sc);
extern ifstart_ret_t lance_ifstart(struct ifnet *ifp);
static int  lance_tx_intr(lance_softc_t *sc);

#define	LN_BUFSIZE		304	/* 1520 / 5 */
#define	LN_TXDESC_RATIO		2048
#define	LN_DESC_MAX		128

#if LN_DOSTATS
struct {
    unsigned lance_rx_misses;
    unsigned lance_rx_badcrc;
    unsigned lance_rx_badalign;
    unsigned lance_rx_badframe;
    unsigned lance_rx_buferror;
    unsigned lance_tx_deferred;
    unsigned lance_tx_single_collisions;
    unsigned lance_tx_multiple_collisions;
    unsigned lance_tx_excessive_collisions;
    unsigned lance_tx_late_collisions;

    unsigned lance_memory_errors;
    unsigned lance_inits;
    unsigned lance_tx_intrs;
    unsigned lance_tx_nospc[2];
    unsigned lance_tx_drains[2];
    unsigned lance_tx_orphaned;
    unsigned lance_tx_adoptions;
    unsigned lance_tx_emptied;
    unsigned lance_tx_deftxint;
    unsigned lance_tx_buferror;
    unsigned lance_high_txoutptr;
    unsigned lance_low_txheapsize;
    unsigned lance_low_txfree;
    unsigned lance_tx_intr_hidescs;
    /* unsigned lance_tx_intr_descs[LN_DESC_MAX]; */

    unsigned lance_rx_intrs;
    unsigned lance_rx_badsop;
    unsigned lance_rx_contig;
    unsigned lance_rx_noncontig;
    unsigned lance_rx_intr_hidescs;
    unsigned lance_rx_ndescs[4096 / LN_BUFSIZE];
    /* unsigned lance_rx_intr_descs[LN_DESC_MAX]; */
} lance_stats;

#define	LN_STAT(stat)	(lance_stats.lance_ ## stat)
#define	LN_MINSTAT(stat, val)	(LN_STAT(stat > (val)) ? LN_STAT(stat = (val)) : 0)
#define	LN_MAXSTAT(stat, val)	(LN_STAT(stat < (val)) ? LN_STAT(stat = (val)) : 0)

#else
#define	LN_STAT(stat)		do { } while (0)
#define	LN_MINSTAT(stat, val)	do { } while (0)
#define	LN_MAXSTAT(stat, val)	do { } while (0)
#endif

#define	LN_SELCSR(sc, csrno)		outw(sc->lance_rap, csrno)
#define	LN_INQCSR(sc)			inw(sc->lance_rap)

#define	LN_WRCSR(sc, val)		outw(sc->lance_rdp, val)
#define	LN_RDCSR(sc)			inw(sc->lance_rdp)

					 
#define	LN_ZERO(sc, vaddr, len)		bzero(vaddr, len)
#define	LN_COPYTO(sc, from, to, len)	bcopy(from, to, len)

#define	LN_SETFLAG(sc, vaddr, val) \
	(((volatile u_char *) vaddr)[3] = (val))

#define	LN_PUTDESC(sc, desc, vaddr) \
	(((volatile u_short *) vaddr)[0] = ((u_short *) desc)[0], \
	 ((volatile u_short *) vaddr)[2] = ((u_short *) desc)[2], \
	 ((volatile u_short *) vaddr)[1] = ((u_short *) desc)[1])

/*
 * Only get the descriptor flags and length/status.  All else
 * read-only.
 */
#define	LN_GETDESC(sc, desc, vaddr) \
	(((u_short *) desc)[1] = ((volatile u_short *) vaddr)[1], \
	 ((u_short *) desc)[3] = ((volatile u_short *) vaddr)[3])

#endif /* _ISA_LANCE_H */
