/*
 * Copyright (c) 1991, 1994, 1996 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	pcconsioctl.h,v 2.5 2000/02/06 16:56:19 polk Exp
 */

/*
 * Structure used in mapping/unmapping ranges of I/O ports to user processes.
 */
struct iorange {
	int  iobase;		/* base ioport */
	int  cnt;		/* number of ports */
};

struct cnbell {
	enum	belltype { BEL_NONE, BEL_AUDIBLE /*, BEL_BLINK */ } type;
	int	freq;			/* hz */
	int	duration;		/* ms */
};

/*
 * structure for pcconstab key actions and resulting codes
 */
struct key {
  	u_char	action;
	u_char	code[8];
};

/*
 * The index into the array of codes for ALPHA and CHAR is constructed
 * using the mask of active modifier keys using the following values:
 */
#define	M_SHIFT		0x01
#define	M_CONTROL	0x02
#define	M_ALT		0x04

/*
 * Structure describing current keyboard map tables;
 * also used when setting a new set of tables
 * (in which cast the last three entries are ignored).
 */
struct constab {
	int	ct_constabsize;		/* size of standard mapping table */
	int	ct_extstart;		/* first extended scan code */
	int	ct_extend;		/* last extended scan code */
	int	ct_altconstabsize;	/* size of alternate mapping table */
	int	ct_maxaccent;		/* number of different accents */
	int	ct_accenttabsize;	/* size of accent table */
	struct	key *ct_constab;	/* standard mapping table */
	struct	key *ct_exttab;		/* extended scan code mapping table */
	struct	key *ct_altconstab;	/* alternate code-set mapping table */
	struct	key *ct_accenttab;	/* accent table */
};

#define	PCCONIOCRAW	_IO('G', 1)		/* turn kbd raw mode on */
#define	PCCONIOCCOOK	_IO('G', 2)		/* turn kbd raw mode off */
#define PCCONIOCSETLED	_IOW('G', 3, char)	/* set keyboard leds */
#define	PCCONIOCBEEP	_IO('G', 4)		/* kbd beep */
#define	PCCONIOCSTARTBEEP	_IOW('G', 5, short)	/* start beep */
#define	PCCONIOCSTOPBEEP	_IO('G', 6)		/* stop beep */

#define	PCCONIOCMAPPORT	_IOW('G', 7, struct iorange)	/* enable io ports */
#define	PCCONIOCUNMAPPORT _IOW('G', 8, struct iorange)	/* disable io ports */
#define	PCCONENABIOPL _IO('G', 9)	/* enable IOPL privileges */
#define	PCCONDISABIOPL _IO('G', 10)	/* disable IOPL privileges */

#define	PCCONIOCGBELL _IOR('G', 11, struct cnbell)	/* get cons bell */
#define	PCCONIOCSBELL _IOW('G', 12, struct cnbell)	/* set cons bell */

#define	PCCONIOCGSCRN _IOR('G', 13, int)	/* get my screen number */
#define	PCCONIOCGCUR  _IOR('G', 14, int)	/* get cur screen number */
#define	PCCONIOCSWTCH _IOW('G', 15, int)	/* switch to screen number */
#define	PCCONIOCSWSIG _IOW('G', 16, int)	/* signal on switch */
#define	PCCONIOCGRPT _IOR('G', 17, int)		/* get typematic (repeat) val */
#define	PCCONIOCSRPT _IOW('G', 18, int)		/* set typematic (repeat) val */
#define	PCCONIOCSCONSTAB _IOW('G', 19, struct constab) /* set key tables */
#define	PCCONIOCSWNOW _IOW('G', 20, int)	/* ready for the switch */

#define LED_SCR			0x01
#define	LED_NUM			0x02
#define LED_CAP			0x04
