/*
 * Copyright (c) 1997 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI pnp.h,v 2.1 1997/09/02 20:56:21 cp Exp
 */

#define PNP_ADDR	0x279	/* writing to this port selects PnP address */
#define PNP_WDATA	0xa79	/* data port for writing to PnP device space */

#define PNP_SETADDR(addr)       outb(PNP_ADDR, (addr))
#define PNP_WRITE(data)         outb(PNP_WDATA, (data))
#define PNP_READ()              inb(pnp_rdata)

#define PNP_A_RDATA		0x0	/* wo address to set rdata port */
#define PNP_A_ISOLATION		0x1	/* ro read in serial isolation step */
#define PNP_A_CONFIG		0x2	/* wo configuration control */
#define PNP_A_WAKE		0x3	/* wo Wake[CSN] */
#define PNP_A_RESOURCE		0x4	/* ro read in byte of resource data */
#define PNP_A_STATUS		0x5	/* ro Check if resource data ready */
#define PNP_A_CSN		0x6	/* rw current cards csn */
#define PNP_A_LDN		0x7	/* rw logical device number */


#define PNP_A_ACTIVATE		0x30	/* bit 0 */

#define IO_RANGE_CHECK		0x31	/* bit 0 
					 * 0 pattern = 0xaa 
					 * 1 pattern = 55
					 */
#define PNP_A_PORT_BASE		0x60
#define PNP_A_PORT_SIZE		2
#define PNP_A_IRQ_BASE		0x70
#define PNP_A_IRQ_SIZE		2
#define PNP_A_DRQ_BASE		0x74
#define PNP_A_DRQ_SIZE		1

/*
 * folloiwng used with PNP_A_CONFIG
 */
#define PNP_C_RESET_CSN		0x4
#define PNP_C_WAIT4KEY		0x2
#define	PNP_C_RESET		0x1

#define PNP_S_READY		0x01	/* used with PNP_A_STATUS */

/*
 * Small Resource tags
 */

#define	PNP_T_VERSION	0x1	/* Plug & Play version number */
#define PNP_T_LID	0x2	/* Logical device ID */
#define PNP_T_CID	0x3	/* Compatable device ID */
#define PNP_T_IRQ	0x4	/* IRQ format */
#define PNP_T_DMA	0x5	/* DMA format */
#define PNP_T_STARTD	0x6	/* Start dedendent function */	
#define PNP_T_ENDD	0x7	/* end dependdent function */
#define PNP_T_IO	0x8	/* I/O port descriptor */
#define PNP_T_FIO	0x9	/* Fixed-location I/O port descriptor */
#define PNP_T_VENDOR	0xE	/* Vendor defined function */
#define PNP_T_END	0xF	/* End of data */

/*
 * Large Resource tags
 */
#define PNP_T_MEMRANGE24	0x1
#define PNP_T_ANSI_ID		0x2
#define PNP_T_UNICODE_ID	0x3
#define PNP_T_LVENDOR		0x4
#define PNP_T_MEMRANGE32	0x5
#define PNP_T_MEMRANGE32F	0x6

typedef struct pnp_port
{
	u_short		prt_basemin;
	u_short		prt_basemax;
	u_short		prt_base;
	u_char		prt_alignment;
	u_char		prt_length;		
	u_char		prt_tflags;
} pnp_port_t;

typedef struct pnp_irq
{
	u_short		irq_levels;
#define irq_level irq_levels
	u_char		irq_tflags;
} pnp_irq_t;

typedef struct pnp_dma
{
	u_char		dma_drqs;
#define dma_drq dma_drqs
	u_char		dma_tflags;
} pnp_dma_t;


typedef struct pnp_compatid {
	TAILQ_ENTRY(pnp_compatid) cid_chain;
	char	cid_id[8];
} pnp_compatid_t;
	

#define PNP_N_PORT	8
#define PNP_N_IRQ	2
#define PNP_N_DRQ	2

typedef struct pnp_resource
{
	TAILQ_ENTRY(pnp_resource) res_chain;
	pnp_port_t	res_port[PNP_N_PORT];
	pnp_irq_t	res_irq[PNP_N_IRQ];
	pnp_dma_t	res_dma[PNP_N_DRQ];
	u_char		res_priority;
	struct pnp_device *res_device;	/* back pointer to device */
} pnp_resource_t;

typedef struct pnp_device
{
	TAILQ_ENTRY(pnp_device) dev_chain;
	TAILQ_HEAD(, pnp_resource) dev_dependent;
	TAILQ_HEAD(, pnp_compatid) dev_cid;
	pnp_resource_t dev_resource;
	char	dev_lid[8];
	u_short	dev_tflags;	/* flags from tag */
	u_char	dev_used;
	u_char	dev_ldn;	/* logical device number */
	u_char	dev_csn;	/* card select for card with this device */
	char	*dev_ansiid;	
} pnp_device_t;

typedef struct pnp_card {
	TAILQ_ENTRY(pnp_card)	   crd_chain;
	TAILQ_HEAD(, pnp_device) crd_dev;
	char	crd_idata[9];		/* isolation data */
	char	crd_id[8];		/* card id */
	u_char	crd_pnp_version;
	u_char	crd_vendor_version;
	char 	*crd_ansiid;
} pnp_card_t;

/*
 * Externally visible routines
 */
int pnp_assigndev __P((char **ids, char *devname, pnp_resource_t *));
void pnp_shutdown __P((pnp_resource_t *));
