/*	BSDI qcam.c,v 2.4 1998/06/03 19:15:04 karels Exp	*/

/*
 * Connectix QuickCam parallel-port camera video capture driver.
 * Copyright (c) 1996, Paul Traina.
 *
 * BSDI specific portions
 * Copyright (c) 1996, Brian J. Swetland
 *
 * This driver is based in part on work
 * Copyright (c) 1996, Thomas Davis.
 *
 * QuickCam(TM) is a registered trademark of Connectix Inc.
 * Use this driver at your own risk, it is not warranted by
 * Connectix or the authors.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer
 *    in this position and unchanged.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software withough specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include	<sys/param.h>
#include	<sys/systm.h>
#include	<sys/conf.h>
#include	<sys/device.h>
#include	<i386/isa/isa.h>
#include	<i386/isa/isavar.h>

#include	<sys/ioctl.h>
#include	<sys/uio.h>
#include	<sys/malloc.h>
#include	<sys/errno.h>

#include	<i386/isa/lpreg.h>
#include	<machine/qcam.h>
#include	"qcamreg.h"
#include	"qcamdefs.h"

int	qcam_debug = 0;

#define	QC_CONF_NODETECT 0x01		/* always assume camera is present */
#define	QC_CONF_FORCEUNI 0x02		/* force unidirectional transfers */

static int  qcam_probe(struct device *, struct cfdata *, void *);
static void qcam_attach(struct device *, struct device *, void *);
static int  qcam_intr(void *);

struct cfdriver qcamcd =
{ NULL, "qcam", qcam_probe, qcam_attach, DV_TTY, sizeof(struct qcam_softc) };

static int
qcam_probe (struct device *parent, struct cfdata *cf, void *aux)
{
	register struct isa_attach_args *ia = (struct isa_attach_args *) aux;

	if (lphook(cf->cf_unit, LPHOOK_PROBE, NULL, NULL) <= 0)
		return (0);
	ia->ia_irq = 0;
	ia->ia_iosize = 0;
	ia->ia_aux = ia;

	return 1;		/* actual check is during open */
}

static void
qcam_attach (struct device *parent, struct device *self, void *aux)
{
	struct qcam_softc *qs = (struct qcam_softc *) self;
	struct isa_attach_args *ia = (struct isa_attach_args *) aux;

	qs->iobase	 = lphook(qs->sc_dev.dv_unit, LPHOOK_PORT, NULL, NULL);
	qs->unit	 = qs->sc_dev.dv_unit;
	qs->flags |= QC_ALIVE;

	/* force unidirectional parallel port mode? */
	if (qs->sc_dev.dv_flags & QC_CONF_FORCEUNI)
		qs->flags |= QC_FORCEUNI;

/* XXX sets bidir_hw */
	qcam_reset(qs);

    	aprint_naive(": Connectix QuickCam\n");

	aprint_normal("/lp%d, %sdirectional parallel port\n",
		qs->sc_dev.dv_unit, 
		qs->flags & QC_BIDIR_HW ? "bi" : "uni");

}

static int
qcam_open (dev_t dev, int flags, int fmt, struct proc *p)
{
	struct qcam_softc *qs;
	int unit = minor(dev);
	char *msg;
	int err;
	
	if (unit >= qcamcd.cd_ndevs || (qs = qcamcd.cd_devs[unit]) == NULL)
		return ENXIO;

	if (lphook(qs->sc_dev.dv_unit, LPHOOK_ATTACH, qs, qcam_intr) <= 0) {
		dvprintf(qs, "printerport busy\n");
		return EBUSY;
	}
			
	if (!qcam_detect(qs->iobase)) {
		dvprintf(qs, "qcam not found\n");
		err = ENODEV;
		goto bad;
	}

	if (!(qs->flags & QC_ALIVE)) {
		err = ENXIO;
		goto bad;
	}

	if (qs->flags & QC_OPEN) {
		err = EBUSY;
		goto bad;
	}

	qs->buffer_end = qs->buffer = malloc(QC_MAXFRAMEBUFSIZE, M_DEVBUF,
					     M_WAITOK);

	if (!qs->buffer) {
		err = ENOMEM;
		goto bad;
	}

	qcam_reset(qs);
	qcam_default(qs);
	qs->init_req = 1;	/* request initialization before scan */

	qs->flags |= QC_OPEN;

	return 0;

bad:
	lphook(qs->sc_dev.dv_unit, LPHOOK_DETACH, NULL, NULL);
	return (err);
}

static int
qcam_close (dev_t dev, int flags, int fmt, struct proc *p)
{
	struct qcam_softc *qs = qcamcd.cd_devs[minor(dev)];

	if (qs->buffer) {
	    free(qs->buffer, M_DEVBUF);
	    qs->buffer = NULL;
	    qs->buffer_end = NULL;
	}

	lphook(qs->sc_dev.dv_unit, LPHOOK_DETACH, NULL, NULL);

	qs->flags &= ~QC_OPEN;
	return 0;
}

static int
qcam_read (dev_t dev, struct uio *uio, int ioflag)
{
	struct qcam_softc *qs = qcamcd.cd_devs[minor(dev)];
	int bytes, bufsize;
	int error;

	/* if we've seeked back to 0, that's our signal to scan */
	if (uio->uio_offset == 0)
		if (qcam_scan(qs))
			return EIO;

	bufsize = qs->buffer_end - qs->buffer;
	if (uio->uio_offset > bufsize)
		return EIO;

	bytes = min(uio->uio_resid, (bufsize - uio->uio_offset));
	error = uiomove(qs->buffer + uio->uio_offset, bytes, uio);
	if (error)
		return error;

	return 0;		/* success */
}

static int
qcam_ioctl (dev_t dev, u_long cmd, caddr_t data, int flag, struct proc *p)
{
        struct qcam_softc *qs = qcamcd.cd_devs[minor(dev)];
	struct qcam      *info = (struct qcam *)data;

	if (!data)
		return(EINVAL);

	switch (cmd) {
	case QC_GET:
		if (qcam_ioctl_get(qs, info))
			return(EINVAL);
		break;

	case QC_SET:
		if (qcam_ioctl_set(qs, info))
			return(EINVAL);
		break;

	default:
		return(ENOTTY);
	}

	return 0;
}

struct devsw qcamsw = {
    &qcamcd,
    qcam_open, qcam_close, qcam_read, nowrite, qcam_ioctl, seltrue, 
    nommap, nostrat, nodump, nopsize, 0, nostop
};

static int
qcam_intr (void *aux)
{
        printf("Spurious qcam interrupt\n");

	return 0;
}

