/*	BSDI rpvar.h,v 2.2 1998/06/03 19:15:06 karels Exp	*/

/*
 * rpvar.h --- RocketPort data structure includes
 * 
 * Written by Theodore Ts'o, 1995.
 * 
 * Copyright 1995 by Comtrol, Inc.  All Rights Reserved
 */

#define RP_UNIT(x) dv_unit(x)
#define RP_PORT(x) (dv_subunit(x) & 0x3f)
#define IS_CALLOUT(x) (dv_subunit(x) & 0x80)

#define	DEV_TO_SC(d)	((struct rp_softc *)rpcd.cd_devs[RP_UNIT((d))])
#define DEV_TO_RP(d)	(DEV_TO_SC((d))->sc_ports + RP_PORT((d)))
#define DEV_TO_TP(d)	(DEV_TO_RP((d))->rp_tty)

struct rp_port {
	struct tty *		rp_tty;
	struct rp_softc *	rp_sc;
	int			rp_port;
	int			rp_flags;
	int			rp_unit:2;
	int			rp_aiop:2;
	int			rp_chan:3;
	int			rp_intmask;
	int			rp_imask; /* Input mask */
	int			rp_fifo_lw;
	int			rp_restart;
	int			rp_overflows;
	int			rp_rts_iflow:1;
	int			rp_disable_writes:1;
	int			rp_cts:1;
	int			rp_waiting:1;
	int			rp_xmit_stopped:1;
	CONTROLLER_t *		rp_ctlp;
	CHANNEL_t 		rp_channel;
};

struct rp_softc {
    struct device	sc_dev;
    struct isadev	isa_dev;
    struct intrhand	sc_ih;

    int			sc_base;
    struct selinfo	sc_wsel;	/* Selecting process for write */

    int			sc_nports;
    struct rp_port	*sc_ports;
    struct ttydevice_tmp sc_ttydev; /* tty stuff */
    int			sc_map[MAX_PORTS_PER_BOARD];
    CONTROLLER_t 	*sc_ctlp;
};

