/*	BSDI rtc.h,v 2.3 2000/03/09 04:55:01 prb Exp	*/

/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * William Jolitz.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)rtc.h	8.1 (Berkeley) 6/11/93
 */

/*
 * RTC Register locations
 */

#define RTC_SEC		0x00	/* seconds */
#define RTC_SECALRM	0x01	/* seconds alarm */
#define RTC_MIN		0x02	/* minutes */
#define RTC_MINALRM	0x03	/* minutes alarm */
#define RTC_HRS		0x04	/* hours */
#define RTC_HRSALRM	0x05	/* hours alarm */
#define RTC_WDAY	0x06	/* week day */
#define RTC_DAY		0x07	/* day of month */
#define RTC_MONTH	0x08	/* month of year */
#define RTC_YEAR	0x09	/* month of year */
#define RTC_STATUSA	0x0a	/* status register A */
#define  RTCSA_TUP	0x80	/* time update, don't look now */
#define  RTCSA_DIV	0x70	/* divider select field */
#define  RTCSA_DIV_32K	0x20	/* divider select, 32768 Hz */
#define  RTCSA_RATE	0x0f	/* rate select field */
#define  RTCSA_RATE_1K	0x06	/* 1024 Hz rate select */
#define  RTCSA_RATE_128	0x09	/* 128 Hz rate select */


#define RTC_STATUSB	0x0b	/* status register B */
#define  RTCSB_ABORT	0x80	/* abort update cycle */
#define  RTCSB_PIE	0x40	/* Periodic Interrupt Enable */
#define  RTCSB_AIE	0x20	/* Alarm Interrupt Enable */
#define  RTCSB_UIE	0x10	/* Update-Ended Interrupt Enable */
#define  RTCSB_SQWE	0x08	/* SQuare Wave Enable */
#define  RTCSB_DM	0x04	/* Date Mode, 0=binary, 1=BCD */
#define  RTCSB_24HR	0x02	/* 12/24 hour mode, 0=12, 1=24 */
#define  RTCSB_DSE	0x01	/* Daylight Savings Enabled */

#define RTC_INTR	0x0c	/* status register C (R) interrupt source */
#define  RTCIR_UPDATE	 0x10	/* update intr */
#define  RTCIR_ALARM	 0x20	/* alarm intr */
#define  RTCIR_PERIOD	 0x40	/* periodic intr */
#define  RTCIR_INT	 0x80	/* interrupt output signal */

#define RTC_STATUSD	0x0d	/* status register D (R) Lost Power */
#define  RTCSD_PWR	 0x80	/* clock lost power */

#define RTC_DIAG	0x0e	/* status register E - bios diagnostic */
#define RTCDG_BITS	"\020\010clock_battery\007ROM_cksum\006config_info\005memory_size\004fixed_disk\003invalid_time\002EISA_config\001adapter_timeout"

#define RTC_RESET	0x0f	/* status register F - reset code byte */
#define	 RTCRS_RST	 0x00		/* normal reset */
#define	 RTCRS_LOAD	 0x04		/* load system */
#define	 RTCRS_WARM	 0x0a		/* warm start at 40:67 */

#define RTC_FLOPPY	0x10	/* diskette drives A and B types */
#define RTC_DISKTYPE	0x12	/* fixed drives C and D types, F = extended */
#define RTC_EQUIP	0x14	/* equipment byte */
#define RTC_BASELO	0x15	/* low byte of basemem size */
#define RTC_BASEHI	0x16	/* high byte of basemem size */
#define RTC_EXTLO	0x17	/* low byte of extended mem size */
#define RTC_EXTHI	0x18	/* low byte of extended mem size */
#define RTC_EDISKTYPE0	0x19	/* extended disk type, fixed drive 0 */
#define	RTC_CSUM_LO	0x2e	/* Checksum lo (bytes 0x10 through 0x2d) */
#define	RTC_CSUM_HI	0x2f	/* Checksum hi */
#define RTC_EDISKTYPE1	0x1a	/* extended disk type, fixed drive 1 */

#define RTC_CENTURY	0x32	/* current century - please increment in Dec99*/
