/*-
 * Copyright (c) 1996 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI wdpivar.h,v 2.1.20.1 2001/05/09 22:03:21 seebs Exp
 */

typedef struct wdpi_softc {
	struct	spi_hba wdpi_hba;	/* Common SCSI HBA device info */
	struct	device *wdpi_parent;	/* Controller device (shortcut) */
	int	wdpi_state;		/* Interrupt state */
	wdc_req_t wdpi_req;		/* Controller request block */
	int	wdpi_iobase;		/* Base I/O address */
	u_char	wdpi_polldrq;		/* Poll for DRQ flag */
	int	wdpi_selunit;		/* Unit select word */
	int	wdpi_io;		/* Read flag */
	int	wdpi_iodelay;		/* Broken drive I/O delay */
	struct  wddma_ops *wdpi_dmaops; /* hooks for DMA */
	int	wdpi_dma;		/* DMA related flags */
	u_char	wdpi_channel;		/* pri/sec channel for DMA ctlr */
	u_char	wdpi_unit;		/* physical unit number */

	struct buf *wdpi_curbp;		/* Current bp in chain */
	int	wdpi_xfr_resid;		/* Bytes left in complete transfer */
	int	wdpi_resid;		/* Bytes left in this bp */
	caddr_t	wdpi_addr;		/* Current location in memory */

	scp_t	*wdpi_scp;		/* SCP we are currently servicing */

	/* Changer related variables */
	int	wdpi_nslot;		/* Number of changer slots */
	int	wdpi_curslot;		/* Current changer slot */
	int	wdpi_chg_errcnt;	/* Changer retry counter */
	int	wdpi_immed;		/* Changer ops: immediate or async */
	int	wdpi_sss;		/* Software slot select flag */
	scp_t	*wdpi_wscp;		/* Work SCP (used for changer cmds) */
	scp_t	*wdpi_pscp;		/* Pending SCP (while changing) */
	struct scsi_sense wdpi_sd;	/* Sense data */
} wdpi_softc_t;

/* wdpi_softc_t.wdpi_polldrq */
#define	POLL_IRQ	0		/* Wait for interrupt */
#define	POLL_IGNORE	1		/* Poll, ignore interrupt */
#define	POLL_NOIRQ	2		/* Poll, no interrupt expected */

/* wdpi_softc_t.wdpi_state */
#define	WDPI_IDLE		0	/* Nothing happening */
#define	WDPI_WAIT_CMDDRQ	1	/* Waiting for packet DRQ */
#define	WDPI_WAIT_XFR		2	/* Waiting for data transfer */

/* wdpi_dma */
#define WDPI_DMA_ENABLED	0x1	/* DMA enabled on this device */
#define WDPI_DMA_ACTIVE		0x2	/* DMA transfer active */

/* SCSI commands of interest */
#define	CMD_MECHSTAT	0xbd		/* Mechanism status */
#define	CMD_CDLOAD	0xa6		/* Load/Unload CD */

/* Mode pages of interest */
#define SCSI_MS_CDCAP	0x2a    /* CD-ROM Capabilities and Mech Status */

/* CD-ROM Capabilities and Mechanical Status Page */
struct scsi_page_cdcap {
	u_char	page_code:6,		/* 0x2a */
		na1:1,
		ps:1;			/* parameter saveable */
	u_char	page_len;
	u_char	cdr_rd:1,		/* orange book part II, read */
		cde_rd:1,		/* orange book part III, read */
		meth2:1,		/* fixed packet trks, method II */
		na2:5;
	u_char	cdr_wr:1,		/* orange book part II, write */
		cde_wr:1,		/* orange book part III, write */
		na3:6;
	u_char	audio_play:1,		/* audio play */
		composite:1,		/* composite audio/video */
		dig1:1,			/* digital port 1 */
		dig2:1,			/* digital port 2 */
		m2f1:1,			/* mode 2 form 1 */
		m2f2:1,			/* mode 2 form 2 */
		multi_sess:1,		/* multi-session */
		na4:1;
	u_char	cdda:1,			/* reads red book */
		cdda_sia:1,		/* red book data is accurate */
		rwsup:1,		/* returns R-W subchannel data */
		rwcorr:1,		/* R-W deinterleaved/corrected */
		c2ptrs:1,		/* C2 error pointers supported */
		isrc:1,			/* reads Intl Std Recording Code */
		upc:1,			/* reads UPC (Media Catalog Number) */
		na5:1;
	u_char	lock:1,			/* Able to lock media */
		lock_state:1,		/* Media locked */
		prevent:1,		/* prevent jumper installed */
		eject:1,		/* Can eject media */
		na6:1,
		mech_type:3;		/* Loading mechanism type */
	u_char	sep_vol:1,		/* Channel volume independent */
		sep_mute:1,		/* Channel mute independent */
		sdp:1,			/* Supports disc present */
		sss:1,			/* Software slot selection */
		na7:4;
	u_char	maxspeed_hi,		/* Max xfr speed (10^3bytes/sec) */
		maxspeed_lo;
	u_char	nvol_hi,		/* Number of volume levels supported */
		nvol_lo;
	u_char	bufsize_hi,		/* Drive buffer size */
		bufsize_lo;
	u_char	curspeed_hi,		/* Current xfr speed (10^3bytes/sec) */
		curspeed_lo;
	u_char	na8;
	u_char	na9:1,			/* -- Digital output signal format --*/
		bckf:1,			/* data on falling edge of BCK */
		rck:1,			/* LRCK indicates left channel */
		lsbf:1,			/* LSB sent first */
		len:2,			/* # of BCK's/word */
		na10:2;
	u_char	na11,
		na12;
};

/* scsi_page_cdcap.type */
#define	MTYPE_CADDY	0x0		/* Caddy type loading mechanism */
#define	MTYPE_TRAY	0x1		/* Tray type loading mechanism */
#define	MTYPE_POPUP	0x2		/* Pop-up type loading mechanism */
#define	MTYPE_ICHANGE	0x4		/* Individually changeable changer */
#define	MTYPE_CCHANGE	0x5		/* Cartridge changer */

/* Mechanism status command */
struct scsi_cdb_mstat {
	u_char	cdb_cmd,	/* 0xa6 */
		cdb_xxx[7],
		cdb_lenh,	/* allocation length (MSB) */
		cdb_lenl,	/* allocation length (LSB) */
		cdb_xx2[2];
};

/* Mechanism status header */
struct scsi_mech_header {
	u_char	slot:5,			/* Current slot */
		cstate:2,		/* Changer state */
		fault:1;		/* Changer fault */
	u_char	na1:5,
		mstate:3;		/* Mechanism state */
	u_char	clba_hi,		/* Current LBA */	
		clba_mid,
		clba_lo;
	u_char	nslot;			/* Number of slots in changer */
	u_char	slot_size_hi,		/* Length of slot tables */
		slot_size_lo;
};

/* Status for each slot in changer */
struct scsi_mech_slot {
	u_char	change:1,
		na:6,
		present:1;
	u_char	na2[3];
};

/* Load/unload CD command */
struct scsi_cdb_loun {
	u_char	cdb_cmd,	/* 0xa6 */
		cdb_imm,	/* immediate flag */
		cdb_xxx[2],
		cdb_loun,	/* load/unload, start flags */
		cdb_xx2[3],
		cdb_slot,	/* changer slot number */
		cdb_xx3[3];
};

#define	IMM_IMMED	0x01	/* Do not wait until mechanism finishes */
#define	LOUN_ABORT	0x00	/* Abort current operation */
#define	LOUN_UNLOAD	0x02	/* Unload media */
#define LOUN_SELECT	0x03	/* Load/select slot */

/* Prototypes */
void wchg_attach __P((wdpi_softc_t *sc));
void wdpi_hbareset __P((spi_hba_t *hba));

/* Parameters */
#define	WDPI_MAXSLOT		256	/* Max number of supported slots */
/*    Max size of a response buffer in changer code */
#define	WDPI_CHGBUF		(WDPI_MAXSLOT * sizeof(struct scsi_mech_slot) +\
				    sizeof(struct scsi_mech_header))
#define	WDPI_CHG_MAXTRY		5	/* Max number of UNIT attn retries */
#define	WDPI_CHG_RDY_DELAY	500000	/* 500ms delay waiting for ready */
#define	WDPI_CHG_MAXRDY		20	/* # of RDY Delays to wait for drive */
