/*-
 * Copyright (c) 1994, 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI wdreg.h,v 2.5 2000/09/19 21:29:11 deha Exp
 */

/*-
 * Copyright (c) 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * William Jolitz.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)wdreg.h	8.1 (Berkeley) 6/11/93
 */

/*
 * Disk Controller register definitions.
 */
#define	wd_data		0x0		/* data register (R/W - 16 bits) */
#define	wd_error	0x1		/* error register (R) */
#define	wd_precomp	wd_error	/* write precompensation (W) */
#define	wd_seccnt	0x2		/* sector count (R/W) */
#define	wd_sector	0x3		/* first sector number (R/W) */
#define	wd_cyl_lo	0x4		/* cylinder address, low byte (R/W) */
#define	wd_cyl_hi	0x5		/* cylinder address, high byte (R/W)*/
#define	wd_sdh		0x6		/* sector size/drive/head (R/W)*/
#define	wd_command	0x7		/* command register (W)	 */
#define	wd_status wd_command		/* immediate status (R)	 */
#define	WD_NPORT 	8	/* number of ports, ignoring the following */

/*
 * Alternate registers access via floppy controller on ISA systems, these
 * are accessed by adding the controller base address (usually 0x1f0 or 0x170)
 * to either wdalt_norm or wdalt_pcmcia and wd_ctlr or wd_digin.
 */
#define wdalt_norm	0x206	/* Standard offset */
#define wdalt_pcmcia	0x00e	/* Offset on some PCMCIA cards */
#define	wda_altsts	0x0	/* alternate fixed disk status(via 1015) (R) */
#define	wda_ctlr	0x0	/* fixed disk controller control(via 1015) (W)*/
#define	wda_digin	0x1	/* disk controller input(via 1015) (R) */
#define WD_NALT		2		/* Number of alternate registers */

/*
 * ATAPI register defs
 */
#define	wd_feature	0x1		/* features register */
#define	wd_ireason	0x2		/* interrupt reason */
#define	wd_bcnt		0x4		/* byte count register (word) */

/*
 * wd_feature bits
 */
#define	WDFT_DMA	0x01		/* Enable DMA */

/* feature defs for WDCC_SETFEAT */
#define	WDFT_SETXMODE	0x03		/* Set transfer mode */


/*
 * wd_ireason bits
 */
#define	WDIR_COD	0x01		/* Command/data */
#define	WDIR_IO		0x02		/* Transfer direction */

/*
 * Status Bits.
 */
#define	WDCS_BUSY	0x80		/* Controller busy bit. */
#define	WDCS_READY	0x40		/* Selected drive is ready */
#define	WDCS_WRTFLT	0x20		/* Write fault */
#define	WDCS_SEEKCMPLT	0x10		/* Seek complete */
#define	WDCS_DRQ	0x08		/* Data request bit. */
#define	WDCS_ECCCOR	0x04		/* ECC correction made in data */
#define	WDCS_INDEX	0x02		/* Index pulse from selected drive */
#define	WDCS_ERR	0x01		/* Error detect bit. */

#define	WDCS_BITS	"\020\010busy\007rdy\006wrtflt\005seekdone\004drq\003ecc_cor\002index\001err"

/*
 * Error register bits.
 * Some of these are different in the original Western Digital AT controller
 * and in IDE.
 */
#define	WDERR_BAD	0x80		/* block formatted as "bad" */
#define	WDERR_UNCORR	0x40		/* uncorrectable data error */
#define	WDERR_ID_CRC	0x20		/* CRC in ID field */
#define	WDERR_MCHG	0x20		/* media changed */
#define	WDERR_NO_ID	0x10		/* sector ID not found */
#define	WDERR_MCHGRQ	0x08		/* media change request */
#define	WDERR_ABORT	0x04		/* command aborted */
#define	WDERR_TR0	0x02		/* track 0 not found */
#define	WDERR_NODAM	0x01		/* data address mark not found */

#define	WDERR_BITS	"\020\010badblk\007uncorr\006idcrc/mchg\005no_id\003abort\002tr000\001no_dam"

/*
 * Error register bits for ATAPI
 */
#define	WDERR_ILI	0x01		/* Illegal length indication */
#define	WDERR_EOM	0x02		/* End of media detected */
					/* Abort/media change same as above */
#define	WDERR_SKEY_MASK	0xf0		/* Sense key mask */
#define	WDERR_SKEY_SHFT	4

/*
 * Standard and ATA commands
 */
#define	WDCC_NOP	0x00		/* nop/invalid command */
#define	WDCC_READ	0x20		/* disk read code */
#define	WDCC_WRITE	0x30		/* disk write code */
#define	WDCC_RESTORE	0x10		/* disk restore code -- resets cntlr */
#define	WDCC_FORMAT	0x50		/* disk format code */
#define	WDCC_SETGEOM	0x91		/* set disk geometry */
#define	WDCC_WMULT	0xc5		/* write multiple */
#define	WDCC_SETMULT	0xc6		/* set multiple mode */
#define	WDCC_RMULT	0xc4		/* read multiple */
#define	WDCC_READP	0xec		/* read parameters from controller */
#define	WDCC_RDMA	0xc8		/* read using DMA */
#define	WDCC_WDMA	0xca		/* write using DMA */
#define WDCC_SETFEATURES 0xef		/* set features */

/*
 * ATAPI commands
 */
#define	WDCC_RESET	0x08		/* ATAPI soft reset */
#define	WDCC_PACKET	0xa0		/* Initiate packet command */
#define	WDCC_IDENT	0xa1		/* ATAPI version of Identify Device */
#define	WDCC_SETFEAT	0xef		/* Set features */

/*
 * Bits for wd_sdh register
 */
#define	WDSD_IBM	0xa0		/* forced to 512 byte sector, ecc */
#define	WDSD_LBA	0x40		/* use LBA addessing */

/*
 * Bits for wd_ctlr control register
 */
#define	WDCTL_IDIS	0x02		/* Disable interrupt */
#define	WDCTL_RESET	0x04		/* reset controller */
#define	WDCTL_HEAD3ENB	0x08		/* enable head-select 3 signal */

/*
 * Misc config
 */
#define	WD_MAXDRV	2		/* max drives per controller */
#define	WD_SECSIZE	512		/* bytes per sector */
#define	WD_SECSHFT	9		/* log2(WD_SECSIZE) */
#define	WD_STEP		0		/* winchester- default 35us step */

#ifndef LOCORE
/*
 * The following was derived from NetBSD driver (now much modified).
 * read parameters command returns this:
 */
struct wdparams {
	/* drive info */
	u_short	wdp_config;		/* general configuration */
	u_short	wdp_fixedcyl;		/* number of non-removable cylinders */
	u_short	wdp_removcyl;		/* number of removable cylinders */
	u_short	wdp_heads;		/* number of heads */
	u_short	wdp_unfbytespertrk;	/* number of unformatted bytes/track */
	u_short	wdp_unfbytes;		/* number of unformatted bytes/sector */
	u_short	wdp_sectors;		/* number of sectors */
	u_short	wdp_minisg;		/* minimum bytes in inter-sector gap*/
	u_short	wdp_minplo;		/* minimum bytes in postamble */
	u_short	wdp_vendstat;		/* number of words of vendor status */
	/* controller info */
	char	wdp_cnsn[20];		/* controller serial number */
	u_short	wdp_cntype;		/* controller type */
#define	WDTYPE_SINGLEPORTSECTOR	1	 /* single port, single sector buffer */
#define	WDTYPE_DUALPORTMULTI	2	 /* dual port, multiple sector buffer */
#define	WDTYPE_DUALPORTMULTICACHE 3	 /* above plus track cache */
	u_short	wdp_cnsbsz;		/* sector buffer size, in sectors */
	u_short	wdp_necc;		/* ecc bytes appended */
	char	wdp_rev[8];		/* firmware revision */
	char	wdp_model[40];		/* model name */
	u_short	wdp_nsecperint;		/* max sectors per interrupt */
	u_short	wdp_usedmovsd;		/* can use double word read/write? */
	u_short	wdp_capabilities;	/* can use LBA, DMA? */
#define	WDCAP_DMA	0x100
#define	WDCAP_LBA	0x200		/* logical block addressing */
	u_short	wdp_res50;
	u_short	wdp_piotime;
	u_short	wdp_dmatime;
	u_short	wdp_curvalid;		/* bit 0 set if next 5 are valid */
	u_short	wdp_curcyl;		/* current number of cylinders */
	u_short	wdp_curheads;		/* current number of heads */
	u_short	wdp_cursect;		/* current number of sectors/track */
	u_short	wdp_curcap0;		/* current number of sectors, low */
	u_short	wdp_curcap1;		/* current number of sectors, high */
	u_short	wdp_multsec;		/* current sectors/interrupt */
#define	WDMULT_VALID	0x100		/* wdp_multsec is valid */
#define	WDMULT_VALUE	0x0ff		/* if valid, current sectors/intr */
	u_long	wdp_lbacap;		/* capacity in LBA mode */
	u_short	wdp_sdmamode;		/* single word DMA modes */
	u_short	wdp_ddmamode;		/* multiword DMA modes */
};
#endif

/*
 * wdp_config bits for ATAPI
 */
#define	WDPI_PROTO_ATAPI	0x8000	/* ATAPI protocol bit */
#define	WDPI_DEVT_MASK		0x1f00	/* Device type */
#define	WDPI_DEVT_SHFT		8
#define	WDPI_REMOVEABLE		0x0080	/* Media is removable */
#define	WDPI_DRQT_MASK		0x0060	/* DRQ type mask */
#define	WDPI_DRQT_SHFT		5
#define	WDPI_MICRO_DRQ		0
#define	WDPI_INTR_DRQ		1
#define	WDPI_ACCEL_DRQ		2
