/*-
 * Copyright (c) 1995, 2000 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI wdvar.h,v 2.5 2000/10/13 19:26:12 karels Exp
 */

/*
 * This structure represents a unit that wants/has access to wdc hardware.
 */
typedef void (*wdc_gofunc)(struct device *self);
typedef int (*wdc_intrfunc)(struct device *self);

typedef struct wdc_req {
	struct wdc_req *next;	/* Next entry on controller queue */
	wdc_intrfunc	intr;	/* Interrupt function */
	wdc_gofunc	tout;	/* Timeout function */
	wdc_gofunc	go;	/* Grant function */
	struct	device *self;	/* Device requesting access (passed to funcs) */
	int	timeout;	/* Timeout counter (seconds) */
} wdc_req_t;

/*
 * Callback block (used to register for controller reset events)
 */
typedef struct wdc_callback {
	struct wdc_callback *next;
	wdc_gofunc	func;
	void		*arg;
} wdc_callback_t;

#define WDC_UNALLOC	((wdc_req_t *)0xdeadbeef)

/*
 * Probe/attach arguments for children of wdc
 */
typedef struct wdc_attach_args {
	int	channel;	/* Channel (pri/sec) */
	int	drive;		/* Drive number */
	int	found;		/* Someone claimed this drive */
	struct	wddma_ops *dmaops;	/* DMA hooks */
} wdc_attach_args_t;

#define LOC_DRIVE	0	/* Drive locator index */

/* hooks between "controller"/disk drivers and DMA support */
struct wddma_ops {
	int	(*wddma_init)(struct device *, int, int, void *);
	int	(*wddma_setup)(struct device *, int, int,
		char *, long, int, int, int);
	void	(*wddma_start)(struct device *, int);
	int	(*wddma_intr)(struct device *, int);
	int	(*wddma_done)(struct device *, int);
};

void	wdc_attach_reset __P((struct device *self, wdc_callback_t *cb));
int	wdc_getiobase __P((struct device *self));
int	wdc_getaiobase __P((struct device *self));
void	wdc_request __P((struct device *self, wdc_req_t *req));
void	wdc_release __P((struct device *self));
void	wdc_getctl __P((struct device *self));
int	wdc_pollintr __P((struct device *self, int timeout));
char	*ata_mode2str __P((int mode));
