/*
 * Copyright (c) 1997, Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	AMD 79c790a PCnet-PCI II definitions
 *
 * swiped from sys/i386/isa/ic/am7990.h
 *
 * BSDI am79c970a.h,v 1.3.16.2 2001/04/18 23:18:42 geertj Exp
 *
 */

#if defined(BYTE_ORDER) && BYTE_ORDER == BIG_ENDIAN
#define	LN_BITFIELD2(a, b)		      b, a
#define	LN_BITFIELD3(a, b, c)		   c, b, a
#define	LN_BITFIELD4(a, b, c, d)	d, c, b, a
#else
#define	LN_BITFIELD2(a, b)		a, b
#define	LN_BITFIELD3(a, b, c)		a, b, c
#define	LN_BITFIELD4(a, b, c, d)	a, b, c, d
#endif

#define	LN_MC_MASK		0x3F	/* Only 6 bits of the CRC */
#define	LN_MC_BITS		-6	/* High 6 bits */

typedef struct {
	u_int32_t	pcn_mode:16,
				:4,
			rlen	:4,	/* receive ring size */
				:4,
			tlen	:4;	/* transmit ring size */
/* Mode register (must be STOPPED to change) */
#define	LN_MODE			0x000f	/* CSR15 Mode */
#define	LN_MODE_DRX		0x0001	/* (RW) Disable receiver */
#define	LN_MODE_DTX		0x0002	/* (RW) Disable transmitter */
#define	LN_MODE_LOOP		0x0004	/* (RW) Loopback enable */
#define	LN_MODE_DXMTFCS		0x0008	/* (RW) Disable xmit FCS */
#define	LN_MODE_FCOLL		0x0010	/* (RW) Force collision */
#define	LN_MODE_DRTY		0x0020	/* (RW) Disable retry */
#define	LN_MODE_INTL		0x0040	/* (RW) Internal loopback */
#define	LN_MODE_PORTSELM	0x0180	/* (RW) Port select mask */
#define	LN_MODE_PORTSEL_A	0x0000	/* (RW) Port select AUI */
#define	LN_MODE_PORTSEL_T	0x0080	/* (RW) Port select 10baseT */
#define	LN_MODE_PORTSEL_G	0x0100	/* (RW) Port select GPSI */
#define	LN_MODE_TSEL_LRT	0x0200	/* (RW) Transmit mode select(AUI)/Low
					   receive threshold(10baseT) */
#define	LN_MODE_MENDECL		0x0400	/* (RW) MENDEC loopback mode */
#define	LN_MODE_DAPC		0x0800	/* (RW) Disable auto-polarity(10baseT)*/
#define	LN_MODE_DLNKTST		0x1000	/* (RW) Disable link status */
#define	LN_MODE_DRCVPA		0x2000	/* (RW) Disable rcv physical addr */
#define	LN_MODE_DRCVBC		0x4000	/* (RW) Disable rcv broadcast addr */
#define	LN_MODE_PROM		0x8000	/* (RW) Promiscuous mode */
	u_char		pcn_physaddr[8];
	u_char		pcn_multi_mask[8];
	u_int32_t	pcn_rxring;
	u_int32_t	pcn_txring;
} pcn_initb_t;

/*
 * memory based descriptor for PCnet PCI II software style
 */
#define	LN_DMD0_TxTRC	0x0000000F	/* (R )  Transmit - Retry count */
#define	LN_DMD0_TxTDR	0x03FF0000	/* (R )  Transmit - Time Domain Reflectometer */
#define	LN_DMD0_TxRTRY	0x04000000	/* (R )  Transmit - Retry error */ 
#define	LN_DMD0_TxLCAR	0x08000000	/* (R )  Transmit - Carrier Loss */
#define	LN_DMD0_TxLCOL	0x10000000	/* (R )  Transmit - Late Collision */
#define	LN_DMD0_TxEXDEF 0x20000000	/* (R )  Transmit - Excessive deferral */
#define	LN_DMD0_TxUFLO	0x40000000	/* (R )  Transmit - Underflow */
#define	LN_DMD0_TxBUFF	0x80000000	/* (R )  Transmit - Buffer Error */
#define	LN_DMD0_RxMCNT	0x00000FFF 	/* (R )  Receive - msg byte count */
#define	LN_DMD0_RxRPC	0x00FF0000	/* (R )  Receive - Runt packet count */
#define	LN_DMD0_RxRCC	0xFF000000	/* (R )  Receive - Collision count */

#define	TxTDRSHFT	16

#define	LN_DMD1_BCNT	0x00000FFF 	/* (RW)  Buffer byte count */
#define	LN_DMD1_ONES	0x0000F000 	/* (RW)  MUST BE ONES */
#define	LN_DMD1_BAM	0x00100000 	/* (R )  Broadcast addr match */
#define	LN_DMD1_LAFM	0x00200000 	/* (R )  Logical addr match */
#define	LN_DMD1_PAM	0x00400000 	/* (R )  Physical addr match */
#define	LN_DMD1_BPE	0x00800000 	/* (R )  Bus parity error */
#define	LN_DMD1_EOP	0x01000000 	/* (RW)  End Of Packet */
#define	LN_DMD1_SOP	0x02000000	/* (RW)  Start Of Packet */
#define	LN_DMD1_RxBUFF 0x04000000	/* (R )  Receive  - Buffer Error */
#define	LN_DMD1_TxDEF	0x04000000	/* (R )  Transmit - Deferred */
#define	LN_DMD1_RxCRC	0x08000000	/* (R )  Receive  - Bad Checksum */
#define	LN_DMD1_TxONE	0x08000000	/* (RW)  Transmit - One retry needed */
#define	LN_DMD1_TxADDFCS 0x10000000	/* (RW)  Transmit - Add FCS */
#define	LN_DMD1_RxOFLO 0x10000000	/* (R )  Receive  - Overflow Error */
#define	LN_DMD1_RxFRAM 0x20000000	/* (R )  Receive  - Framing Error */
#define	LN_DMD1_TxMORE 0x20000000	/* (R )  Transmit - More retry needed */
#define	LN_DMD1_ERR	0x40000000	/* (R )  Error Summary */
#define	LN_DMD1_OWN	0x80000000	/* (RW)  Owner (1=PCnet, 0=host) */

typedef struct {
	u_int32_t	d_addr;
	u_int32_t	d_md1;
	u_int32_t	d_md0;
	u_int32_t	d_reserved;
} pcn_desc_t;

typedef union {
	struct word_regmap {
		unsigned char adprom[16];
		u_int16_t rdp;
		u_int16_t rap;
		u_int16_t reset;
		u_int16_t bdp;
		u_int16_t reserved;
	} word;
	struct dword_regmap {
		u_int32_t adprom[4];
		u_int32_t rdp;
		u_int32_t rap;
		u_int32_t reset;
		u_int32_t bdp;
	} dword;
} pcn_regmap_t;



#define	LN_CSR0			0x0000

#define	LN_CSR0_INIT		0x0001	/* (RS)  Initialize Am 7990 */
#define	LN_CSR0_STRT		0x0002	/* (RS)  Start Am7990 */
#define	LN_CSR0_STOP		0x0004	/* (RS)  Reset Am7990 */
#define	LN_CSR0_TDMD		0x0008	/* (RS)  Transmit On Demand */
#define	LN_CSR0_TXON		0x0010	/* (R )  Transmitter Enabled */
#define	LN_CSR0_RXON		0x0020	/* (R )  Receiver Enabled */
#define	LN_CSR0_IENA		0x0040	/* (RW)  Interrupt Enabled */
#define	LN_CSR0_INTR		0x0080	/* (R )  Interrupt Pending */
#define	LN_CSR0_IDON		0x0100	/* (RC)  Initialization Done */
#define	LN_CSR0_TINT		0x0200	/* (RC)  Transmit Interrupt */
#define	LN_CSR0_RINT		0x0400	/* (RC)  Receive Interrupt */
#define	LN_CSR0_MERR		0x0800	/* (RC)  Memory Error */
#define	LN_CSR0_MISS		0x1000	/* (RC)  No Available Receive Buffers */
#define	LN_CSR0_CERR		0x2000	/* (RC)  SQE failed */
#define	LN_CSR0_BABL		0x4000	/* (RC)  Transmit Babble */
#define	LN_CSR0_ERR		0x8000	/* (R )  Error Summary (last 4) */
#define	LN_CSR0_CLEAR		0x7F00	/*       Clear Status Bit */

/*
 * CSR1 -- Init Block Address (Low 16 Bits -- Must be Word Aligned)
 * CSR2 -- Init Block Address (High 8 Bits)
 */
#define	LN_CSR1			0x0001
#define	LN_CSR2			0x0002

/*
 * CSR3 -- Hardware Control
 */

#define	LN_CSR3			0x0003
#define LN_CSR3_BSWP		0x0004	/* (RW)  Byte Swap */
#define LN_CSR3_EMBA		0x0008	/* (RW)  Enable modified backoff algo */
#define LN_CSR3_DXMT2PD		0x0010	/* (RW)  Disable 2part xmit deferral */
#define LN_CSR3_LAPPEN		0x0020	/* (RW)  LAPP enable */
#define LN_CSR3_DXSUFLO		0x0040	/* (RW)  Disable xmit stop on uflo */
#define LN_CSR3_IDONM		0x0100	/* (RW)  Initialization done mask */
#define LN_CSR3_TINTM		0x0200	/* (RW)  Transmit interrupt mask */
#define LN_CSR3_RINTM		0x0400	/* (RW)  Receive interrupt mask */
#define LN_CSR3_MERRM		0x0800	/* (RW)  Memory error mask */
#define LN_CSR3_MISSM		0x1000	/* (RW)  Missed frame mask */
#define LN_CSR3_BABLM		0x4000	/* (RW)  Babble mask */

#define	LN_CSR4			0x0004
#define	LN_CSR4_JABM		0x0001	/* (RW)  Jabber error mask */
#define	LN_CSR4_JAB		0x0002	/* (RW)  Jabber error */
#define	LN_CSR4_TXSTRTM		0x0004	/* (RW)  Transmit start mask */
#define	LN_CSR4_TXSTRT		0x0008	/* (RW)  Transmit start */
#define	LN_CSR4_RCVCCOM		0x0010	/* (RW)  Receive collision mask */
#define	LN_CSR4_RCVCCO		0x0020	/* (RW)  Receive collision */
#define	LN_CSR4_UINT		0x0040	/* (RW)  User interrupt */
#define	LN_CSR4_UINTCMD		0x0080	/* (RW)  User interrupt command */
#define	LN_CSR4_MFCOM		0x0100	/* (RW)  Missed frame cntr oflo mask */
#define	LN_CSR4_MFCO		0x0200	/* (RW)  Missed frame cntr overflow */
#define	LN_CSR4_ASTRP_RCV	0x0400	/* (RW)  Auto strip receive */
#define	LN_CSR4_APAD_XMT	0x0800	/* (RW)  Auto pad transmit */
#define	LN_CSR4_DPOLL		0x1000	/* (RW)  Disable transmit polling */
#define	LN_CSR4_TIMER		0x2000	/* (RW)  Enable bus activity timer */
#define	LN_CSR4_DMAPLUS		0x4000	/* (RW)  DMAPLUS */
#define	LN_CSR4_EN124		0x8000	/* (RW)  Enable CSR124 access */

/* CSR5 - Extended control and interrupt */
#define LN_CSR5                 0x0005
#define LN_CSR5_SPND		0x0001  /* (RW) Suspend (must poll read until
					   set to confirm) */
#define LN_CSR5_MPMODE		0x0002  /* (RW) Magic packet mode */
#define LN_CSR5_MPEN		0x0004  /* (RW) Magic pcakter enable */
#define LN_CSR5_MPINTE		0x0008  /* (RW) Magic packet interrupt enable */
#define LN_CSR5_MPINT		0x0010  /* (RW) Magic packet interrupt */
#define LN_CSR5_MPPLBA		0x0020  /* (RW) Magic packet physical/logical
					   broadcast address */
#define LN_CSR5_EXDINTE		0x0040  /* (RW) Excessive deferral int enable */
#define LN_CSR5_EXDINT		0x0080  /* (RW) Excessive deferral interrupt */
#define LN_CSR5_SLPINTE		0x0100  /* (RW) Sleep interrupt enable */
#define LN_CSR5_SLPINT		0x0200  /* (RW) Sleep interrupt */
#define LN_CSR5_SINTE		0x0400  /* (RW) System interrupt enable */
#define LN_CSR5_SINT		0x0800  /* (RW) System interrupt */
#define LN_CSR5_LTINTEN		0x4000  /* (RW) Last xmit interrupt enable */
#define LN_CSR5_TOKINTD		0x8000  /* (RW) Transmit OK interrupt disable */

/* CSR80 - DMA and FIFO control register */
#define	LN_CSR80		0x0050	/* DMA and FIFO control reg */
#define	LN_CSR80_DMATC		0x00ff	/* DMA transfer count */
#define	LN_CSR80_XMTFW_16	0x0000	/* Xmit FIFO depth 16 */
#define	LN_CSR80_XMTFW_64	0x0100	/* Xmit FIFO depth 64 */
#define	LN_CSR80_XMTFW_128	0x0200	/* Xmit FIFO depth 128 */
#define	LN_CSR80_XMTSP_16	0x0000	/* Xmit start point 16 */
#define	LN_CSR80_XMTSP_64	0x0400	/* Xmit start point 64 */
#define	LN_CSR80_XMTSP_128	0x0800	/* Xmit start point 128 */
#define	LN_CSR80_XMTSP_248	0x0C00	/* Xmit start point 128 */
#define	LN_CSR80_RCVFW_16	0x0000	/* Rcv FIFO depth 16 */
#define	LN_CSR80_RCVFW_64	0x1000	/* Rcv FIFO depth 64 */
#define	LN_CSR80_RCVFW_128	0x2000	/* Rcv FIFO depth 128 */

/* CSR89 - chip id register */
#define	LN_CSR89		0x0059	/* Chip ID register */
#define	CHIP_ID_PCI		0x0243	/* Am79c970 PCI */
#define	CHIP_ID_PCI2		0x0262	/* Am79c970a PCI II */
#define	LN_CSR89_CHIP_ID_M	0x0fff	/* mask for chip id */

#define	LN_BCR2		0x0002
/* BCR2 - misc configuration */
#define	LN_BCR2_ASEL		0x0002	/* (RW) Auto media select */
#define	LN_BCR2_AWAKE		0x0004	/* (RW) Sleep/Coma snooze mode */
#define	LN_BCR2_EADISEL		0x0008	/* (RW) EADI select */
#define	LN_BCR2_DXCVRPOL	0x0010	/* (RW) DXCVR polarity */
#define	LN_BCR2_DXCVRCTL	0x0020	/* (RW) DXCVR control */
#define	LN_BCR2_INTLEVEL	0x0080	/* (RW) Interrupt edge/level */
#define	LN_BCR2_APROMWE		0x0100	/* (RW) Address PROM write enable */
#define	LN_BCR2_LEDPE		0x1000	/* (RW) Enable LED programming */
#define	LN_BCR2_TMAULOOP	0x4000	/* (RW) Allow external lpbk to pass */

/* LED registers */
#define	LN_BCR4		0x0004		/* Link status LED */
#define	LN_BCR5		0x0005		/* LED 1 */
#define	LN_BCR6		0x0006		/* LED 2 */
#define	LN_BCR7		0x0007		/* LED 3 */
/* LED status */
#define	LN_LED_COLE		0x0001	/* (RW) Collision status enable */
#define	LN_LED_JABE		0x0002	/* (RW) Jabber status enable */
#define	LN_LED_RCVE		0x0004	/* (RW) Receive status enable */
#define	LN_LED_RXPOLE		0x0008	/* (RW) Receive polarity status enable*/
#define	LN_LED_XMTE		0x0010	/* (RW) Trenamit status enable */
#define	LN_LED_RCVME		0x0020	/* (RW) Receive match status enable */
#define	LN_LED_LNKSTE		0x0040	/* (RW) Link status enable */
#define	LN_LED_PSE		0x0080	/* (RW) Pulse stretcher enable */
#define	LN_LED_FDLSE		0x0100	/* (RW) Full-duplex status enable */
#define	LN_LED_MPSE		0x0200	/* (RW) Magic packet status enable */
#define	LN_LED_100		0x1000	/* (RW) 100 mbit status enable */
#define	LN_LED_LEDDIS		0x2000	/* (RW) LED disable */
#define	LN_LED_LEDPOL		0x4000	/* (RW) LED polarity */
#define	LN_LED_LEDOUT		0x8000	/* (R ) LED output pin */

/* BCR9 -  Full-duplex control */
#define	LN_BCR9			0x0009
#define	LN_BCR9_FDEN		0x0001	/* (RW) Full-duplex enable */
#define	LN_BCR9_AUIFD		0x0002	/* (RW) AUI Full-duplex enable */
#define	LN_BCR9_FDRPAD		0x0004	/* (RW) Full-duplex runt pkt accept
					   disable */

/* BCR18 -  Burst and bus control */
#define	LN_BCR18		0x0012
#define	LN_BCR18_BWRITE		0x0020	/* (RW) Burst write enable */
#define	LN_BCR18_BREADE		0x0040	/* (RW) Burst read enable */
#define	LN_BCR18_DWIO		0x0080	/* (RW) Double word I/O */
#define	LN_BCR18_EXTTREQ	0x0100	/* (RW) Extended request */
#define	LN_BCR18_MEMCMD		0x0200	/* (RW) Memory command */

/* BCR19 -  EEPROM control and status */
#define	LN_BCR19		0x0013

/* BCR20 - SWSTYLE */
#define	LN_BCR20		0x0014
#define	LN_BCR20_APERREN	0x0200		/* advanced parity enable */
#define	LN_BCR20_CSRPCNET	0x0100		/* CSR style */
#define	LN_BCR20_SWSTYLE	0x00FF		/* software style */
/* SWSTYLE definitions */
#define	SWSTYLE_LANCE		0x00		/* CLANCE style */
#define	SWSTYLE_ILACC		0x01		/* ILACC style */
#define	SWSTYLE_PCI		0x02		/* PCnet-PCI style */
#define	SWSTYLE_PCI2		0x03		/* PCnet-PCI II style */

#define PCNET_VENDORID_AMD	0x1022		/* AMD PC-net PCI vendor id */
#define PCNET_DEVICEID_AM79C970	0x2000		/* AMD PC-net device id */
