/*-
 * Copyright (c) 1997 Berkeley Software Design, Inc.
 * All rights reserved. 
 * The Berkeley Software Design Inc. software License Agreement specifies  
 * the terms and conditions for redistribution.
 *
 *	BSDI dc21143.h,v 1.4 2000/07/26 23:34:30 geertj Exp
 */

/*
 * PCI identification
 */
#define	DF_VENDORID_DEC		0x1011
#define	DF_DEVICEID_DC21143	0x0019


/*
 * SROM defines
 */
#define	SRSZ_1K		128			/* #bytes in 1K SROM */
#define	SRSZ_4K		512			/* #bytes in 4K SROM */
#define	SR_CRC		126			/* CRC addr, SROM */
#define	SR_MP_CRC	94			/* CRC addr, SROM w/ MP */
#define	SR_VERS		18			/* SROM version */
#define	SR_BLEN(x)	((x)& 0x7f)		/* Length of info block */

/* SROM media block types */
#define	SRBT_SIA	2			/* SIA media block type */
#define	SRBT_MII	3			/* MII media block type */
#define	SRBT_SYM	4			/* SYM media block type */
#define	SRBT_RESET	5			/* RESET media block type */

/* SROM media codes, SIA and SYM */
#define	SRM_MC(x)	((x) & 0x3f)		/* Media Code Mask */
#define	SRM_10BT	0x00			/* 10baseT */
#define	SRM_10B2	0x01			/* 10base2-BNC */
#define	SRM_10B5	0x02			/* 10base5-AUI */
#define	SRM_100TX	0x03			/* 100baseTX */
#define	SRM_10BT_FDX	0x04			/* 10baseT-FDX */
#define	SRM_100TX_FDX	0x05			/* 100baseTX-FDX */
#define	SRM_100T4	0x06			/* 100base-T4 */
#define	SRM_100FX	0x07			/* 100baseFX */
#define	SRM_100FX_FDX	0x08			/* 100baseFX-FDX */
#define	SRM_EXT(x)	((x) & 0x40)		/* extended block (SRBT_SIA) */

/* SROM SYM block command fields */
#define	SRC_CSR6(x)	(((x) & 0x71) << 18) 	/* SROM cmd to CSR6 mask */


/*
 * 21143-specific PCI registers
 */
#define	PCI_CFDD	0x40			/* Config Device  reg */
#define	PCI_CFDD_SL	0x80000000		/* Sleep mode */
#define	PCI_CFDD_SN	0x40000000		/* Snooze mode */


/* 
 * Command and Status Registers (CSRs)
 * All access should be dword access only
 */
#define	CSR0_BM		0x00			/* Bus Mode */
#define	CSR1_TP		0x08			/* Transmit Poll command */
#define	CSR2_RP		0x10			/* Receive Poll command */
#define	CSR3_RLBA	0x18			/* Receive List Base Address */
#define	CSR4_TLBA	0x20			/* Transmit List Base Address */
#define	CSR5_S		0x28			/* Status */
#define	CSR6_OM		0x30			/* Operation Mode */
#define	CSR7_IE		0x38			/* Interrupt Enable */
#define	CSR8_MFOC	0x40			/* RX Missed & Oflow Cnter */
#define	CSR9_ROMMII	0x48			/* SROM, bootROM & MII mgmt */
#define	CSR10_ROMADDR	0x50			/* bootROM prog ADDRess */
#define	CSR11_TIMER	0x58			/* genpurpose TIMER */
#define	CSR12_SIAS	0x60			/* SIA Status */
#define	CSR13_SIAC	0x68			/* SIA Connectivity */
#define	CSR14_SIATR	0x70			/* SIA Transmit & Receive */
#define	CSR15_SIAGP	0x78			/* SIA & GP port */

/*
 * Bus Mode (CSR0)
 */
#define	CSR0_SWR	0x00000001		/* Software Reset */

/*
 * Status (CSR5)
 */
#define	CSR5_LC		0x08000000		/* Link Changed */
#define	CSR5_GPI	0x04000000		/* GP port Interrupt */
#define	CSR5_EBMASK	0x03800000		/* Error Bits (mask) */
#define	CSR5_EB_PARITY	0x00000000		/* Parity Error */
#define	CSR5_EB_MABORT	0x00800000		/* Master Abort */
#define	CSR5_EB_TABORT	0x01000000		/* Target Abort */
#define	CSR5_TSMASK	0x00700000		/* TX process state (mask) */
#define	CSR5_TS_STOP	0x00000000		/* TX process stopped */
#define	CSR5_TS_SUSP	0x00600000		/* TX process suspended */
#define	CSR5_RSMASK	0x000e0000		/* RX process state (mask) */
#define	CSR5_RS_STOP	0x00000000		/* RX process stopped */
#define	CSR5_RS_SUSP	0x00080000		/* RX process suspended */
#define	CSR5_NIS	0x00010000		/* Normal Interrupt Summary */
#define	CSR5_AIS	0x00008000		/* Abnormal Interrupt Summary */
#define	CSR5_ERI	0x00004000		/* Early Receive Interrupt */
#define	CSR5_FBE	0x00002000		/* Fatal Bus Error */
#define	CSR5_LNF	0x00001000		/* Link Fail */
#define	CSR5_GTE	0x00000800		/* GP timer expired */
#define	CSR5_ETI	0x00000400		/* Early Transmit Interrupt */
#define	CSR5_RWT	0x00000200		/* Receive Watchdog Timeout */
#define	CSR5_RPS	0x00000100		/* Receive Process Stopped */
#define	CSR5_RU		0x00000080		/* Receive Buffer Unavailable */
#define	CSR5_RI		0x00000040		/* Receive Interrupt */
#define	CSR5_UNF	0x00000020		/* Transmit Underflow */
#define	CSR5_LNP	0x00000010		/* Link Pass / Autoneg Cmplt */
#define	CSR5_TJT	0x00000008		/* Transmit Jabber Timeout */
#define	CSR5_TU		0x00000004		/* Transmit Buffer Unav */
#define	CSR5_TPS	0x00000002		/* Transmit Process Stopped */
#define	CSR5_TI		0x00000001		/* Transmit Interrupt */

/*
 * Operation Mode (CSR6)
 */
#define	CSR6_SC		0x80000000		/* Enable Capture feature */
#define	CSR6_RA		0x40000000		/* Receive All */
#define	CSR6_MBO	0x02000000		/* Must be One */
#define	CSR6_SCR	0x01000000		/* Scrambler Mode */
#define	CSR6_PCS	0x00800000		/* PCS mode */
#define	CSR6_TTM	0x00400000		/* Transmit Threshold Mode */
#define	CSR6_SF		0x00200000		/* Store and Forward */
#define	CSR6_HBD	0x00080000		/* Heartbeat Disable */
#define	CSR6_PS		0x00040000		/* Port Select */
#define	CSR6_CA		0x00020000		/* Capture Effect Enable */
#define	CSR6_TR0	0x00000000		/* Smallest TX threshold */
#define	CSR6_TR1	0x00004000		/* Bigger TX threshold */
#define	CSR6_TR2	0x00008000		/* Even bigger TX threshold */
#define	CSR6_TR3	0x0000c000		/* Biggest TX threshold */
#define	CSR6_ST		0x00002000		/* Start/Stop Transmission */
#define	CSR6_FC		0x00001000		/* Force Collision */
#define	CSR6_FD		0x00000200		/* Full Duplex Mode */
#define	CSR6_PM		0x00000100		/* Pass All Multicast */
#define	CSR6_PR		0x00000040		/* Promiscuous Mode */
#define	CSR6_SB		0x00000020		/* Start/Stop Backoff Counter */
#define	CSR6_IF		0x00000010		/* Inverse Filtering */
#define	CSR6_PB		0x00000008		/* Pass Bad Frames */
#define	CSR6_HO		0x00000004		/* Hash-Only Filter Mode */
#define	CSR6_SR		0x00000002		/* Start/Stop Receive */
#define	CSR6_HP		0x00000001		/* Hash/Perfect Filter Mode */
#define	CSR6_RX_PERFECT	0x00000000		/* RX perfect filter mode */
#define	CSR6_RX_HASHED	0x00000001		/* RX hashed filter mode */
#define	CSR6_RX_ALMULTI	0x00000080		/* RX all-multi filter mode */
#define	CSR6_RX_PROMISC	0x00000040		/* RX promisc filter mode */

/*
 * Interrupt Enable (CSR7)
 */
#define	CSR7_LC		0x08000000		/* Link Changed */
#define	CSR7_GPE	0x04000000		/* General Purpose Interrupt */
#define	CSR7_NIE	0x00010000		/* Normal Interrupt Summary */
#define	CSR7_AIE	0x00008000		/* Abnormal Interrupt Summary */
#define	CSR7_ERE	0x00004000		/* Early Receive Interrupt */
#define	CSR7_FBE	0x00002000		/* Fatal Bus Error */
#define	CSR7_LFE	0x00001000		/* Link Fail */
#define	CSR7_GTE	0x00000800		/* GP timer expired */
#define	CSR7_ETE	0x00000400		/* Early Transmit Interrupt */
#define	CSR7_RWE	0x00000200		/* Receive Watchdog Timeout */
#define	CSR7_RSE	0x00000100		/* Receive Process Stopped */
#define	CSR7_RUE	0x00000080		/* Receive Buffer Unavailable */
#define	CSR7_RIE	0x00000040		/* Receive Interrupt */
#define	CSR7_UNE	0x00000020		/* Transmit Underflow */
#define	CSR7_LPE	0x00000010		/* Link Pass / Autoneg Cplt */
#define	CSR7_TJE	0x00000008		/* Transmit Jabber Timeout */
#define	CSR7_TUE	0x00000004		/* Transmit Buffer Unav */
#define	CSR7_TSE	0x00000002		/* Transmit Process Stopped */
#define	CSR7_TIE	0x00000001		/* Transmit Interrupt */

/*
 * Missed Frames & Overflow Counters (CSR8)
 */
#define	CSR8_FOC(x)	(((x) >> 17) & 0x0eff)	/* FIFO Overflows */
#define	CSR8_MFC(x)	((x) & 0xffff)	 	/* Missed Frames */

/*
 * BootROM, SROM & MII register (CSR9)
 */
#define	CSR9_MDI	0x00080000		/* MII data-in */
#define	CSR9_MII	0x00040000		/* MII mode (1=rd,0=wr) */
#define	CSR9_MDO	0x00020000		/* MII data-out */
#define	CSR9_MDC	0x00010000		/* MII clock */
#define	CSR9_RD		0x00004000		/* Read ROM */
#define	CSR9_WR		0x00002000		/* Write ROM */
#define	CSR9_BR		0x00001000		/* bootROM Select */
#define	CSR9_SR		0x00000800		/* SROM Select */
#define	CSR9_REG	0x00000400		/* External Register Select */
#define	CSR9_SROUT	0x00000008		/* SROM Data Out */
#define	CSR9_SRIN	0x00000004		/* SROM Data In */
#define	CSR9_SRCLK	0x00000002		/* SROM Clock */
#define	CSR9_SRCS	0x00000001		/* SROM Chip Select */

/*
 * SIA Status Register (CSR12)
 */
#define	CSR12_LPC(x)	((x) >> 16)		/* Link Partner's Code Word */
#define	CSR12_LPN	0x00008000		/* Link Partner Negotiate */
#define	CSR12_ANS(x)	(((x) >> 12 ) & 0x07)	/* Autonegotiation State */
#define	CSR12_TRF	0x00000800		/* Transmit Remote Fault */
#define	CSR12_NSN	0x00000400		/* Non Stable NLP's Detected */
#define	CSR12_TRA	0x00000200		/* 10baseT RX Port Activity */
#define	CSR12_ARA	0x00000100		/* AUI RX port activity */
#define	CSR12_APS	0x00000008		/* Autopolarity State */
#define	CSR12_LS10	0x00000004		/* 10mbit Link Status */
#define	CSR12_LS100	0x00000002		/* 100mbit Link Status */
#define	CSR12_MRA	0x00000001		/* MII Receive Port Activity */

/*
 * SIA Connectivity Register (CSR13)
 */
#define	CSR13_AUI	0x00000008		/* 1=AUI/10base2, 0=10baseT */
#define	CSR13_RST	0x00000001		/* Reset SIA if 0 */

/*
 * SIA & General Purpose Port Register (CSR15)
 */
#define	CSR15_RMI	0x40000000		/* Receive Match Interrupt */
#define	CSR15_GI1	0x20000000		/* GP1 Interrupt */
#define	CSR15_GI0	0x10000000		/* GP0 Interrupt */
#define	CSR15_CWE	0x08000000		/* Control Write Enable */
#define	CSR15_RME	0x04000000		/* Receive Match Enable */
#define	CSR15_GEI1	0x02000000		/* GP1 Interrupt Enable */     
#define	CSR15_GEI0	0x01000000		/* GP0 Interrupt Enable */     
#define	CSR15_LGS3	0x00800000		/* LED/GEP 3 Select */
#define	CSR15_LGS2	0x00400000		/* LED/GEP 2 Select */
#define	CSR15_LGS1	0x00200000		/* LED/GEP 1 Select */
#define	CSR15_LGS0	0x00100000		/* LED/GEP 0 Select */
#define	CSR15_RWR	0x00000020		/* Receive Watchdog Release */
#define	CSR15_RWD	0x00000010		/* Receive Watchdog Disable */
#define	CSR15_ABM	0x00000008		/* AUI/BNC mode */
#define	CSR15_JCK	0x00000004		/* Jabber Clock */
#define	CSR15_HUJ	0x00000002		/* Host Unjab */
#define	CSR15_JBD	0x00000001		/* Jabber Disable */


/*
 * Receive descriptor (plus driver private bits)
 * The descriptor, as well as *df_buf and *df_next,
 * *MUST* be aligned on 8-byte physical address!
 */
struct df_rxd {
	volatile u_long		df_stat;	/* RX status */
	volatile u_long		df_cntl;	/* Control bits / pktsz */
	vm_offset_t		df_buf;		/* _phys_ ptr to buffer */
	vm_offset_t		df_next;	/* _phys_ ptr to next */
};

/*
 * Receiver status fields (RDES0)
 */
#define	DFRS_NICOWN	0x80000000		/* 0=host, 1=NIC */
#define	DFRS_FL(x)	(((x) >> 16) & 0x3fff)	/* Frame Length */
#define	DFRS_ES		0x00008000		/* Error Summary */
#define	DFRS_DE		0x00004000		/* Descriptor Error */
#define	DFRS_RF		0x00000800		/* Runt Frame */
#define	DFRS_FS		0x00000200		/* First descriptor */
#define	DFRS_LS		0x00000100		/* Last descriptor */
#define	DFRS_TL		0x00000080		/* Frame Too Long */
#define	DFRS_CS		0x00000040		/* Collision Seen */
#define	DFRS_RW		0x00000010		/* Receive Watchdog */
#define	DFRS_RE		0x00000008		/* MII error Report */
#define	DFRS_DB		0x00000004		/* Dribbling Bit */
#define	DFRS_CE		0x00000002		/* CRC error */

/*
 * Receiver control fields (RDES1)
 */
#define	DFRC_RER	0x02000000		/* Receive End of Ring */
#define	DFRC_RCH	0x01000000		/* Second Address Chained */
#define	DFRC_RBS2(x)	(((x) & 0x7fc) << 11)	/* Buffer2 size field */
#define	DFRC_RBS1(x)	((x) & 0x7fc)		/* Buffer1 size field */


/*
 * Transmit DMA descriptor
 *  *MUST* be aligned on 8-byte physical address!
 */
struct df_txd {
	volatile u_long		df_stat;	/* TX status */
	volatile u_long		df_cntl;	/* Control bits/buffercount */
	vm_offset_t		df_buf1;	/* _phys_ ptr to buffer1 */
	vm_offset_t		df_buf2;	/* _phys_ ptr to buffer2/next */
};

/*
 * Transmitter status fields (TDES0)
 */
#define	DFTS_NICOWN	0x80000000		/* 0=host, 1=NIC */
#define	DFTS_ES		0x00008000		/* Error Summary */
#define	DFTS_TO		0x00004000		/* Jabber Timeout */
#define	DFTS_LO		0x00000800		/* Loss of carrier */
#define	DFTS_NC		0x00000400		/* No Carrier */
#define	DFTS_LC		0x00000200		/* Late Collision */
#define	DFTS_EC		0x00000100		/* Excessive Collision */
#define	DFTS_HF		0x00000080		/* Heartbeat Fail */
#define	DFTS_CC(x)	(((x) >> 3) & 0x0f)	/* Collision Count */
#define	DFTS_LF		0x00000004		/* Link Fail */
#define	DFTS_UF		0x00000002		/* Underflow Error */
#define	DFTS_DE		0x00000001		/* Deferred */

/*
 * Transmitter control fields (TDES1)
 */
#define	DFTC_IC		0x80000000		/* Interrupt on Completion */
#define	DFTC_LS		0x40000000		/* Last Segment */
#define	DFTC_FS		0x20000000		/* First Segment */
#define	DFTC_TER	0x02000000		/* Transmit End of Ring */
#define	DFTC_TCH	0x01000000		/* Second Address Chained */
#define	DFTC_TBS2(x)	(((x) & 0x7ff) << 11)	/* Buffer2 size field */
#define	DFTC_TBS1(x)	((x) & 0x7ff)		/* Buffer1 size field */
#define	DFTC_SET	0x08000000		/* RX filter setup packet */
#define	DFTC_FT_PF	0x00000000		/* RX filter: Perfect */
#define	DFTC_FT_HASH	0x00400000		/* RX filter: Hash */


/*
 * Size of things (not tunable)
 */
#define	DF_RXSPERFSZ	16			/* #addrs w/ perf filter mode */
#define	DF_RXSHASHSZ	64			/* 512bit hashtable (64bytes) */

/* 
 * Receiver setup frame
 * _must_ be 192 bytes long
 * Note that for all values below, only 16 bits are significant!
 */
union df_rxsetup {
	struct {
		/* Phys addrs, 2 bytes */
		u_long df_phyad[DF_RXSPERFSZ][ETHER_ADDR_LEN/2]; 
	} df_rxperf;
	struct { /* Hash table, 2 bytes */
		u_long df_hash[DF_RXSHASHSZ/2];
		u_long _junk1[7];
		/* Phys addr, 2 bytes */
		u_long df_phyad[ETHER_ADDR_LEN/2];
		u_long _junk2[6];
	} df_rxhash;
};

