/*
 * Copyright (c) 1999 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI hd64572.h,v 1.1 1999/07/28 22:05:35 cp Exp
 */

#ifndef FILLER
#define FILLER(start, end)	u_char __CONCAT(filler, start)[(end-start)+1]
#endif

typedef struct hd64572_wcr
{
	FILLER(0x0,0x1f);
	u_char	wcr_pabr0l;	/* 020 physical address boundary reg 0 low */
	u_char	wcr_pabr0h;	/* 021 physical address boundary reg 0 high */
	u_char	wcr_pabr1l;	/* 022 physical address boundary reg 1 low */
	u_char	wcr_pabr2h;	/* 023 physical address boundary reg 2 high */
	u_char	wcr_wcrl;	/* 024 control register low */
	u_char	wcr_wcrm;	/* 025 control register middle */
	u_char	wcr_wcrh;	/* 026 control register high */
} volatile hd64572_wcr_t;

typedef struct hd64572_iac
{
	u_char	iac_iacr;	/* 000 illegal access control register */
} volatile hd64572_iac_t;

typedef struct hd64572_dmabc {
	u_char	dma_dsr;	/* 048 status register */
	FILLER(0x49,0x4b);
	u_char	dma_dir;	/* 04c interrupt enable register */
	FILLER(0x4d,0x4f);
	u_char	dma_fct;	/* 050 frame end interrupt counter */
	FILLER(0x51,0x53);
	u_char	dma_dmr;	/* 054 mode register */
	FILLER(0x55,0x57);
	u_char	dma_dcr;	/* 058 command register */
} volatile hd64572_dmabc_t;

typedef struct hd64572_dma
{
	FILLER(0x0,0x06);
	u_char	dma_dmer;	/* 007 master enable register */
	u_char	dma_btcr;	/* 008 burst transmission control register */
	FILLER(0x9,0x0b);
	u_char	dma_bolr;	/* 00c back-off length register */
	FILLER(0xd,0x3f);
	u_char	dma_pcr;	/* 040 priority control register */
	FILLER(0x41,0x43);
	u_char	dma_drr;	/* 044 reset register */
	FILLER(0x45,0x47);
	u_int	dma_dsr;	/* 048 status register */
	u_int	dma_dir;	/* 04c interrupt enable register */
	u_int	dma_fct;	/* 050 frame end interrupt counter */
	u_int	dma_dmr;	/* 054 mode register */
	u_int	dma_dcr;	/* 058 command register */
} volatile hd64572_dma_t;

#define DMER_DME	0x80	/* dma master enable */

typedef struct hd64572_icr
{
	FILLER(0x0,0x5f);
	u_char	icr_ivr;	/* 060 interrupt fixed vector register */
	FILLER(0x61,0x63);
	u_short	icr_imvr;	/* 064 interrupt modified vector register */
	FILLER(0x66,0x67);
	u_char	icr_itcr;	/* 068 interrupt control register */
	FILLER(0x69,0x6b);
	u_int	icr_isr0;	/* 06c interrupt status register 0 */
	u_int	icr_isr1;	/* 070 interrupt status register 1 */
	u_int	icr_ier0;	/* 074 interrupt enable register 0 */
	u_int	icr_ier1;	/* 078 interrupt enable register 0 */
	FILLER(0x7c,0x7f);
} volatile hd64572_icr_t;


typedef struct hd64572_dmac
{
	u_int	dmac_bar;	/* 080 base address register */
	u_int	dmac_cda;	/* 084 current descriptor address */
	u_int	dmac_eda;	/* 088 error descriptor address */
	u_short	dmac_bcr;	/* 08c byte count register */
	FILLER(0x8e,0x8f);
	u_short	dmac_bfl;	/* 090 receive buffer length */
	FILLER(0x92,0x9f);
} volatile hd64572_dmac_t;

typedef struct hd64572_msci
{
	u_int	msci_trb;	/* 100 tx/rx buffer */
	FILLER(0x104,0x107);
	u_char	msci_cst0;	/* 108 current status register 0 */
	u_char	msci_cst1;	/* 109 current status register 0 */
	u_char	msci_cst2;	/* 10a current status register 0 */
	u_char	msci_cst3;	/* 10b current status register 0 */
	FILLER(0x10c,0x10f);
	u_char	msci_tbn;	/* 110 transmit buffer number register */
	u_char	msci_rbn;	/* 111 receive buffer number register */
	FILLER(0x112,0x117);
	u_char	msci_st0;	/* 118 status register 0 */
	u_char	msci_st1;	/* 119 status register 1 */
	u_char	msci_st2;	/* 11a status register 2 */
	u_char	msci_st3;	/* 11b status register 3 */
	u_char	msci_st4;	/* 11c status register 4 */
	u_char	msci_fst;	/* 11d frame status register */
	FILLER(0x11e,0x11f);
	u_char	msci_ie0;	/* 120 interrupt enable register 0 */
	u_char	msci_ie1;	/* 121 interrupt enable register 1 */
	u_char	msci_ie2;	/* 122 interrupt enable register 2 */
	FILLER(0x123,0x123);
	u_char	msci_ie4;	/* 124 interrupt enable register 4 */
	u_char	msci_fie;	/* 125 frame interrupt enable register */
	FILLER(0x126,0x127);
	u_char	msci_cmd;	/* 128 command register */
	FILLER(0x129,0x12f);
	u_char	msci_ctl;	/* 130 control register */
	u_char	msci_gpo;	/* 131 general-purpose output pin control reg */
	FILLER(0x132,0x137);
	u_char	msci_md0;	/* 138 mode register 0 */
	u_char	msci_md1;	/* 139 mode register 1 */
	u_char	msci_md2;	/* 13a mode register 2 */
	u_char	msci_md3;	/* 13b mode register 3 */
	u_char	msci_rxs;	/* 13c rx clock source register */
	u_char	msci_txs;	/* 13d tx clock source register */
	u_char	msci_exs;	/* 13e extenal pin clk input selection reg */
	FILLER(0x13f,0x13f);
	u_char	msci_sa0;	/* 140 synchronization address register 0 */
	u_char	msci_sa1;	/* 141 synchronization address register 1 */
	u_char	msci_idl;	/* 142 idle pattern register */
	u_char	msci_tfn;	/* 143 transmit inter frame time fill ctl */
	u_char	msci_tmct;	/* 144 time constant register-transmit */
	u_char	msci_tmcr;	/* 145 time constant register-receive */
	FILLER(0x146,0x147);
	u_char	msci_trc0;	/* 148 tx ready control register 0 */
	u_char	msci_trc1;	/* 149 tx ready control register 1 */
	u_char	msci_rrc;	/* 14a rx ready control register */
	u_char	msci_tps;	/* 14b transmit start threshold control reg */
	FILLER(0x14c,0x14f);
	u_char	msci_tnr0;	/* 150 transmit dma request control reg 0 */
	u_char	msci_tnr1;	/* 151 transmit dma request control reg 1 */
	u_char	msci_tcr;	/* 152 transmit dma critical request register */
	FILLER(0x153,0x153);
	u_char	msci_rnr;	/* 154 receive dma request control register */
	FILLER(0x155,0x155);
	u_char	msci_rcr;	/* 156 receive dma critical request ctl reg */
	FILLER(0x157,0x157);
} volatile hd64572_msci_t;

typedef struct hd64572_scr
{
	u_char	scr_cmcr;	/* 158 counter master control register */
	FILLER(0x159,0x15f);
	u_char	scr_tecntl;	/* 160 txeom counter low */
	u_char	scr_tecntm;	/* 161 txeom counter middle */
	u_char	scr_tecnth;	/* 162 txeom counter high */
	u_char	scr_teccr;	/* 163 txeom countr control register */
	u_char	scr_urcntrl; 	/* 164 underrun counter low */
	u_char	scr_urcntrh;	/* 165 underrun counter low */
	FILLER(0x166,0x166);
	u_char	scr_urccr;	/* 167 underrun counter control register */
	u_char	scr_recntl;	/* 168 rxeom counter low */
	u_char	scr_recntm;	/* 169 rxeom counter middle */
	u_char	scr_recnth;	/* 16a rxeom counter middle */
	u_char	scr_reccr;	/* 16b rxeom counter control register */
	u_char	scr_orcntl;	/* 16c overrun frame counter low */
	u_char	scr_orcnth;	/* 16d overrun frame counter high */
	FILLER(0x16e,0x16e);
	u_char	scr_orccr;	/* 16f overrun frame counter control register */
	u_char	scr_cecntl;	/* 170 crc error frame counter low */
	u_char	scr_cecnth;	/* 171 crc error frame counter high */
	FILLER(0x172,0x172);
	u_char	scr_ceccr;	/* 173 crc error frame counter control reg */
	u_char	scr_abcntl;	/* 174 abort frame counter low */
	u_char	scr_abcnth;	/* 175 abort frame counter high */
	FILLER(0x176,0x176);
	u_char	scr_abccr;	/* 177 abort frame counter control register */
	u_char	scr_shcntl;	/* 178 short frame counter low */
	u_char	scr_shcnth;	/* 179 short frame counter high */
	FILLER(0x17a,0x17a);
	u_char	scr_shccr;	/* 17b short frame counter control register */
	u_char	scr_rscntl;	/* 17c residual bit frame counter low */
	u_char	scr_rscnth;	/* 17d residual bit frame counter high */
	FILLER(0x17e,0x17e);
	u_char	scr_rsccr;	/* 17f residual bit frame counter control reg */
} volatile hd64572_scr_t;

typedef struct hd64572_tr
{
	u_char	tr_tcntl;	/* 200 up-counter low */
	u_char	tr_tcnth;	/* 201 up-counter high */
	u_char	tr_tconrl;	/* 204 timer constant register low */
	u_char	tr_tconrh;	/* 205 timer constant register high */
	u_char	tr_tcsr;	/* 206 timer control/status register */
	u_char	tr_tepr;	/* 207 timer expand prescale register */
} volatile hd64572_tr_t;


typedef struct hd_64572
{
	union {
		hd64572_dma_t dma;
		hd64572_iac_t iac;
		hd64572_icr_t icr;
		hd64572_wcr_t wcr;
	} hd_common;
#define sca_dma	hd_common.dma
#define sca_iac	hd_common.iac
#define sca_icr	hd_common.icr
#define sca_wcr	hd_common.wcr
	hd64572_dmac_t	sca_dmac[4];
	struct {
		hd64572_msci_t	msci;
		hd64572_scr_t	scr;
	} sca_msci_scr[2];
} hd_64572_t;

/*
 * MSCI Command Register values (commands)
 */
#define CMD_NOP		0x00	/* No operation */
#define CMD_TXRST	0x01	/* TX reset */
#define CMD_TXENB	0x02	/* TX enable */
#define CMD_TXDIS	0x03	/* TX disable */
#define CMD_TXCRCINI	0x04	/* TX CRC initialization */
#define CMD_TXCRCEXCL	0x05	/* TX CRC exclusion */
#define CMD_EOM		0x06	/* End-of-message */
#define CMD_ABORT	0x07	/* Abort transmission */
#define CMD_MP		0x08	/* MP bit on */
#define CMD_TXCLR	0x09	/* TX buffer clear */
#define CMD_RXRST	0x11	/* RX reset */
#define CMD_RXENB	0x12	/* RX enable */
#define CMD_RXDIS	0x13	/* RX disable */
#define CMD_RXCRCINI	0x14	/* RX CRC initialization */
#define CMD_MREJ	0x15	/* Messaje reject */
#define CMD_SMP		0x16	/* Search MP bit */
#define CMD_RXCRCEXCL	0x17	/* RX CRC exclusion */
#define CMD_RXCRCFRC	0x18	/* Forcing RX CRC calculation */
#define CMD_CHRST	0x21	/* Channel reset */
#define CMD_ESM		0x31	/* Enter search mode */

/*
 * DMA Status Register and DMA Interrupt enable Register bits
 * DEWD and DE are status register only
 */
#define DSE_DEWD	0x01	/* DE bit write disable (DSR only) */
#define DSE_DE		0x02	/* DMA enable (DSR only) */
#define	DSE_REF		0x04	/* Receive Frame Error */
#define DSE_UDRF	0x08	/* Underrun frame */
#define DSE_COF		0x10	/* Counter overflow (chain mode only) */
#define DSE_BOF		0x20	/* Buffer over/underflow (chain mode only) */
#define DSE_EOM		0x40	/* End of Frame transfer (chain mode only) */
#define DSE_EOT		0x80	/* End of transfer */

/*
 * DMA Command Register values (commands)
 */
#define DCR_ABORT	0x01	/* Software abort */
#define DCR_FCTCLR	0x02	/* Clear frame-end intr counter (FCT) */

/*
 * MSCI Mode Register 0 bits
 */
#define MD0_STOPS	0x03	/* Stop bit length (async mode) */
#define MD0_STOP1	0x00	/* 1 stop bit */
#define MD0_STOP15	0x01	/* 1.5 stop bits */
#define MD0_STOP2	0x02	/* 2 stop bits */
#define MD0_CRCINIT	0x01	/* init CRC is all 1s (0 for all 0s) */
#define MD0_CRCCCITT	0x02	/* use CCITT CRC polynome (0 for CRC-16) */
#define MD0_CRCENB	0x04	/* CRC calculation enabled */
#define MD0_AUTO	0x10	/* Auto-enable (hw flow control) */
#define MD0_PRTCL	0xe0	/* Protocol mode */
#define MD0_ASYNC	0x00	/* asynchronous mode */
#define MD0_BYMONO	0x20	/* byte-sync mono-sync mode */
#define MD0_BYBI	0x40	/* byte-sync bi-sync mode */
#define MD0_BYEXT	0x60	/* byte-sync external sync mode */
#define MD0_HDLC	0x80	/* bit-sync HDLC mode */
#define MD0_LOOP	0xa0	/* bit-sync loop mode */

/*
 * MSCI Mode Register 1 bits
 */
#define MD1_PMPM	0x03	/* Parity/Multiprocessor mode */
#define MD1_NOPA	0x00	/* No parity/MP bit */
#define MD1_MP		0x01	/* Append MP bit */
#define MD1_EVEN	0x02	/* Even parity */
#define MD1_ODD		0x03	/* Odd parity */
#define MD1_RXCHR	0x0c	/* Receive character length */
#define MD1_RXCHR8	0x00	/* 8 bits */
#define MD1_RXCHR7	0x04	/* 7 bits */
#define MD1_RXCHR6	0x08	/* 6 bits */
#define MD1_RXCHR5	0x0c	/* 5 bits */
#define MD1_TXCHR	0x30	/* Transmit character length */
#define MD1_TXCHR8	0x00	/* 8 bits */
#define MD1_TXCHR7	0x10	/* 7 bits */
#define MD1_TXCHR6	0x20	/* 6 bits */
#define MD1_TXCHR5	0x30	/* 5 bits */
#define MD1_BRATE	0xc0	/* Bit rate (async mode) */
#define MD1_BR1		0x00	/* 1/1 clock rate */
#define MD1_BR16	0x40	/* 1/16 clock rate */
#define MD1_BR32	0x80	/* 1/32 clock rate */
#define MD1_BR64	0xc0	/* 1/64 clock rate */
#define MD1_ADDRS	0xc0	/* Address field check (bit sync mode) */
#define MD1_NOADR	0x00	/* don't check */
#define MD1_ADR1	0x40	/* check address byte 1 */
#define MD1_ADR2	0x80	/* check address byte 2 */
#define MD1_DADR	0xc0	/* check both address bytes */

/*
 * MSCI Mode Register 2 bits
 */
#define MD2_CNCT	0x03	/* Channel connection */
#define MD2_DUPLEX	0x00	/* full duplex */
#define MD2_ECHO	0x01	/* auto echo */
#define MD2_LOOPBACK	0x03	/* local loop back */
#define MD2_DRATE	0x18	/* ADPLL operating clock/bit rate (sync) */
#define MD2_DR8		0x00	/* x 8 */
#define MD2_DR16	0x08	/* x 16 */
#define MD2_DR32	0x10	/* x 32 */
#define MD2_CODE	0xe0	/* Transmission code type (sync) */
#define MD2_NRZ		0x00	/* Non-Return to Zero */
#define MD2_NRZI	0x20	/* NRZ with Inversion */
#define MD2_MCH		0x80	/* Manchester code */
#define MD2_FM1		0xa0	/* Frequency modulation (hi freq = 1) */
#define MD2_FM0		0xc0	/* Frequency modulation (hi freq = 0) */

/*
 * MSCI RX Clock Source Register bits
 */
#define RXS_BR		0x0f	/* Clock division ratio = 2**n (0<=n<=9) */
#define RXS_SRC		0x70	/* Clock source */
#define RXS_LINE	0x00	/* RXC line input */
#define RXS_LNS		0x20	/* RXC line input with noise suppression */
#define RXS_BRG		0x40	/* iternal baud rate generator */
#define RXS_ALINE	0x60	/* from ADPLL from RXC line */
#define RXS_ABRG	0x70	/* from ADPLL from internal BRG */

/*
 * MSCI TX Clock Source Register bits
 */
#define TXS_BR		0x0f	/* Clock division ratio = 2**n (0<=n<=9) */
#define TXS_SRC		0x70	/* Clock source */
#define TXS_LINE	0x00	/* TXC line input */
#define TXS_BRG		0x40	/* iternal baud rate generator */
#define TXS_RXC		0x60	/* receive clock */

/*
 * MSCI Status Register 3
 */
#define ST3_DCD		0x4


/*
 * MSCI Control Reg (CTL)
 */
#define CTL_UNRNC	0x20	/* Tx enters idle: 0 immedately 1 after CRC */
#define CTL_IDLC	0x10	/* Idle pattern 0 mark, 1 idle pattern reg */
#define CTL_RTS_DTR	0x02	/* Disable DTR */
#define CTL_RTS_BAR	0x01	/* Disable RTR */

/*
 * DMA Mode Register bits
 */
#define DMR_CNTE	0x02	/* Frame-end intr counter (FCT) enable */
#define DMR_NF		0x04	/* Multi-frame transfer (chain mode only) */
#define DMR_TMOD	0x10	/* Chained-block transfer mode */

/*
 * Interrupt Status Register 0 and Interrupt Enable Register 0 bits
 * There are corresponding bits for the second channel, dmac
 * channels 2 and 3 in the next byte up.
 * There are also msci bits in the top half which are currently
 * not used, or even defined here.
 */
#define ISE0_DMIC_R	0x01
#define ISE0_DMIB_R	0x02
#define ISE0_DMIA_R	0x04
#define ISE0_EFT_R	0x08
#define ISE0_DMIC_T	0x10
#define ISE0_DMIB_T	0x20
#define ISE0_DMIA_T	0x40
#define ISE0_EFT_T	0x80

/*
 * bits used with priority control register
 */

#define	PCR_PR0		0x01	/* Channel priority bit 0 */
#define	PCR_PR1		0x02	/* Channel priority bit 1 */
#define	PCR_PR2		0x04	/* Channel priority bit 2 */
#define	PCR_CCC		0x08	/* Chan change condition 1 no dma req */
#define PCR_BRC		0x10	/* Bus release condition 1 in chan rot*/
#define PCR_RESERVED	0x20	/* Reserved, must not be set */
#define PCR_OSBE	0x40	/* Ownership bit enable */
#define PCR_COTE	0x80	/* Enable 64-bit burst */


typedef struct hd64572_cbd {
	u_int		 cbd_chain;	/* physical address of next cbd */
	u_int		 cbd_buffer;
	u_short		 cbd_length;
	u_char		 cbd_status;
	u_char		 cbd_filler;
} hd64572_cbd_t;

#define CDB_EOT		0x01
#define CDB_OSB		0x02
#define CDB_CRC		0x04
#define CDB_OVERRUN	0x08
#define CDB_RESID	0x10
#define CDB_ABORT	0x20
#define	CDB_SHORT	0x40
#define CDB_EOM		0x80
