
#ifndef FILLER
#define FILLER(start, end)	u_char __CONCAT(filler, start)[(end-start)+1]
#endif

typedef struct plx_9080 {
	FILLER(0x00,0x3f);
	u_int	plx_mbox0;	/* Mailbox Register 0 */
	u_int	plx_mbox1;	/* Mailbox Register 1 */
	u_int	plx_mbox2;	/* Mailbox Register 2 */
	u_int	plx_mbox3;	/* Mailbox Register 3 */
	u_int	plx_mbox4;	/* Mailbox Register 4 */
	u_int	plx_mbox5;	/* Mailbox Register 5 */
	u_int	plx_mbox6;	/* Mailbox Register 6 */
	u_int	plx_mbox7;	/* Mailbox Register 7 */
	FILLER(0x60,0x67);
	u_int	plx_intcsr;	/* Interrupt Control/Status Register */
	FILLER(0x6c,0xff);
} plx_9080_t;

#define INTCSR_PIE	0x00000100	/* Enables PCI interrupts */
#define INTCSE_PLIE	0x00000800	/* Local interrupts generate PCI int */
#define INTCSE_LIE	0x00010000	/* Enable local interrupt output */

