/*-
 * Copyright (c) 1997 Berkeley Software Design, Inc.
 * All rights reserved. 
 * The Berkeley Software Design Inc. software License Agreement specifies  
 * the terms and conditions for redistribution.
 *
 *	BSDI if_ebreg.h,v 1.11 2001/03/06 15:18:29 geertj Exp
 */

/* 
 * PCI ID codes
 * DeviceIDs listed in eb_types[]
 */
#define EB_VENDOR_ID	0x10b7		/* 3COM */

/*
 * Packet fragment - used by eb_dpd and eb_upd
 */
struct eb_frag {
	volatile vm_offset_t	eb_faddr;	/* fragment address */
	volatile u_long		eb_flen;	/* fragment length */
};

/*
 * Download (TX) Packet Data Structure - DPD
 *  Total size cannot exceed 512 bytes
 *  It *MUST* be aligned on 8-byte physical address!
 *  We steal a slot for mbuf info, so reduce fragments by 1
 */
#define EB_DFRAG	62		/* Max no of frags in DPD (nochange) */

struct eb_dpd {
	volatile vm_offset_t	eb_next;	/* _physical_ ptr to next pd */
	volatile u_long		eb_len;		/* packet length and bits */
	struct eb_frag	eb_frag[EB_DFRAG];	/* download fragments */

					/* Following not visible to chip: */
	struct mbuf	*eb_mbuf;	/* head of mbuf chain */
	u_long		filler;		/* Pad length to multiple of 8 */
};

#define EB_UFRAG	2		/* Max no of frags in UPD (nochange) */
/*
 * Upload (RX) Packet Data Structure - UPD
 *  Total size (seen by chip) should not exceed 512 bytes.
 *  It *MUST* be aligned on 8-byte physical address!
 *  We only provide 2 fragments so total size is 36 bytes.
 *  XXX Need to make this more flexible
 */
struct eb_upd {
	volatile vm_offset_t	eb_next;	/* _physical_ ptr to next pd */
	volatile u_long		eb_len;		/* packet length and bits */
	struct eb_frag	eb_frag[EB_UFRAG];	/* upload fragments */

					/* Following not visible to chip: */
	struct mbuf	*eb_mbuf;	/* head of mbuf chain */
	struct eb_upd	*next;		/* _virtual_ pointer to next pd */
};

/*
 * Packet Descriptor length field (eb_len) flags 
 *
 * R for received packets, T for transmitted packets
 */
#define EBD_LEN(l) ((l) & 0x00001fff)	/* TR Packet Length (sum of frags) */
#define EBD_NOCRC	0x00002000	/* T  CRC generation disable */
#define EBD_RXERR	0x00004000	/*  R Error in RX packet */
#define EBD_COMPLT	0x00008000	/* TR Packet complete */
#define EBD_OVRRUN	0x00010000	/*  R Overrun */
#define EBD_RUNT	0x00020000	/*  R Runt Packet */
#define EBD_ALIGN	0x00040000	/*  R Alignment (Framing) Error */
#define EBD_CRC	 	0x00080000	/*  R CRC Error */
#define EBD_OVRSIZ	0x00100000	/*  R Oversize Packet */
#define EBD_DRIB	0x00800000	/*  R Dribble Bit(s) */
#define EBD_OFLOW	0x01000000	/*  R Overflow (buffer too small) */
#define EBD_DNI	 	0x80000000	/* T  Download Complete Indication */

/*
 * Packet Fragment (eb_flen) flags 
 *
 * R for received packets, T for transmitted packets
 */
#define EBF_LEN(l) ((l) & 0x00001fff)	/* TR Fragment Length */
#define EBF_LAST 	0x80000000	/* TR Last Fragment */

/* Registers common for all windows */
#define EB_STAT		0xe		/* Status register (R) */
#define EB_CMD		0xe		/* Command register (W) */	

/* Window 0 - Setup */
#define EB0_PROMCMD	0xa		/* EEPROM Command */
#define EB0_PROMDATA	0xc		/* EEPROM Data */

/* Window 2 - Station Address */
#define EB2_ADDR(i)	(i)		/* Station address */
#define EB2_MASK(i)	(i + 6)		/* Station address mask */
#define EB2_RESOPT	0x0c		/* ResetOptions (90xB up) */

/* Window 3 - FIFO Management */
#define EB3_ICONFG	0x00		/* InternalConfig */
#define	EB3_MAXPKTSZ	0x04		/* Max Pkt Size (90xB up) */
#define EB3_MCTL	0x06		/* MacControl */
#define EB3_MEDOPT	0x08		/* MediaOptions (90x: ResetOptions) */
#define EB3_RXFREE	0x0a		/* Bytes avail in RX FIFO */
#define EB3_TXFREE	0xc		/* Free transmit bytes (R) */

/* Window 4 - Diagnostics */
#define EB4_TXDIAG	0x0		/* TX Diagnostic */
#define EB4_HDIAG	0x2		/* Host Diagnostic */
#define EB4_FDIAG	0x4		/* FIFO Diagnostic */
#define EB4_NDIAG	0x6		/* Net Diagnostic */
#define EB4_PMGMT	0x8		/* Physical Management (MII) */
#define EB4_MTS		0xa		/* Media Type and Status */
#define EB4_BADSSD	0xc		/* 100baseTX err counter */
#define EB4_UPRBTOTAL	0xd		/* Upper bits TX/RX total */

/* Window 5  - Command Results and Internal State */
#define EB5_TXSTART	0x0		/* TX Start threshold + 4 (R) */
#define EB5_RXEARLY	0x6		/* RX Early threshold (R) */
#define EB5_RXFILTER	0x8		/* RX Filter (R) */
#define EB5_TXRCTHRE	0x9		/* TX reclaim threshold (90xB up) */
#define EB5_IMASK	0xa		/* Interrupt Mask (R) */
#define EB5_RZMASK	0xc		/* Read Zero Mask (R) */

/* Window 6 - Statistics */
#define EB6_CSL		0x0		/* Carrier Sense Lost during xmission */
#define EB6_NOCD	0x1		/* Frames xmitted with no CD Heartbt */
#define EB6_MCOL	0x2		/* Frames xmitted after Mult Collis */
#define EB6_OCOL	0x3		/* Frames xmitted after One Collision */
#define EB6_LCOL	0x4		/* Late Collisions on transmit */
#define EB6_RXOVR	0x5		/* Receive Overruns */
#define EB6_TXFOK	0x6		/* Frames Transmitted OK */
#define EB6_RXFOK	0x7		/* Frames Received OK */
#define EB6_TXDEF	0x8		/* Transmit Deferrals */
#define EB6_UPPERFOK	0x9		/* Upper bits RXFOK, TXFOK */
#define EB6_RXBTOTAL	0xa		/* Total Bytes Received OK */
#define EB6_TXBTOTAL	0xc		/* Total Bytes Transmitted OK */

/* Boomerang extended window set */
#define EBB_TXSTAT	0x1b		/* TX Status (R) */
#define EBB_DMACTL	0x20		/* DMA Control / Status */
#define EBB_DPD		0x24		/* Current DPD pointer */
#define EBB_TXFTHRE	0x2f		/* Boomerang TXfree thresh (90x only) */
#define EBB_USTAT	0x30		/* Boomerang upload status (R) */
#define EBB_UPD		0x38		/* Current UPD pointer */

/*
 * Commands to write to EB_CMD
 * The argument should be OR-ed with the command word
 */
#define EBC_RESET	0x0000		/* Global Reset */
#define EBC_RES_TPAUI	0x0001		/* mask 10-baseT and AUI TX logic */
#define EBC_RES_ENDEC	0x0002		/* mask Ethernet enc/dec TX logic */
#define EBC_RES_NETTX	0x0004		/* mask network TX logic */
#define EBC_RES_FIFO	0x0008		/* mask TX FIFO logic */
#define EBC_RES_AISM    0x0010		/* mask auto init state machine */
#define EBC_RES_HOST    0x0020		/* mask bus interface logic */
#define EBC_RES_DMA	0x0040		/* mask TX DMA logic */
#define EBC_RES_VCO	0x0080          /* mask VCO logic */
#define EBC_RES_MASK	0x00ff		/* global reset mask */
#define EBC_WINDOW	0x0800		/* Select Window N */
#define EBC_COAXSTA	0x1000		/* Start Coaxial Transceiver */
#define EBC_RXDIS	0x1800		/* Disable Receiver */
#define EBC_RXENB	0x2000		/* Enable Receiver */
#define EBC_RXRST	0x2800		/* Reset Receiver */
#define EBC_USTALL	0x3000		/* Upload Stall */
#define EBC_UUSTALL	0x3001		/* Upload UnStall */
#define EBC_DSTALL	0x3002		/* Download Stall */
#define EBC_DUSTALL	0x3003		/* Download UnStall */
#define EBC_TXENB	0x4800		/* Enable Transmitter */
#define EBC_TXDIS	0x5000		/* Disable Transmitter */
#define EBC_TXRST	0x5800		/* Reset Transmitter */
#define EBC_TXRST_DMA	0x0040		/* dmaTxReset mask bus master logic */
#define EBC_TXRST_DTX	0x0100		/* dnTcReset mask download logic */
#define EBC_IREQ	0x6000		/* Request Interrupt */
#define EBC_ACK		0x6800		/* Acknowledge Interrupt
					   (arg bits as in EB_STAT) */
#define EBC_SIM		0x7000		/* Set Interrupt Mask
					   (arg bits as in EB_STAT) */
#define EBC_SZM		0x7800		/* Set Zero Mask
					   (arg bits as in EB_STAT) */
#define EBC_SRXF	0x8000		/* Set RX Filter */
#define EBRXF_ADDR	0x01		/* Accept Individual Address */
#define EBRXF_AM	0x02		/* Accept Multicast */ 
#define EBRXF_AB	0x04		/* Accept Broadcast */
#define EBRXF_PROM	0x08		/* Promiscuous Mode */
#define EBRXF_HM	0x10		/* Hashed Multicast */ 
#define EBC_RXEARLY	0x8800		/* Set RX Early Threshold */
#define EBC_RXEAR_DIS	0x07ff		/* Disable RX Early interrupt */
#define EBC_TXSTART	0x9800		/* Set TX Start Threshold */
#define EBC_STATENB	0xa800		/* Statistics Enable */
#define EBC_STATDIS	0xb000		/* Statistics Disable */
#define EBC_COAXSTP	0xb800		/* Stop Coaxial Transceiver */
#define EBC_TXRCTHRE	0xc000		/* Set TX Reclaim Threshold (3C905B) */
#define EBC_TXRC_DIS	255		/* Disable TX Reclaim */
#define EBC_MCFILT	0xc800		/* Set Mcast Hash Filter */
#define EBC_MC_BIT(i)	((i)&0xff)	/* Bit To Program */
#define EBC_MC_ONE	0x0400		/* Value for 'one' */


/*
 * Status bits (read from EB_STAT)
 */
#define EBS_IL		0x0001		/* Interrupt Latch */
#define EBS_AF		0x0002		/* Adapter Failure */
#define EBS_TXC		0x0004		/* TX Complete */
#define EBS_RXC		0x0010		/* RX Complete */
#define EBS_RXE		0x0020		/* RX Early */
#define EBS_IREQ	0x0040		/* Interrupt Requested */
#define EBS_UPDS	0x0080		/* Update Statistics */
#define EBS_DNC		0x0200		/* Boomerang Download Complete */
#define EBS_UNC		0x0400		/* Boomerang Upload Complete */
#define EBS_CIP		0x1000		/* Command-In-Progress */
#define EBS_WINDOW	0xe000		/* Window number */

/*
 * Transmit Status (read from EB1_TXSTAT)
 */
#define EBTS_SOVFL	0x04		/* TX Status Overflow */
#define EBTS_MAXCOL	0x08		/* Maximum Collisions */
#define EBTS_UNDR	0x10		/* Underrun (TX Reset required) */
#define EBTS_JAB	0x20		/* Jabber Error (TX Reset req'd) */
#define EBTS_INT	0x40		/* EBD_COMPLT set in DPD */
#define EBTS_COMPL	0x80		/* TX is complete */

/*
 * Configuration Control Register (EB0_CC)
 */
#define EBCC_ENA	0x0001		/* Enable adapter */
#define EBCC_RST	0x0002		/* Reset adapter to POR */
#define EBCC_ICODEC	0x0100		/* Use internal encoder/decoder (R) */
#define EBCC_TP		0x0200		/* On-board 10BASE-T (TP) avail. (R) */
#define EBCC_RXTM	0x0400		/* Receive test mode (R) */
#define EBCC_TXTM	0x0800		/* Transmit test mode (R) */
#define EBCC_NORM	0x0c00		/* Normal mode (R) */
#define EBCC_BNC	0x1000		/* On-board 10BASE2 (BNC) avail. (R) */
#define EBCC_AUI	0x2000		/* AUI connector is available (R) */

/*
 * ResetOptions Register (EB2_RESOPT) (new style, 3C90xB)
 */
#define EBRO_FSMASK	0x0007		/* Feature Set mask */
#define EBRO_FSMBOARD	0x0		/* Motherboard (w/ mfilter) */
#define EBRO_FSLCOST	0x1		/* Low Cost */
#define EBRO_FSSTD	0x2		/* Standard (w/ mfilter) */
#define EBRO_FSSRVR	0x4		/* Server (w/ mfilter) */

/*
 * Internal Config Register (EB3_ICONFG)
 */
#define EBIC_RAMSIZE	0
#define EBIC_RAMWIDTH	3
#define EBIC_RAMSPEED	4
#define EBIC_ROMSIZE	6
#define EBIC_BADSSD	8
#define EBIC_RAMPART	16
#define EBIC_MSEL	20
#define EBIC_AUTOSEL	24

/* Ram Size */
#define EBIC_8K		0
#define EBIC_32K	2
#define EBIC_64K	3
#define EBIC_128K	4

/* Ram Width */
#define EBIC_BYTE	0
#define EBIC_WORD	1

/* Parition */
#define EBIC_53		0
#define EBIC_31		1
#define EBIC_11		2

/* Media */
#define EBIC_TP		0x0		/* Select 10base-T */
#define EBIC_AUI	0x1		/* Select AUI */
#define EBIC_FL		EBIC_AUI	/* 10baseFL = AUI */
#define EBIC_BNC	0x3		/* Select 10base-2 */
#define EBIC_TX		0x4		/* Select 100base-TX */
#define EBIC_FX		0x5		/* Select 100base-FX */
#define EBIC_MII	0x6		/* Select MII */
#define EBIC_AUTONEG	0x8		/* Select Auto-Negotiation PHY */

/* 
 * MAC control (EB3_MCTL)
 */
#define EBMCTL_FDX	0x0020		/* Full duplex enable */
#define EBMCTL_FLOW	0x0100		/* Enable 802.3x flow control (90xB) */

/*
 * Media Options Register (EB3_MEDOPT)
 */
#define EBMO_T4		0x0001		/* 100base-T4 available */
#define EBMO_TX		0x0002		/* 100base-TX available */
#define EBMO_FX		0x0004		/* 100base-FX available */
#define EBMO_TP		0x0008		/* 10base-T available */
#define EBMO_BNC	0x0010		/* 10base-2 available */
#define EBMO_AUI	0x0020		/* AUI available */
#define EBMO_MII	0x0040		/* MII available */
#define EBMO_FL		0x0100		/* 10base-FL available (90xB) */
#define	EBMO_GEN1MASK	0x00ff		/* Only these bits valid on 1st ASIC */

/*
 * Network Diagnostic (EB4_NDIAG)
 */
#define EBND_UBEN	0x0040		/* BytesTotal UpperBytes enable */

/*
 * Media Type and Status Register (EB4_MTS)
 */
#define EBMTS_SQESE	0x0008		/* TP - SQE Statistics Enable */
#define EBMTS_COLL	0x0010		/* Collision (R) */
#define EBMTS_CRS	0x0020		/* Carrier Sense (R) */
#define EBMTS_JABE	0x0040		/* TP - Jabber Error Enable */
#define EBMTS_LBE	0x0080		/* TP - Link Beat Enable */
#define EBMTS_UNSQ	0x0100		/* TP - Unsquelch (R) */
#define EBMTS_JAB	0x0200		/* TP - Jabber (R) */
#define EBMTS_POLSW	0x0400		/* TP - Polarity Swap (R) */
#define EBMTS_LBC	0x0800		/* TP - Link Beat Correct */
#define EBMTS_SQE	0x1000		/* SQE Present (R) */
#define EBMTS_TX	0x2000		/* TX in progress */
#define EBMTS_BNC	0x4000		/* BNC transceiver (R) */
#define EBMTS_AUID	0x8000		/* AUI disable (R) */

/*
 * Resource Configuration Register (EB0_RCNF)
 */
#define EBRC_IRQ(i)	(((i)<<12) | 0xf00) /* Set IRQ i */

/*
 * EB4_PMGMT PhysicalMgmt MII interface
 */
#define EBP_CLK		0x00000001	/* MII clock */
#define EBP_DATA	0x00000002	/* MII data */
#define EBP_DIR		0x00000004	/* MII direction (1=to PHY) */

/*
 * DMA Control Register (EBB_DCTL) (was PktStatus)
 */
#define EBDC_RXEARLYEN	0x00000020	/* Early upload of packets if reset */
#define EBDC_DIPROG	0x00000080	/* Download in Progress */

/*
 * EEPROM Command Register (EB0_PROMCMD)
 * EEPROM address is in bits [11:8,5:0].   
 * EEPROM command bits are in bit [7:6].  
 * Macro's move bits around to make a hole for the command bits
 */
#define EBPC_RREG(a)	(0x80 | \
			    (((a) & 0x1fc0) << 2) | \
			     ((a) & 0x003f)) /* Read EEPROM address a */

#define EBPC_EBY	0x8000		/* EEPROM is busy (R) */

/*
 * EEPROM Data Structure
 */
#define EBROM_ADDR(i)	(0x0a + (i))	/* OEM station address (word i) */
#define EBROM_SWINF2	0x0f		/* Software Info 2 */
#define EBROM_SW2_MWI	0x0020		/* MWI anomaly fixed */

/*
 * Multicast filter
 */
#define EBMFILTERSZ	256		/* Size of mcast filter */

/*
 * 3com-specific PCI registers
 */
#define	EBPCI_PWRMGMTCTL 0xe0		/* Power Management Control */

/*
 * EBPCI_PWRMGMTCTL bits
 */
#define	EBPWR_STMSK	0x03		/* PowerState Mask */
#define	EBPWR_STD0	0x00		/* State D0 */

/*
 * PCI_REVISION_ID fields (3C90xB only)
 */
#define	EBRI_ASIC(x)	(((x)>>5)&0x07)	/* Chip/vendor part */
#define	EBRI_ASIC0502	0x00		/* 40-0502-xxx */
#define	EBRI_ASIC0483	0x01		/* 40-0483-xxx */
#define	EBRI_ASIC0476	0x03		/* 40-0476-xxx */
#define	EBRI_REV(x)	((x) & 0x1f)	/* Chip revision */


