/*
 * Copyright (c) 1996, Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI if_expreg.h,v 1.8 2000/09/22 23:27:35 geertj Exp
 *
 * This code is derived from if_fxpreg.h written by David Greenman, his
 * original code carries the following copyright:
 *
 * Copyright (c) 1995, David Greenman
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice unmodified, this list of conditions, and the following
 *    disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by David Greenman.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	Id: if_fxpreg.h,v 1.2 1995/12/05 11:49:55 davidg Exp
 */

#define EXP_VENDORID_INTEL	0x8086
#define EXP_DEVICEID_i82557	0x1229
#define EXP_DEVICEID_i82559ER	0x1209
#define EXP_DEVICEID_i82559INBUSINESS 0x1030
#define EXP_DEVICEID_i82562 	0x2449

#define EXP_PCI_MEMORY_BA	0x10
#define EXP_PCI_PORT_BA		0x14

#define	EXP_REV_82557A		0x01
#define	EXP_REV_82557B		0x02
#define	EXP_REV_82557C		0x03
#define	EXP_REV_82558A		0x04
#define	EXP_REV_82558B		0x05
#define	EXP_REV_82559A		0x06
#define	EXP_REV_82559B		0x07
#define	EXP_REV_82559C		0x08
#define	EXP_REV_82559ER		0x09

/* CSRs (byte offsets into memory or I/O space */
#define	EXP_SCB_CUSRUS		0x00
#define	EXP_SCB_STATACK		0x01
#define	EXP_SCB_COMMAND		0x02
#define	EXP_SCB_INTRCNTL	0x03
#define	EXP_SCB_GENERAL		0x04
#define	EXP_SCB_PORT		0x08
#define	EXP_SCB_FLASH		0x0c
#define	EXP_SCB_EEPROM		0x0e
#define	EXP_MDI			0x10

#define EXP_SCB_RUS_IDLE		0
#define EXP_SCB_RUS_SUSPENDED		1
#define EXP_SCB_RUS_NORESOURCES		2
#define EXP_SCB_RUS_READY		4
#define EXP_SCB_RUS_SUSP_NORBDS		9
#define EXP_SCB_RUS_NORES_NORBDS	10
#define EXP_SCB_RUS_READY_NORBDS	12

#define EXP_SCB_CUS_IDLE		0
#define EXP_SCB_CUS_SUSPENDED		1
#define EXP_SCB_CUS_ACTIVE		2

#define EXP_SCB_STATACK_SWI		0x04
#define EXP_SCB_STATACK_MDI		0x08
#define EXP_SCB_STATACK_RNR		0x10
#define EXP_SCB_STATACK_CNA		0x20
#define EXP_SCB_STATACK_FR		0x40
#define EXP_SCB_STATACK_CXTNO		0x80

#define EXP_SCB_COMMAND_MASK		0xff
#define EXP_SCB_COMMAND_CU_NOP		0x00
#define EXP_SCB_COMMAND_CU_START	0x10
#define EXP_SCB_COMMAND_CU_RESUME	0x20
#define EXP_SCB_COMMAND_CU_DUMP_ADR	0x40
#define EXP_SCB_COMMAND_CU_DUMP		0x50
#define EXP_SCB_COMMAND_CU_BASE		0x60
#define EXP_SCB_COMMAND_CU_DUMPRESET	0x70

#define EXP_SCB_COMMAND_RU_NOP		0
#define EXP_SCB_COMMAND_RU_START	1
#define EXP_SCB_COMMAND_RU_RESUME	2
#define EXP_SCB_COMMAND_RU_ABORT	4
#define EXP_SCB_COMMAND_RU_LOADHDS	5
#define EXP_SCB_COMMAND_RU_BASE		6
#define EXP_SCB_COMMAND_RU_RBDRESUME	7

/*
 * Command block definitions
 */
typedef struct exp_cb_ias {
	volatile u_int16_t cb_status;
	volatile u_int16_t cb_command;
	volatile u_int32_t link_addr;
	volatile u_int8_t macaddr[6];
} exp_cb_ias_t;

typedef struct exp_cb_msu {
	volatile u_int16_t cb_status;
	volatile u_int16_t cb_command;
	volatile u_int32_t link_addr;
	volatile u_int16_t mc_cnt;
	volatile u_int8_t mlist[0];
} exp_cb_msu_t;

/* Configuration block */
#define	EXP_C1_RXFIFO_32	0x08
#define	EXP_C1_TXFIFO_0		0x00
#define	EXP_C5_DMBC_EN		0x80
#define	EXP_C6_LATE_SCB		0x01
#define EXP_C6_TNO_INT		0x04
#define EXP_C6_CI_INT		0x08
#define	EXP_C6_DRX_OVR		0x40
#define	EXP_C6_SAVE_BF		0x80
#define	EXP_C6_MUST_SET		0x32
#define	EXP_C7_DISC_SHORT	0x01
#define	EXP_C7_UNDERRUN_RETRY	1
#define	EXP_C8_MII		0x01
#define	EXP_C10_NSAI		0x08
#define EXP_C10_PRE_1		0x00
#define	EXP_C10_PRE_3		0x10
#define	EXP_C10_PRE_7		0x20
#define	EXP_C10_PRE_15		0x30
#define	EXP_C10_NO_LOOP		0x00
#define	EXP_C10_INT_LOOP	0x40
#define	EXP_C10_EXT_LOOP	0x80
#define EXP_C10_MUST_SET	0x06
#define	EXP_C12_L_PRI		0x01
#define	EXP_C12_IFS		4
#define	EXP_C14_MUST_SET	0xf2
#define	EXP_C15_PROMISC		0x01
#define	EXP_C15_NO_BCAST	0x02
#define	EXP_C15_CRS		0x80
#define	EXP_C15_MUST_SET	0x48
#define	EXP_C17_MUST_SET	0x40
#define	EXP_C18_STRIP		0x01
#define	EXP_C18_PAD		0x02
#define	EXP_C18_RCV_CRC		0x04
#define	EXP_C18_L_RX_OK		0x08
#define	EXP_C18_MUST_SET	0xf0
#define	EXP_C19_FDX_PIN_EN	0x80
#define	EXP_C19_FORCE_FDX	0x40
#define	EXP_C20_MULTI_IA	0x40
#define	EXP_C20_MUST_SET	0x3f
#define	EXP_C21_MC_ALL		0x08
#define	EXP_C21_MUST_SET	0x05

typedef struct exp_cb_config {
	volatile u_int16_t	cb_status;
	volatile u_int16_t	cb_command;
	volatile u_int32_t	link_addr;
	volatile u_int8_t	c[22];
	volatile u_int8_t	pad[2];
} exp_cb_config_t;

typedef struct exp_tbd {
	volatile u_int32_t tb_addr;
	volatile u_int32_t tb_size;
} exp_tbd_t;

typedef struct exp_cb_tx {
	volatile u_int16_t cb_status;
	volatile u_int16_t cb_command;
	volatile u_int32_t link_addr;
	volatile u_int32_t tbd_array_addr;
	volatile u_int16_t byte_count;
	volatile u_int8_t tx_threshold;
	volatile u_int8_t tbd_number;
	/*
	 * The following isn't actually part of the TxCB.
	 */
	volatile exp_tbd_t tbd[29];
	struct mbuf *mb_head;
	struct exp_cb_tx *next;
} exp_cb_tx_t;

/*
 * Control Block (CB) definitions
 */

/* status */
#define EXP_CB_STATUS_OK	0x2000
#define EXP_CB_STATUS_C		0x8000
/* commands */
#define EXP_CB_COMMAND_NOP	0x0
#define EXP_CB_COMMAND_IAS	0x1
#define EXP_CB_COMMAND_CONFIG	0x2
#define EXP_CB_COMMAND_MAS	0x3
#define EXP_CB_COMMAND_XMIT	0x4
#define EXP_CB_COMMAND_RESRV	0x5
#define EXP_CB_COMMAND_DUMP	0x6
#define EXP_CB_COMMAND_DIAG	0x7
/* command flags */
#define EXP_CB_COMMAND_SF	0x0008	/* simple/flexible mode */
#define EXP_CB_COMMAND_I	0x2000	/* generate interrupt on completion */
#define EXP_CB_COMMAND_S	0x4000	/* suspend on completion */
#define EXP_CB_COMMAND_EL	0x8000	/* end of list */

/*
 * RFA definitions
 */

typedef struct exp_rfa {
	volatile u_int16_t rfa_status;
	volatile u_int16_t rfa_control;
	volatile u_int32_t link_addr;
	volatile u_int32_t rbd_addr;
	volatile u_int16_t actual_size;
	volatile u_int16_t size;
} exp_rfa_t;
#define EXP_RFA_STATUS_RCOL	0x0001	/* receive collision */
#define EXP_RFA_STATUS_IAMATCH	0x0002	/* 0 = matches station address */
#define EXP_RFA_STATUS_S4	0x0010	/* receive error from PHY */
#define EXP_RFA_STATUS_TL	0x0020	/* type/length */
#define EXP_RFA_STATUS_FTS	0x0080	/* frame too short */
#define EXP_RFA_STATUS_OVERRUN	0x0100	/* DMA overrun */
#define EXP_RFA_STATUS_RNR	0x0200	/* no resources */
#define EXP_RFA_STATUS_ALIGN	0x0400	/* alignment error */
#define EXP_RFA_STATUS_CRC	0x0800	/* CRC error */
#define EXP_RFA_STATUS_OK	0x2000	/* packet received okay */
#define EXP_RFA_STATUS_C	0x8000	/* packet reception complete */
#define EXP_RFA_CONTROL_SF	0x08	/* simple/flexible memory mode */
#define EXP_RFA_CONTROL_H	0x10	/* header RFD */
#define EXP_RFA_CONTROL_S	0x4000	/* suspend after reception */
#define EXP_RFA_CONTROL_EL	0x8000	/* end of list */

/*
 * Statistics dump area definitions
 */
typedef struct exp_stats {
	volatile u_int32_t tx_good;
	volatile u_int32_t tx_maxcols;
	volatile u_int32_t tx_latecols;
	volatile u_int32_t tx_underruns;
	volatile u_int32_t tx_lostcrs;
	volatile u_int32_t tx_deffered;
	volatile u_int32_t tx_single_collisions;
	volatile u_int32_t tx_multiple_collisions;
	volatile u_int32_t tx_total_collisions;
	volatile u_int32_t rx_good;
	volatile u_int32_t rx_crc_errors;
	volatile u_int32_t rx_alignment_errors;
	volatile u_int32_t rx_rnr_errors;
	volatile u_int32_t rx_overrun_errors;
	volatile u_int32_t rx_cdt_errors;
	volatile u_int32_t rx_shortframes;
	volatile u_int32_t completion_status;
} exp_stats_t;
#define EXP_STATS_DUMP_COMPLETE	0xa005
#define EXP_STATS_DR_COMPLETE	0xa007
	
/*
 * Serial EEPROM control register bits
 */
/* shift clock */
#define EXP_EEPROM_EESK		0x01
/* chip select */
#define EXP_EEPROM_EECS		0x02
/* data in */
#define EXP_EEPROM_EEDI		0x04
/* data out */
#define EXP_EEPROM_EEDO		0x08

/*
 * Serial EEPROM opcodes, including start bit
 */
#define EXP_EEPROM_OPC_ERASE	0x4
#define EXP_EEPROM_OPC_WRITE	0x5
#define EXP_EEPROM_OPC_READ	0x6

/*
 * MDI register defs
 */
#define	EXP_MDI_DATA	0x0000ffff		/* Data area */
#define	EXP_MDI_SREG	16
#define	EXP_MDI_REG	(0x1f << EXP_MDI_SREG)	/* PHY register number */
#define	EXP_MDI_SPHY	21
#define	EXP_MDI_PHY	(0x1f << EXP_MDI_SPHY)	/* PHY address on MII bus */
#define	EXP_MDI_WRITE	(1 << 26)		/* Write command */
#define	EXP_MDI_READ	(2 << 26)		/* Read command */
#define	EXP_MDI_READY	(1 << 28)		/* Interface ready */
#define	EXP_MDI_IEN	(1 << 29)		/* Interrupt enable */
