/*-
 * Copyright (c) 1997 Berkeley Software Design, Inc.
 * All rights reserved. 
 * The Berkeley Software Design Inc. software License Agreement specifies  
 * the terms and conditions for redistribution.
 *
 *	BSDI if_sereg.h,v 2.3 1997/09/29 19:38:41 geertj Exp
 */

/*
 * PCI identification
 */
#define SE_VENDORID_SMC		0x10b8
#define SE_DEVICEID_EPIC100	0x0005


/*
 * Size of things
 */
#define SENFRAGS	10		/* #buffers per tx list (tunable) */


/* 
 * Registers. 
 * All access should be dword access only
 * Diagnostic registers are omitted. 
 */
#define	SE_COMMAND	0x00		/* Command register */
#define	SE_INTSTAT	0x04		/* Interrupt status register */
#define	SE_INTMASK	0x08		/* Interrupt mask register */
#define	SE_GENCTL	0x0c		/* General control register */
#define	SE_NVCTL	0x10		/* Non-volatile control register */
#define	SE_EECTL	0x14		/* EEPROM control register */
#define	SE_PBLCNT	0x18		/* bust length count register */
#define	SE_TEST		0x1c		/* mysterious and undocumented */
#define	SE_CRCCNT	0x20		/* CRC error counter */
#define	SE_ALICNT	0x24		/* Frame alignment counter */
#define	SE_MPCNT	0x28		/* Missed packet counter */
#define	SE_MMCTL	0x30		/* MII interface control register */
#define	SE_MMDATA	0x34		/* MII data register */
#define	SE_MIICFG	0x38		/* MII configuration register */
#define	SE_IPG		0x3c		/* Interpacket gap register */
#define	SE_LAN(i)	(0x40+((i)*4)) 	/* MAC address (shorts) */
#define	SE_ID		0x4c		/* Board ID / checksum */
#define	SE_MC(i)	(0x50+((i)*4))	/* Multicast hash table (shorts) */
#define	SE_RXCON	0x60		/* Receive control */
#define	SE_TXCON	0x70		/* Transmit control */
#define	SE_TXSTAT	0x74		/* Transmit status */
#define	SE_TXTEST	0x7c		/* undocumented */
#define	SE_PRCDAR	0x84		/* Receive current desc addr */
#define	SE_PRCPTHR	0xb0		/* Receive copy threshold */
#define	SE_PTCDAR	0xc4		/* Transmit current desc addr */
#define	SE_ETXTHR	0xdc		/* Early transmit threshold */


/* Command register (SE_COMMAND) */
#define	SEC_TXUGO	0x00000080	/* TX underrun restart */
#define	SEC_STOP_RDMA	0x00000040	/* Stop RX DMA engine */
#define	SEC_STOP_TDMA	0x00000020	/* Stop TX DMA engine */
#define	SEC_RXQUEUED	0x00000008	/* Queue RX descriptor */
#define	SEC_TXQUEUED	0x00000004	/* Queue TX descriptor */
#define	SEC_START_RX	0x00000002	/* Start RX circuitry */
#define	SEC_STOP_RX	0x00000001	/* Stop RX circuitry */


/* Interrupt status register (SE_INTSTAT) (also SE_INTMASK) */
#define	SEI_PTA		0x08000000	/* PCI target abort */
#define	SEI_PMA		0x04000000	/* PCI master abort */
#define	SEI_APE		0x02000000	/* PCI address parity abort */
#define	SEI_DPE		0x01000000	/* PCI data parity abort */
#define	SEI_RSV		0x00800000	/* RX status valid */
#define	SEI_RCTS	0x00400000	/* RX copy threshold status */
#define	SEI_RBE		0x00200000	/* RX buffer empty */
#define	SEI_TCIP	0x00100000	/* TX copy in progress */
#define	SEI_RCIP	0x00080000	/* RX copy in progress */
#define	SEI_TXIDLE	0x00040000	/* TX idle */
#define	SEI_RXIDLE	0x00020000	/* RX idle */
#define	SEI_INT_ACTV	0x00010000	/* Interrupt active */
#define	SEI_GP2_INT	0x00008000	/* GP2 low (PHY IRQ) */
#define	SEI_FATAL_INT	0x00001000	/* Fatal interrupt */
#define	SEI_RCT		0x00000800	/* RX copy threshold crossed */
#define	SEI_PREI	0x00000400	/* Preemptive RX interrupt */
#define	SEI_CNT		0x00000200	/* Stats counter overflow */
#define	SEI_TXU		0x00000100	/* TX underrun */
#define	SEI_TQE		0x00000080	/* TX queue empty */
#define	SEI_TCC		0x00000040	/* TX chain complete */
#define	SEI_TXC		0x00000020	/* TX complete */
#define	SEI_RXE		0x00000010	/* RX error */
#define	SEI_OVW		0x00000008	/* RX overflow warning */
#define	SEI_RQE		0x00000004	/* RX queue empty */
#define	SEI_HCC		0x00000002	/* RX header copy complete */
#define	SEI_RCC		0x00000001	/* RX copy complete */


/* General control register (SE_GENCTL) */
#define	SEG_RESET_PHY	0x00004000	/* Reset PHY */
#define	SEG_MEMRDCTL1	0x00000800	/* Memory read control 1 */
#define	SEG_MEMRDCTL0	0x00000400	/* Memory read control 0 */
#define	SEG_RXFIFOTHR1	0x00000200	/* RX FIFO threshold 1 */
#define	SEG_RXFIFOTHR0	0x00000100	/* RX FIFO threshold 0 */
#define	SEG_BIG_ENDIAN	0x00000020	/* Big endian enable */
#define	SEG_ONECOPY	0x00000010	/* RX one copy */
#define	SEG_PWRDOWN	0x00000008	/* Power down */
#define	SEG_SWINT	0x00000004	/* Generate software int */
#define	SEG_INTENA	0x00000002	/* Interrupt enable */
#define	SEG_SOFTRST	0x00000001	/* Soft reset */


/* Non-volatile control register (SE_NVCTL) */
#define	SENV_CB_MODE	0x0000040	/* CardBus mode enable */
#define	SENV_GP2	0x0000020	/* GP I/O 2 data value */
#define	SENV_GP1	0x0000010	/* GP I/O 1 data value */
#define	SENV_GP2OE	0x0000008	/* GP I/O 2 output enable */
#define	SENV_GP1OE	0x0000004	/* GP I/O 1 output enable */
#define	SENV_CLKRUN	0x0000002	/* Clock Run enable */
#define	SENV_MEMENA	0x0000001	/* Memory Map enable */


/* Mysterous and undocumented test register. SMC inits this, so do we. */
#define	SET_INIT	0x00000008	/* mysterious and undocumented */


/* EEPROM register (SE_EECTL) */
#define	SEE_SIZE	0x00000040	/* EEPROM size */
#define	SEE_RDY		0x00000020	/* EEPROM ready */
#define	SEE_DO		0x00000010	/* EEPROM data out */
#define	SEE_DI		0x00000008	/* EEPROM data in */
#define	SEE_SK		0x00000004	/* EEPROM serial clock */
#define	SEE_CS		0x00000002	/* EEPROM chip select */
#define	SEE_ENA		0x00000001	/* EEPROM control enable */


/*
 * Receive control register
 */
#define	SERC_BUFMASK	0x00000300	/* Buffer size mask (size in eeprom) */
#define	SERC_RXEARLY	0x00000080	/* Early receive enable */
#define	SERC_PROMISC	0x00000020	/* Promisc mode */
#define	SERC_MCAST	0x00000008	/* Receive multicast packets */
#define	SERC_BCAST	0x00000004	/* Receive broadcast packets */
#define	SERC_RUNT	0x00000002	/* Accept runt packets */
#define	SERC_ERRSAVE	0x00000001	/* Pass packets with errors */

/*
 * Transmit control register
 */
#define	SETC_SLOTMASK	0x000000f8	/* Slottime mask */
#define	SETC_FDX	0x00000006	/* Fullduplex enable */
#define	SETC_TXEARLY	0x00000001	/* TX early enable */


/* MII management interface control register (SE_MMCTL) */
#define	SEM_ADR(i)	((i) << 9)	/* address field */
#define	SEM_REG(i)	((i) << 4)	/* address field */
#define	SEM_WRITE	0x00000002	/* write comand */
#define	SEM_READ	0x00000001	/* read comand */


/*
 * Transmit DMA descriptor (with fragment list).
 *  *MUST* be aligned on 8-byte physical address!
 * For convienece, the fragment list is stashed directly behind
 * the descriptor, though there is no technical need to do this.
 */
struct se_txd {
	volatile u_short	se_stat;	/* TX status */
	volatile u_short	se_len;		/* TX #bytes in packet */
	vm_offset_t		se_list;	/* _phys_ ptr to frag list */
	short			_junk1;		/* unused in frag mode */
	u_short			se_ctl;		/* TX control field */
	vm_offset_t		se_next;	/* _phys_ ptr to next desc */

	/* Frag list */
	u_long			se_nfrags;	/* # of frags */
	struct se_txfrag {
		vm_offset_t	se_frag;	/* _phys_ ptr to frag */
		u_long		se_fraglen;	/* frag length */
	} se_frags[SENFRAGS];

	/* Following not visible to chip: */
	struct mbuf		*se_mbuf;	/* head of mbuf chain */
};

/*
 * Transmit status fields
 */
#define	SETS_NICOWN	0x8000			/* 0=host, 1=NIC */

/*
 * Transmit control fields
 */
#define	SETC_IAF	0x0004			/* Intr after frame TXed */
#define	SETC_FRAGLIST	0x0001			/* Descriptior uses frags */


/*
 * Receive DMA descriptor (no fragments needed).
 * *MUST* be aligned on 8-byte physical address!
 */
struct se_rxd {
	volatile u_short	se_stat;	/* RX status */
	volatile u_short	se_len;		/* #bytes in rx'ed packet */
	vm_offset_t		se_buf;		/* _phys_ ptr to data buffer */
	u_short			se_bufsiz;	/* size of buffer */
	u_short			se_ctl;		/* RX control field */
	vm_offset_t		se_next;	/* _phys_ ptr to next desc */

	/* Following not visible to chip: */
	struct mbuf		*se_mbuf;	/* head of mbuf chain */
	struct se_rxd		*next;		/* ptr to next desc */
};

/*
 * Receiver status fields
 */
#define	SERS_NICOWN	0x8000			/* 0=host, 1=NIC */
#define	SERS_HCOPIED	0x4000			/* header copied */
#define	SERS_NVALID	0x1000			/* network stat valid */
#define	SERS_RXDIS	0x0040			/* RX disabled */
#define	SERS_RXOVL	0x0008			/* missed packet */
#define	SERS_CRCERR	0x0004			/* CRC error */
#define	SERS_FERR	0x0002			/* Framing error */
#define	SERS_RXOK	0x0001			/* packet RX'ed OK */


/* 93c46 EEPROM */
#define	SEEE_EADDR(i)	(i)		/* MAC address */
#define	SEEE_NAME(i)	((i) + 0x2c)	/* Adapter name */
#define	SEEE_NAMESZ	12		/* Adapter name length */


