/*-
 * Copyright (c) 1997 Berkeley Software Design, Inc.
 * All rights reserved. 
 * The Berkeley Software Design Inc. software License Agreement specifies  
 * the terms and conditions for redistribution.
 *
 *	BSDI if_tlreg.h,v 2.1 1997/08/13 21:44:08 geertj Exp
 */

/*
 * PCI identification
 */
typedef struct {
	u_int	tl_vendor;			/* PCI vendorID */
	u_int	tl_device;			/* PCI deviceID */
} tl_pcidefs_t;


/* Chip constants - do not change */
#define TLTXBUF		10			/* #buffers per tx list */
#define TLHASHSZ	8			/* #bytes in hash table */

/*
 * Packet buffer - used by tl_rxl and tl_txl
 */
struct tl_buf {
	volatile u_long		tl_blen;	/* buffer length */
	volatile vm_offset_t	tl_baddr;	/* buffer address */
};

#define	TLB_EOL	0x80000000			/* End of List */

/*
 * Receive List - One Fragment version. 
 * *MUST* be aligned on 8-byte physical address!
 */
struct tl_rxl {
	volatile vm_offset_t	tl_forw;  /* _physical_ ptr to next list */
	volatile u_short	tl_cstat; /* receive status */
	volatile u_short	tl_len;	  /* #bytes in packet */
	struct tl_buf		tl_buf;	  /* receive buffer */

					/* Following not visible to chip: */
	struct mbuf	*tl_mbuf;	/* head of mbuf chain */
	struct tl_rxl	*next;		/* _virtual_ pointer to next list */
	vm_offset_t	forw;  		/* canned _physical_ ptr to next */
	u_long		_junk;		/* filler len to multiple of 8 */
};

/*
 * Receive CSTAT fields
 */
#define	TLRX_CSTAT	0x3000		/* RX Request CSTAT preset */
#define	TLRX_FRM_CMP	0x4000		/* Frame has been transferred */
#define	TLRX_RX_EOC	0x0800		/* Receiver End Of Channel */
#define	TLRX_RX_ERR	0x0400		/* Error Frame */


/*
 * Transmit List
 *  *MUST* be aligned on 8-byte physical address!
 */
struct tl_txl {
	volatile vm_offset_t	tl_forw;  /* _physical_ ptr to next pd */
	volatile u_short	tl_cstat; /* transmit status */
	volatile u_short	tl_len;	  /* #bytes in packet */
	struct tl_buf	tl_buf[TLTXBUF];  /* transmit buffers */

					/* Following not visible to chip: */
	struct mbuf	*tl_mbuf;	/* head of mbuf chain */
	u_long		_junk;		/* filler len to multiple of 8 */
};

/*
 * Transmit CSTAT fields
 */
#define	TLTX_CSTAT	0x3000		/* TX Request CSTAT preset */
#define	TLTX_FRM_CMP	0x4000		/* Frame has been transferred */
#define	TLTX_TX_EOC	0x0800		/* Transmitter End Of Channel */


/*
 * Host registers. These are directly accessible.
 */
#define	TLH_HOST_CMD	0x00		/* [L] Command port */
#define	TLH_CH_PARM	0x04		/* [L] DMA address / cmd parameters */
#define	TLH_DIO_ADR	0x08		/* [S] DIO address */
#define	TLH_HOST_INT	0x0a		/* [S] Interrupt source */
#define	TLH_DIO_DATA	0x0c		/* [L] DIO data */


/* 
 * HOST_CMD (TLH_HOST_CLD) register 
 * The ThunderLAN does not have numerical commands, but bitmasks.
 * So, if your command is not here, then just add it..
 */
#define	TLCMD_AD_RST	0x00008000	/* Reset ThunderLAN */
#define	TLCMD_TX_GO	0x80000000	/* TX Go */
#define	TLCMD_RX_GO	0x80080000	/* RX Go */
#define	TLCMD_TX_STOP	0x40000000	/* TX Stop */
#define	TLCMD_RX_STOP	0x40080000	/* RX Stop */
#define	TLCMD_REQ_INT	0x00001000	/* Request Interrupt */
#define	TLCMD_INT_DIS	0x00000800	/* Interrupt Disable */
#define	TLCMD_INT_ENA	0x00000400	/* Interrupt Enable */
#define	TLCMD_IACK(v,t,c) /* vector, type, count */ \
		(0x20000000|(c)|(((v)|(t)<<16))) /* Ack intr */


/* 
 * HOST_INT (TLH_HOST_INT) register
 */
#define	TLINT_VEC(i)	((i)&0x1fe0)	/* Interrupt Vector */
#define	TLINT_TYPE(i)	((i)&0x1c)	/* Interrupt Type */

/* Values for TLINT_TYPE */
#define	TLIT_NONE	0x00		/* No Interrupt */
#define	TLIT_TXEOF	0x04		/* TX EOF */
#define	TLIT_STATS	0x08		/* Statistics Overflow */
#define	TLIT_RXEOF	0x0c		/* TX EOF */
#define	TLIT_DUMMY	0x10		/* Dummy Int (TLCMD_REQ_INT) */
#define	TLIT_TXEOC	0x14		/* TX EOC */
#define	TLIT_CHECK	0x18		/* Adapter Check */
#define	TLIT_RXEOC	0x1c		/* RX EOC */


/*
 * Internal registers. These are reachable via TLH_DIO_ADR and TLH_DIO_DATA.
 */
#define	TLI_NETCMD	0x00		/* [B] Set diagnostic modes */
#define	TLI_NETSIO	0x01		/* [B] MII / EEPROM interface */
#define	TLI_NETSTS	0x02		/* [B] Interrupt source */
#define	TLI_NETMASK	0x03		/* [B] Interrupt mask */
#define	TLI_NETCONFIG	0x04		/* [S] Network configugarion options */
#define	TLI_AREG(i)	(0x10+(i))	/*     Address reg 0-3 */
#define	TLI_HASH(i)	(0x28+(i))	/*     multicast hash filters 1-2 */
#define	TLI_TXGOOD	0x30		/* [24] Good TX frames */
#define	TLI_TXUNDER	0x33		/* [B] TX underruns */
#define	TLI_RXGOOD	0x34		/* [24] Good RX frames */
#define	TLI_RXUNDER	0x37		/* [B] RX underruns */
#define	TLI_TXDEFER	0x38		/* [S] Deferred TX frames */
#define	TLI_CRCERR	0x3a		/* [B] CRC errors */
#define	TLI_CODERR	0x3b		/* [B] Code errors */
#define	TLI_TXMULCOL	0x3c		/* [S] Multicollision TX frames */
#define	TLI_TXSINCOL	0x3e		/* [S] Single collision TX frames */
#define	TLI_EXCOL	0x40		/* [B] Excessive collisions */
#define	TLI_LATECOL	0x41		/* [B] Late collisions */
#define	TLI_NOCARR	0x42		/* [B] Carrier loss */
#define	TLI_ACOMMIT	0x43		/* [B] TX FIFO params / PHY options */ 
#define	TLI_LEDREG	0x44		/* [B] LED control */
#define	TLI_BSIZEREG	0x45		/* [B] DMA burst sizes */
#define	TLI_MAXRX	0x46		/* [S] Max RX packet size */
#define	TLI_INTDIS	0x48		/* [B] EOC and EOF interrupt disable */
#define	TLI_ADR_INC	0x8000		/* Auto-increment DIO address */


/* NetSio (TLI_NETSIO) register */
#define	TLSIO_MINTEN	0x80		/* MII interrupt enable */
#define	TLSIO_ECLK	0x40		/* EEPROM SIO clock */
#define	TLSIO_ETXEN	0x20		/* EEPROM SIO transmit enable */
#define	TLSIO_EDATA	0x10		/* EEPROM SIO data */
#define	TLSIO_NMRST	0x08		/* MII not reset (active low) */
#define	TLSIO_MCLK	0x04		/* MII SIO clock*/
#define	TLSIO_MTXEN	0x02		/* MII SIO transmit enable */
#define	TLSIO_MDATA	0x01		/* MII SIO data */
#define	TLSIO_EEMASK	(TLSIO_ECLOK|TLSIO_ETXEN|TLSIO_EDATA)
#define	TLSIO_MIIMASK	(TLSIO_MINTEN|TLSIO_NMRST|TLSIO_MCLK|TLSIO_MTXEN|TLSIO_MDATA)


/* NetCmd (TLI_NETCMD) register */
#define	TLNCMD_NRESET	0x80		/* not Reset */
#define	TLNCMD_NWRAP	0x40		/* not Wrap */
#define	TLNCMD_CAF	0x10		/* Copy All Frames (promisc) */
#define	TLNCMD_DUPLEX	0x04		/* Duplex mode */
#define	TLNCMD_TRFRAM	0x02		/* Token Ring Framing */


/* NetConfig (TLI_NETCONFIG) register. Can only be writted if chip reset */
#define	TLNCNF_BITRATE	0x2000		/* 8391 mode */
#define	TLNCNF_ONEFRAG	0x0400		/* One Fragment on receive */
#define	TLNCNF_ONECHN	0x0200		/* One Channel mode */
#define	TLNCNF_PHY_EN	0x0080		/* Enable built-in PHY */
#define	TLNCNF_MAC_0	0x0000		/* MAC=CSMA/CD */


/* NetSts/NetMask (TLI_NETSTS/TLI_NETMASK) registers */
#define	TLINT_MIRQ	0x80		/* MII IRQ */
#define	TLINT_HBEAT	0x40		/* Heartbeat IRQ */
#define	TLINT_TXSTOP	0x20		/* TX stop IRQ */
#define	TLINT_RXSTOP	0x10		/* RX stop IRQ */


/* 
 * Status registers. Since these have odd sizes, we read 4 bytes
 * at a time (with auto-increment), and mask off the registers we need.
 */
#define	TLST_TXFOK(i)	((i) & 0x00ffffff)	/* [30] TX frames TX'ed OK */
#define	TLST_TXUNDR(i)	(((i) >> 24) & 0xff)	/* [33] TX underruns */

#define	TLST_RXFOK(i)	((i) & 0x00ffffff)	/* [34] RX frames RX'ed OK */
#define	TLST_RXOVR(i)	(((i) >> 24) & 0xff)	/* [37] RX overruns */

#define	TLST_TXDEF(i)	((i) & 0x0000ffff)	/* [38] TX deferrals */
#define	TLST_RXCRC(i)	(((i) >> 16) & 0xff)	/* [3a] RX CRC errors */
#define	TLST_RXCERR(i)	(((i) >> 24) & 0xff)	/* [3b] RX code errors */

#define	TLST_TXMCOL(i)	((i) & 0xffff)		/* [3c] TX multiple colls */
#define	TLST_TXSCOL(i)	(((i) >> 16) & 0xffff) 	/* [3e] TX single colls */

#define	TLST_TXECOL(i)	((i) & 0xff)		/* [40] TX excessive colls */
#define	TLST_TXLCOL(i)	(((i) >> 8) & 0xff)	/* [41] TX late colls */
#define	TLST_RXNCARR(i)	(((i) >> 16) & 0xff) 	/* [42]X Carrier lost events */


/*
 * LED register. 1=on
 */
#define	TLLED_LINK	0x01		/* LINK LED (if applicatable) */
#define	TLLED_ACT	0x10		/* Activity LED (if applicatable) */
#define	TLLED_MWI	0x80		/* Orion workaround */


/* 24c02 EEPROM */
#define	TLEE_SLAVEWR	0xa0		/* Slave address for write */
#define	TLEE_SLAVERD	(0xa0|0x01)	/* Slave address for read */
#define	TLEE_EADDR(i)	(0x83 + (i))	/* Station address #1 */


