/*-
 * Copyright (c) 1998 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI if_trbreg.h,v 2.2 1999/01/29 10:19:28 geertj Exp
 */

/*
 * PCI ID codes
 */
#define TRB_VENDOR_ID	0x10b7		/* 3COM */
#define TRB_DEVICE_ID	0x3590		/* 3C359 */


/*
 * Packet fragment - used by trb_dpd and trb_upd
 */
struct trb_frag {
	volatile vm_offset_t	trb_faddr;	/* fragment address */
	volatile u_int32_t	trb_flen;	/* fragment length */
};


/*
 * Download (TX) Packet Data Structure - DPD
 *  Total size cannot exceed 512 bytes
 *  It must be aligned on 8-byte physical address.
 *  We steal a slot for mbuf info, so reduce fragments by 1
 */
#define TRB_DFRAG	62	/* Max no of frags in DPD (nochange) */
struct trb_dpd {
	volatile vm_offset_t	trb_next;	/* _physical_ ptr to next pd */
	volatile u_int32_t	trb_fsh;	/* packet length and bits */
	struct trb_frag	trb_frag[TRB_DFRAG];	/* download fragments */

					/* Following not visible to chip: */
	struct mbuf	*trb_mbuf;	/* head of mbuf chain */
	u_int32_t	_junk;		/* pad length to multiple of 8 */
};
typedef int _trb_dpd_dummy[1/((sizeof(struct trb_dpd) % 8) == 0)];


/*
 * Upload (RX) Packet Data Structure - UPD
 *  It must aligned on 8-byte physical address.
 */
struct trb_upd {
	volatile vm_offset_t	trb_next;	/* _physical_ ptr to next pd */
	volatile u_int32_t	trb_fsh;	/* packet length and bits */
	struct trb_frag		trb_frag;	/* upload fragment */

					/* Following not visible to chip: */
	struct mbuf	*trb_mbuf;	/* head of mbuf chain */
	struct trb_upd	*next;		/* _virtual_ pointer to next upd */
	u_int32_t	_junk[2];	/* pad length to multiple of 8 */
};
typedef int _trb_upd_dummy[1/((sizeof(struct trb_upd) % 8) == 0)];


/*
 * Packet Descriptor Frame Start Header (trb_fsh) flags
 *
 * R for received packets, T for transmitted packets
 */
#define TRBD_LEN(l) ((l) & 0x00003fff)	/* TR Packet Length (sum of frags) */
#define TRBD_NOCRC	0x00008000	/* T  CRC generation disable */
#define TRBD_DNC	0x00010000	/* T  Download Complete */
#define TRBD_TXI	0x10000000	/* T  TXcomplete interrupt enable */
#define TRBD_DNCI	0x80000000	/* T  Download Complete Interrupt */

#define TRBD_ARRMASK	0x00070000	/*  R Address Recognition Register */
#define TRBD_ARR_ARR0	0x00000000	/*  R ARR: this node */
#define TRBD_ARR_ARR4	0x00040000	/*  R ARR: this node, MAC buffers */
#define TRBD_ARR_ARR5	0x00050000	/*  R ARR: source routing */
#define TRBD_ARR_ARR7	0x00070000	/*  R ARR: functional addressing */
#define TRBD_OVRRUN	0x00080000	/*  R Overrun */
#define TRBD_RXFC	0x00200000	/*  R Frame Copied bit */
#define TRBD_RXAR	0x00400000	/*  R Address Recognized bit */
#define TRBD_UPC	0x00800000	/*  R Upload complete */
#define TRBD_UPF	0x01000000	/*  R UPD full */
#define TRBD_RCSMASK	0x06000000	/*  R Receive status mask */
#define TRBD_RCS_NORM	0x00000000	/*  R Receive status=normal */
#define TRBD_SRC	0x08000000	/*  R Source Route Compare */
#define TRBD_REDI	0x10000000	/*  R Return Error Detect Indication */
#define TRBD_RLPEDI	0x20000000	/*  R Ret Loc Pkt Err Det Indication */
#define TRBD_RXGROUP	0x40000000	/*  R Received group address */
#define TRBD_RXBCST	0x80000000	/*  R Received broadcast */

/*
 * Packet Fragment (trb_flen) flags
 *
 * R for received packets, T for transmitted packets
 */
#define TRBF_LEN(l) ((l) & 0x00001fff)	/* TR Fragment Length */
#define TRBF_LAST 	0x80000000	/* TR Last Fragment */


/* Host Register Set */
struct trb_hrs {
	char			_junk00[16];
	volatile u_int16_t	MauiData;
	char			_junk12[2];
	volatile u_int32_t	MauiAccessCmd;
	char			_junk18[2];
	volatile u_int8_t	Timer;
	char			_junk1b;
	volatile u_int32_t	Test;
	volatile u_int32_t	DmaCtrl;
	volatile u_int32_t	DnListPtr;
	volatile u_int8_t	HashFilter;
	volatile u_int8_t	Config;
	volatile u_int16_t	DnTgtBurst;
	volatile u_int8_t	DnPriReqThresh;
	volatile u_int8_t	DnPoll;
	char			_junk2e[2];
	volatile u_int32_t	UpPktStatus;
	volatile u_int16_t	FreeTimer;
	volatile u_int16_t	Countdown;
	volatile u_int32_t	UpListPtr;
	char			_junk3c;
	volatile u_int8_t	UpPoll;
	char			_junk3e[2];
	volatile u_int8_t	UpBurstThresh;
	volatile u_int8_t	DnBurstThresh;
	char			_junk42[20];
	volatile u_int16_t	IntStatusAuto;
	volatile u_int16_t	TxStartThresh;
	volatile u_int16_t	InterruptEnable;
	volatile u_int16_t	IndicationEnable;
	volatile u_int16_t	Command;	/* Also IntStatus */
#define IntStatus Command
};

/*
 * DmaCtrl fields
 */
#define TRBDA_DIP	0x00000080	/* Download in Progress */

/*
 * Commands to write to hrs.Command
 * The argument should be OR-ed with the command word
 */
#define TRBC_RESET	0x0000		/* Global Reset */
#define TRBC_RES_PHY	0x0001		/*  mask PHY */
#define TRBC_RES_MAUIT	0x0002		/*  maui test mode */
#define TRBC_RES_MAUI	0x0004		/*  mask maui */
#define TRBC_RES_FIFO	0x0008		/*  mask FIFO logic */
#define TRBC_RES_HOST	0x0020		/*  mask bus interface logic */
#define TRBC_RES_UDWN	0x0100		/*  mask up/download logic */
#define TRBC_URST	0x2800		/* Reset Upload */
#define TRBC_USTALL	0x3000		/* Upload Stall */
#define TRBC_UUSTALL	0x3001		/* Upload UnStall */
#define TRBC_DSTALL	0x3002		/* Download Stall */
#define TRBC_DUSTALL	0x3003		/* Download UnStall */
#define TRBC_CONFIG	0x4000		/* Set Config */
#define TRBC_CFG_HASH	0x0001		/*  enable hash filter */
#define TRBC_CFG_8192	0x0002		/*  max upload=8192 bytes */
#define TRBC_CFG_20480	0x0004		/*  max upload=20480 bytes */
#define TRBC_CFG_DPT	0x0008		/*  keep download FIFO full */
#define TRBC_CFG_DOG	0x0010		/*  enable transmitter watchdog */
#define TRBC_DENB	0x4800		/* Download Enable */
#define TRBC_DDIS	0x5000		/* Download Disable */
#define TRBC_DRST	0x5800		/* Download Reset */
#define TRBC_IREQ	0x6000		/* Request Interrupt */
#define TRBC_IACK	0x6800		/* Acknowledge Interrupt */
#define	TRBC_I_MASK	0x00ff		/*  ack mask */
#define	TRBC_I_IL	0x0001		/*  ack IL */
#define	TRBC_I_TXC	0x0002		/*  ack TXC */
#define	TRBC_I_IREQ	0x0004		/*  ack IREQ */
#define	TRBC_I_DNC	0x0008		/*  ack DNC */
#define	TRBC_I_UPC	0x0010		/*  ack UPC */
#define	TRBC_I_ASBF	0x0020		/*  ack ASBF */
#define	TRBC_I_SRBR	0x0040		/*  ack SRBR */
#define	TRBC_I_ARBC	0x0080		/*  ack ARBC */
#define TRBC_SIM	0x7000		/* Set Interrupt Mask */
#define TRBC_SZM	0x8000		/* Set Zero Mask */
#define	TRBC_S_MASK	0x0fff		/*  mask bits */
#define	TRBC_S_HERR	0x0001		/*  mask HERR */
#define	TRBC_S_TXC	0x0002		/*  mask TXC */
#define	TRBC_S_UPDREQ	0x0004		/*  mask UPDREQ */
#define	TRBC_S_RXC	0x0008		/*  mask RXC */
#define	TRBC_S_IREQ	0x0010		/*  mask IREQ */
#define	TRBC_S_MERR	0x0020		/*  mask MERR */
#define	TRBC_S_DNC	0x0040		/*  mask DNC */
#define	TRBC_S_UPC	0x0080		/*  mask UPC */
#define	TRBC_S_TXUNDR	0x0100		/*  mask TXUNDR */
#define	TRBC_S_ASBF	0x0200		/*  mask ASBF */
#define	TRBC_S_SRBR	0x0400		/*  mask SRBR */
#define	TRBC_S_ARBC	0x0800		/*  mask ARBC */
#define TRBC_TXSTART	0x9800		/* Set TX Start Threshold */
#define TRBC_RXDISCARD	0xc000		/* Discard RC frame */
#define TRBC_MCFILT	0xc800		/* Set Mcast Hash Filter */
#define TRBC_MC_BIT(i)	((i)&0xff)	/* Bit To Program */
#define TRBC_MC_ONE	0x0400		/* Value for 'one' */

/*
 * IntStatus bits (read from IntStatus, IntStatusAuto)
 */
#define	TRBS_IL		0x0001		/* Interrupt line active */
#define	TRBS_HERR	0x0002		/* Host error */
#define	TRBS_TXC	0x0004		/* TX complete */
#define	TRBS_UPDREQ	0x0008		/* UPD needed */
#define	TRBS_RXC	0x0010		/* RX complete */
#define	TRBS_IREQ	0x0040		/* Interrupt requested */
#define	TRBS_MERR	0x0080		/* MAC error */
#define	TRBS_DNC	0x0200		/* Download complete */
#define	TRBS_UPC	0x0400		/* Upload complete */
#define	TRBS_TXUNDR	0x0800		/* TX underrun */
#define	TRBS_CIP	0x1000		/* Command-In-Progress */
#define	TRBS_ASBF	0x2000		/* ASB service request */
#define	TRBS_SRBR	0x4000		/* SRB service request */
#define	TRBS_ARBC	0x8000		/* ARB service request */

/* Fixed initialisation constants, from documentation */
#define	TRB_DNPRIREQTHRESH_INIT 4	/* 128 bytes pri req thresh */
#define	TRB_DNBURSTTHRESH_INIT 8	/* 256 bytes burst req thresh */
#define	TRB_UPPRIREQTHRESH_INIT 4	/* 128 bytes pri req thresh */

/*
 * Commands for hrs->MauiAccessCmd
 * Note that the values for TRBMAC_8BIT and TRBMAC_16BIT are swapped
 * compared to p.96 of the 0.6 ERS
 */
#define	TRBMAC_SREAD	0x84000000	/* Sram Read command */
#define	TRBMAC_SWRITE	0x44000000	/* Sram Write command */
#define	TRBMAC_MIOREAD	0x80000000	/* MMIO Read command */
#define	TRBMAC_MIOWRITE	0x40000000	/* MMIO Write command */
#define	TRBMAC_LIOREAD	0x20000000	/* LocalIO Read command */
#define	TRBMAC_LIOWRITE	0x10000000	/* LocalIO Write command */
#define	TRBMAC_8BIT	0x08000000	/* Byte access */
#define	TRBMAC_16BIT	0x00000000	/* Word access */

/*
 * localIO registers (access via trblioread/write())
 */
#define	TRBLIO_CPA	0x180d		/* RW CP Attention */
#define	TRBLIO_PMBAR	0x1c80		/* RW Private Memory base Addr Reg */
#define	TRBLIO_SWS	0x1c88		/* RW Ring Speed */
#define	TRBLIO_EECTL	0x1c8a		/* RW EEprom Control */
#define	TRBLIO_EEDATA	0x1c8c		/* RW EEprom Data */

/* Values for TRBLIO_PMBAR */
#define	TRBPMBAR_ENBIOS	0x0800		/* Enable BIOS extension */
#define	TRBPMBAR_CPHOLD	0x0400		/* Reset/hold CP */
#define	TRBPMBAR_WDTD	0x0200		/* Disable WatchDogTimer */
#define	TRBPMBAR_PMB_MASK 0x01fc		/* Private memory Base mask */

/* Values for TRBLIO_SWS */
#define	TRBSWS_MASK	0x0002		/* Ring speed mask */
#define	TRBSWS_4MBIT	0x0002		/* Ring speed: 4 mbps */
#define	TRBSWS_16MBIT	0x0000		/* Ring speed: 16 mbps */

/* Values for TRBLIO_CPA */
#define	TRBCPA_MEMWREN	0x40		/* Disable memory protection */

/* Values for TRBLIO_EECTL */
#define	TRBPC_EEBUSY	0x8000		/* EEprom busy */

#define TRBPC_WDIS	0x00		/* Write/Erase Disable */
#define TRBPC_WALL	0x10		/* Write All Registers */
#define TRBPC_EALL	0x20		/* Erase All Registers */
#define TRBPC_WENB	0x30		/* Write/Erase Enable */
#define TRBPC_WREG(a)	(0x40 | (a))	/* Write EEPROM address a */
#define TRBPC_RREG(a)	(0x80 | (a))	/* Read EEPROM address a */
#define TRBPC_EREG(a)	(0xc0 | (a))	/* Erase EEPROM register a */


/*
 * MMIO registers (access via trbmmioread/write())
 * XXX reading TRBMMIO_WRBR doesn't work in word mode - 
 *     use two byte reads instead. 
 */
#define	TRBMMIO_WRBR	0xcde02		/* Write Region Base Register */
#define	TRBMMIO_WWOR	0xcde04		/* Write Window Open Register */
#define	TRBMMIO_WWCR	0xcde06		/* Write Window Close Register */
#define	TRBMMIO_MS	0xcde08		/* MacStatus */
#define	TRBMMIO_MISR	0xcde0b		/* MAC ASIC ISR */
#define	TRBMMIO_MISR_AND 0xcde2b	/* MAC ASIC ISR, AND operation */
#define	TRBMMIO_MISR_OR	0xcde4b		/* MAC ASIC ISR, OR operation */
#define	TRBMMIO_RBA	0xcde10		/* RxBufArea */
#define	TRBMMIO_RET	0xcde12		/* RxEarlyThresh */

/* Values for MISR (MAC ASIC ISR) */
#define	TRBMISR_ARBF	0x02		/* ARB complete */
#define	TRBMISR_ASBFR	0x04		/* ASB free int req */
#define	TRBMISR_SRBFR	0x08		/* SRB free int req */
#define	TRBMISR_RASB	0x10		/* ARB read cmd */
#define	TRBMISR_CSRB	0x20		/* SRB read cmd */

/* Fixed register initialisation constants, from documentation */
#define	TRBMMIO_RBA_INIT 0xd000		/* RX buffers (Voyager FIFO) */
#define	TRBMMIO_RET_INIT 0x20		/* RX Early Threshold = 64 bytes */


/*
 * EEPROM Data Structure
 */
#define TRBROM_ADDR(i)	(0x10 + (i))	/* OEM station address (word i) */
#define TRBROM_PMBAR	0x0b		/* PMBAR initialisation */
#define TRBROM_SWS	0x08		/* SWS initialisation */


/*
 * SRAM/microcode constants
 */
#define	TRBMINUCODESZ	0x4000		/* min code size (arbitrary) */
#define	TRBMAXUCODESZ	0x8000		/* max code size */
#define	TRBRAMOFF	0xd0000		/* offset of RAM address */

#define	TRBSTART(i)	(0x10000 - (i))	/* begin of code */
#define	TRBEND		0x10000		/* end of code */
#define	TRBJMP		0xfff0		/* jmp opcode (90 ea) */
#define	TRBJMPOFF	0xfff2		/* code start offset (from ucode) */
#define	TRBJMPSEG	0xfff4		/* code start segment (patchable) */
#define	TRBSRAMARBF	0xffe1		/* make 0xff for ARBF */
#define	TRBSRAMASBFR	0xffe2		/* make 0xff for ASBFR */
#define	TRBSRAMSRBFR	0xffe3		/* make 0xff for SRBFR */
#define	TRBSRAMRASB	0xffe4		/* make 0xff for RASB */
#define	TRBSRAMCSRB	0xffe5		/* make 0xff for CSRB */



/* SRB commands / return codes */

#define TRBCMD_OPEN_NIC	0x03		/* Insert NIC in ring */
#define TRBCMD_CLOSE_NIC 0x04		/* Remove NIC from ring */
#define TRBCMD_READ_LOG	0x08		/* Read & reset er counters */
#define TRBCMD_SET_RX_MODE 0x1f		/* Set receive mode */

#define	TRBRC_OK	0x00		/* Cmd completed successfully */
#define	TRBRC_BADCMD	0x01		/* Invalid command code */
#define	TRBRC_MBOPEN	0x04		/* NIC closed; must be open */
#define	TRBRC_BADOPT	0x06		/* Invalid options */
#define	TRBRC_ERRCODE	0x07		/* Cmd failed; see error code */
#define	TRBRC_NOAVAIL	0x46		/* Not available */

/*
 * Open NIC SRB / SRB response
 */
struct trb_open_srb {
	u_int8_t	cmd;
	char		_junk1[7];
	u_int16_t	options;
	u_int8_t	node_addr[6];
	u_int8_t	group_addr[4];
	u_int8_t	func_addr[4];
	char		_junk24[8];
	u_int8_t	protocol;
	u_int8_t	supp_error;
	char		_junk34[8];
	char		_junk42[18];
};

#define	TRBOPEN_NIC_OPTIONS_ETR	0x1000	/* NO Early Token Release (16mbit) */
#define	TRBOPEN_NIC_PROTO_KXITKP 0x00	/* TXI/TKP */
#define	TRBOPEN_NIC_PROTO_TKP	0x01	/* TKP only */
#define	TRBOPEN_NIC_PROTO_KXI	0x02	/* TXI only */

struct trb_open_srbr {
	u_int8_t	cmd;
	char		_junk1;
	u_int8_t	rc;
	char		_junk3[4];
	u_int8_t	error_code;
	u_int16_t	asb_addr;
	u_int16_t	srb_addr;
	u_int16_t	arb_addr;
	u_int16_t	vers_ptr;
	u_int8_t	dtr;
};

/*
 * Close NIC SRB / SRB response
 */
struct trb_close_srb {
	u_int8_t	cmd;
	char		_junk1;
	u_int8_t	retcode;
};


/*
 * Read Log SRB / SRB response
 * Note that we ignore the response (use it to reset the counters)
 */
struct trb_readlog_srb {
	u_int8_t	cmd;
	char		_junk1[19];
};


/*
 * Set Receive Mode SRB / SRB response
 */
struct trb_rxmode_srb {
	u_int8_t	cmd;
	char		_junk1;
	u_int8_t	retcode;
	char		_junk3;
	u_int16_t	receive_options;
};

#define	TRBRXMODE_NORM		0x0000	/* Normal mode */
#define	TRBRXMODE_MACONLY	0x0002	/* Receive only MAC frames */
#define	TRBRXMODE_PROMALL	0x0004	/* Receive all MAC and LLC frames */
#define	TRBRXMODE_PROMLLC	0x0006	/* Receive all LLC frames */


/*
 * Ring.Status.Change ARB
 * This ARB has no interesting fields except the NEW_STATUS bitfield.
 */
struct trb_ringch_arb {
	u_int8_t	cmd;
	char		_junk1[5];
	u_int16_t	new_status;
};

#define	TRBARB_RINGCH		0x84	/* Ring Change ARB */

/* new_status bitfield (network order!) */
#define TRBRSC_SIGNAL_LOSS	0x8000
#define TRBRSC_HARD_ERROR	0x4000
#define TRBRSC_SOFT_ERROR	0x2000
#define TRBRSC_TRANSMIT_BEACON 	0x1000
#define TRBRSC_LOBE_WIRE_FAULT 	0x0800
#define TRBRSC_AUTO_REMOVAL	0x0400
#define TRBRSC_REMOVE_RECEIVED 	0x0100
#define TRBRSC_COUNTER_OVERFLOW	0x0080
#define TRBRSC_SINGLE_STATION  	0x0040
#define TRBRSC_RING_RECOVERY	0x0020


