/*
 * Copyright (c) 1999 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI if_w5ioctl.h,v 1.2 1999/07/28 22:05:34 cp Exp
 */

typedef struct w5_info {
	int	i_bid;
	int	i_ignoredcd;
	int	i_inited;
	int	i_tpackets;	/* number of packets in transmit ring */

	u_char	i_trc0;		/* tx ready control register 0 */
	u_char	i_trc1;		/* tx ready control register 1 */
	u_char	i_tnr0;		/* transmit dma request control reg 0 */
	u_char	i_tnr1;		/* transmit dma request control reg 1 */
	u_char	i_tcr;		 /* transmit dma critical request reg  */
	u_char	i_rrc;		 /* rx ready control register */
	u_char	i_rnr;		 /* receive dma request control register */
	u_char	i_rcr;		 /* receive dma critical request ctl reg */
	u_char	i_rtmc;		/* down counter */ 
	u_char	i_ttmc;		/* down counter */ 
	u_char	i_rxs;		/* receive clock source */
	u_char	i_txs;		/* transmit clock source */
	u_char	i_pim_addr;
	u_char	i_pim_data;
} w5_info_t;

#define W5_OFF(element) ((int)(&(((w5_info_t*)0)->element)))


#ifdef IFNAMSIZ		/* make inclusion into scan.l easier */
typedef struct w5_info_ioc {
	char		io_name[IFNAMSIZ];
	w5_info_t	io_info;
} w5_info_ioc_t;

typedef struct w5_pim_cmd {
	char		io_name[IFNAMSIZ];
	u_int		io_offset;
	u_char		io_data;
} w5_pim_cmd_t;

#define	W5IOCGIINFO	_IOWR('i', 196, struct w5_info_ioc)
#define	W5IOCSIINFO	_IOW('i', 197, struct w5_info_ioc)
#define W5IOCGPIMB	_IOWR('i', 198, struct w5_pim_cmd)
#define W5IOCSPIMB	_IOW('i', 199, struct w5_pim_cmd)
#endif
