/*
 * Copyright (c) 1999 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI if_w5reg.h,v 1.2 1999/07/28 22:05:34 cp Exp
 */

/*
 * Modem controls
 *
 * CTS
 *  232,422,v35 rx SCA2
 * RTS 
 *  232,422,v35 tx SCA2 
 * DCD
 *  232,433,v35 rx SCA2
 *  T1CSU pim called T1SigDCD	
 * DTR
 *  232,433,v35 tx pim
 * DSR
 *  232,433,v35 rx pim
 * 
 * 
 */

typedef struct w5_pim_V35 {
	u_char		pV35_bid;
	FILLER(0x1, 0x3);
	u_char		pV35_status;
	FILLER(0x5,0x7);
	u_char		pV35_control;
} w5_pim_V35_t;
#define CTLV35_DTR_BAR	0x04


typedef struct w5_pim_422 {
	u_char		p422_bid;
	FILLER(0x1, 0x3);
	u_char		p422_status;
	FILLER(0x5,0x7);
	u_char		p422_control;
} w5_pim_422_t;
#define CTL422_DTR_BAR	0x10

typedef struct w5_pim_csu {
	u_char		pcsu_bid;
	FILLER(0x01, 0x03);
	u_char		pcsu_csr;
	FILLER(0x05, 0x07);
	u_char		pcsu_spi;
	FILLER(0x09, 0x0b);
	u_char		pcsu_ctl;
	FILLER(0x0d, 0x0f);
	u_char		pcsu_cmd;
	FILLER(0x11, 0x13);
	u_char		pcsu_hdata0;
	FILLER(0x15, 0x17);
	u_char		pcsu_hdata1;
	FILLER(0x19, 0x1b);
	u_char		pcsu_hdata2;
	FILLER(0x1d, 0x1f);
	u_char		pcsu_cdata;
	FILLER(0x21, 0x23);
	u_char		pcsu_clear_status;
} w5_pim_csu_t;

#define	CSR_RESET		0x01
#define	CSR_TX_XTAL		0x02
#define	CSR_TX_IE		0x04
#define	CSR_TX_CLK_INVRT	0x08
#define	CSR_RX_CLK_INVRT	0x10
#define CSR_DATA_INVRT		0x20
#define CSR_LOOPBACK		0x40
#define CSR_56K			0x80

#define HCR_RCL			0x80
#define HCR_RLOS		0x40
#define HCR_SPI_BUSY		0x20
#define HCR_CSU_DATA_RDY	0x10
#define HCR_DATA_REG2_BSY	0x08
#define HCR_DATA_REG1_BSY	0x04
#define HCR_DATA_REG0_BSY	0x02
#define HCR_CMD_REG_BSY		0x01

#define CSU_WRITE		0x80
#define CSU_READ		0x00

#define CSU_TYPE_CODING	0x03
#define CSU_FDL		0x06
#define CSU_FRAMER_REGS	0x0f
#define CSU_LBO		0x0c


#define CSU_D4			0x01
#define CSU_B8ZS		0x02
#define CSU_PULSE_DENSITY	0x10	/* pulse density enforcement on */


#define CSU_RESPONSE_SIZE	255

#define CSU_RX_CHANNEL_BLK	0x32
#define CSU_TX_CHANNEL_BLK	0x6c
#define CSU_LDCR		0x7c

#define CSU_JITTER_DISABLE	0x02
#define CSU_JITTER_SHALLOW	0x04
#define CSU_JITTER_TRANSMIT	0x08
#define CSU_EGL			0x10
#define CSU_LDC_0DB		0x00
#define CSU_LDC_7DB		0xa0
#define CSU_LDC_15DB		0xc0
#define CSU_LDC_22DB		0xe0

#define CSU_CSU_RUN		0x01
#define CSU_GENERATE_T1CLK	0x08
#define CSU_CTW_INT		0x10
#define CSU_CTR_INT		0x20
#define CSU_SCA_INT		0x80

#define CSU_FDL_ANSI_GENERATE	0x01
#define CSU_FDL_ANSI_TX		0x02
#define CSU_FDL_ANSI_RX		0x04
#define CSU_FDL_ATT		0x08
#define CSU_FDL_IDLE_MARK	0x10

#define CSU_TX_IDLE_REG          0x3c	/* idle code regs are 3c, 3d, 3e */
#define CSU_IDLE_CODE_REG        0x3f	/* all ones */
#define CSU_IDLE_CODE            0xff	/* this register stores the idle code */


typedef struct w5_pim {
	union {
		u_char		_pim_bytes[0x400];
		w5_pim_422_t	_pim_422;
		w5_pim_V35_t	_pim_V35;
		w5_pim_csu_t	_pim_csu;
	}u;
} volatile w5_pim_t;

#define	pim_V35	u._pim_V35
#define	pim_422	u._pim_422
#define	pim_csu	u._pim_csu
#define pim_bytes u._pim_bytes

#define	pim_bid pim_V35.pV35_bid
#define	PIM_MID_M		0x1f	/* Module id mask */
#define PIM_MR_M		0x07	/* Module revision mask */
#define PIM_MR_S		5

#define PIM_MID_TB	0x0	/* test board */
#define PIM_MID_T1	0x1	/* T1/CSU/DSU */
#define PIM_MID_FIRST	PIM_MID_T1
#define PIM_MID_HSSI	0x2	/* HSSI */
#define PIM_MID_422	0x3	/* RS-422 */
#define PIM_MID_V35	0x4	/* V.35 */
#define PIM_MID_232	0x5	/* RS-232 */
#define PIM_MID_LAST	PIM_MID_232
#define PIM_MID_VACANT	0x1f	/* Card not present */

typedef struct wanic_500 {
	volatile u_short		w5_ctl_reg;
	FILLER(0x3,0x4);
	volatile u_short		w5_int_reg;
	FILLER(0x6,0x3ff);
	hd_64572_t	w5_hd;
	FILLER(0x600, 0x7ff);
	w5_pim_t	w5_pim[2];
} wanic_500_t;

#define	W5CTL_INT_ACT		0x0001	/* Card interrupt Active */
#define	W5CTL_PLX_USRO		0x0002	/* PLX User Output */
#define	W5CTL_PLX_USRI		0x0004	/* PLX User Input */
#define	W5CTL_DIRCT_MSTR	0x0008	/* Direct Master Mode */
#define	W5CTL_UNUSED_B4		0x0010
#define	W5CTL_UNUSED_B5		0x0020
#define	W5CTL_SCA_BSY0		0x0040	/* SCA Channel 0 Busy */
#define	W5CTL_SCA_BSY1		0x0080	/* SCA Channel 1 Busy */
#define	W5CTL_SCA_BSY2		0x0100	/* SCA Channel 2 Busy */
#define	W5CTL_SCA_BSY3		0x0200	/* SCA Channel 3 Busy */
#define	W5CTL_SCA_DABT		0x0400	/* SCA DMA Abort */
#define	W5CTL_UNUSED_B11	0x0800
#define	W5CTL_D1_RST		0x1000	/* Daughter card #1 Reset */
#define	W5CTL_D2_RST		0x2000	/* Daughter card #2 Reset */
#define	W5CTL_SCA_RST		0x4000	/* SCA Reset */
#define	W5CTL_MST_RST		0x8000	/* card Reset */

#define	W5INT_INT_ACT		0x0001	/* interrupt Active */
#define W5INT_UNUSED_B1		0x0002
#define W5INT_UNUSED_B2		0x0004
#define	W5INT_SCA_INT		0x0008	/* SCA interrupt Active */
#define	W5INT_SCA_FLT		0x0010	/* SCA Illegal Access bit Active */
#define	W5INT_PLX_INT		0x0020	/* PLX interrupt Active */
#define	W5INT_D1_INT		0x0040	/* Daughter card #1 interrupt Active */
#define	W5INT_D2_INT		0x0080	/* Daughter card #2 interrupt Active */
#define	W5INT_DABT_INT		0x0100	/* SCA DMA Abort interrupt Active */
#define W5INT_UNUSED_B9		0x0200
#define	W5INT_SCA_IEN0		0x0400	/* Enable SCA interrupt */
#define	W5INT_SCA_IEN1		0x0800	/* Enable SCA Illegal Access int */
#define	W5INT_PLX_IEN		0x1000	/* Enable PLX interrupt */
#define	W5INT_D1_IEN		0x2000	/* Enable Daughter card #1 interrupt */
#define	W5INT_D2_IEN		0x4000	/* Enable Daughter card #2 interrupt */
#define	W5INT_DABT_IEN		0x8000	/* Enable SCA DMA Abort interrupt */

#define W5_RAM_OFF		0x40000	/* Offset from board to ram */
#define W5_RAM_SIZE		0x40000 /* Total amount of ram 256k */
#define W5_CRAM_SIZE		(W5_RAM_SIZE / 2)

#define W5_XTAL	32000000
