/*
 * Copyright (c) 2000 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 * BSDI if_wxreg.h,v 1.3.8.2 2001/07/03 01:55:24 geertj Exp
 */

/*
 * Copyright (c) 1999, Traakan Software
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice unmodified, this list of conditions, and the following
 *    disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * FreeBSD: src/sys/pci/if_wxreg.h,v 1.3 2000/01/25 04:11:33 mjacob Exp 
 */

#define PCI_VENDORID_INTEL	0x8086
#define PCI_DEVICEID_82542	0x1000
#define PCI_DEVICEID_82543_F	0x1001
#define PCI_DEVICEID_82543_T	0x1004

/*
 * Device-specific PCI configuration space registers
 */
#define PCI_TRDY_TO		0x40		/* 542: PCI TRDY Timeout */
#define PCI_RETRY_TO		0x41		/* 542: PCI Retry Timeout */

/*
 * Information about this chipset gathered from a released Intel Linux driver,
 * which was clearly a port of an NT driver. 
 */

/*
 * PCI revisions.
 * Revision 2 is the 'first' generation (needs MWI workaround)
 * Revision 3 is A1 stepping, older chips are prototypes 
 * (workarounds for older versions not implemented)
 */
#define	WXREV2_GEN1		2
#define	WXREV3_A2		2

/*
 * Various Descriptor Structures.
 * These are all in little endian format (for now).
 */

typedef struct {
	u_int32_t		lowpart;
	u_int32_t		highpart;
} wxpa_t, wxrp_t;

/*
 * Receive Descriptor.
 * The base address of a receive descriptor ring must be on a 4KB boundary,
 * and they must be allocated in multiples of 8.
 */
typedef struct {
	wxpa_t			address;	/* phys addr of buffer */
	volatile u_int16_t	length;
	u_int16_t		_res0;
	volatile u_int8_t	status;
	volatile u_int8_t	errors;
	u_int16_t		_res1;
} wxrd_t;

#define	RDSTAT_DD		0x01		/* descriptor done */
#define RDSTAT_EOP		0x02		/* end of packet */
#define	RDSTAT_VP		0x08		/* 542: matched VET */
#define RDSTAT_PIF		0x80		/* passed in-exact filter */

#define	RDERR_CE		0x01		/* CRC Error */
#define	RDERR_SE		0x02		/* Symbol Error */
#define	RDERR_SEQ		0x04		/* Sequence Error */
#define	RDERR_CXE		0x10		/* Carrier Extension Error */
#define	RDERR_RXE		0x80		/* RX Data Error */
#define	RDERR_MASK	(RDERR_CE|RDERR_SE|RDERR_SEQ|RDERR_CXE|RDERR_RXE)

/*
 * Transmit Descriptor
 * The base address of a transmit descriptor ring must be on a 4KB boundary,
 * and they must be allocated in multiples of 8.
 */
typedef struct {
	wxpa_t			address;
	u_int16_t		length;
	u_int8_t		_res0;
	u_int8_t		cmd;		/* cmd */
	volatile u_int8_t	status;		/* status */
	u_int8_t		_res1;
	u_int16_t		_res2;
} wxtd_t;

#define	TXCMD_EOP		0x01		/* last packet */
#define	TXCMD_IFCS		0x02		/* insert FCS */
#define	TXCMD_RS		0x08		/* report status */
#define	TXCMD_RPS		0x10		/* report packet sent */
#define	TXCMD_IDE		0x80		/* interrupt delay enable */

#define	TXSTS_DD		0x1		/* descriptor done */
#define	TXSTS_EC		0x2		/* excess collisions */
#define	TXSTS_LC		0x4		/* late collision */
#define	TXSTS_TU		0x8		/* 543: TX underrun */

/*
 * This device can only be accessed via memory space.
 *
 * Register access via offsets.
 * Some registers have moved or only exist on certain family members,
 * and naming is changed to reflect this:
 *  WXREG_	exists on all silicon
 *  WXREG2_	exists on 82542 only
 *  WXREG3_	exists on 82543 only
 * Let's hope that future chips don't move registers around too much.
 */

#define	WXREG_CTRL		0x00000000
#define	WXREG_STATUS		0x00000008
#define	WXREG_EECD		0x00000010
#define	WXREG3_CTRLEXT		0x00000018	/* actually CTRL_EXT */
#define	WXREG_FCAL		0x00000028
#define	WXREG_FCAH		0x0000002c
#define	WXREG_FCT		0x00000030
#define	WXREG_VET		0x00000038
#define	WXREG2_RAL_BASE		0x00000040
#define	WXREG2_RAL_LO(x)	(WXREG2_RAL_BASE + ((x) << 3))
#define	WXREG2_RAL_HI(x)	(WXREG2_RAL_LO(x) + 4)
#define	WXREG_ICR		0x000000c0
#define	WXREG_ICS		0x000000c8
#define	WXREG_IMS		0x000000d0
#define	WXREG_IMC		0x000000d8
#define	WXREG_RCTL		0x00000100
#define	WXREG2_RDTR0		0x00000108
#define	WXREG2_RDBAL0		0x00000110
#define	WXREG2_RDBAH0		0x00000114
#define	WXREG2_RDLEN0		0x00000118
#define	WXREG2_RDH0		0x00000120
#define	WXREG2_RDT0		0x00000128
#define	WXREG2_RDTR1		0x00000130
#define	WXREG2_RDBAL1		0x00000138
#define	WXREG2_RDBAH1		0x0000013c
#define	WXREG2_RDLEN1		0x00000140
#define	WXREG2_RDH1		0x00000148
#define	WXREG2_RDT1		0x00000150
#define	WXREG2_FCRTH		0x00000160
#define	WXREG2_FCRTL		0x00000168
#define	WXREG_FCTTV		0x00000170
#define	WXREG_TXCW		0x00000178
#define	WXREG_RXCW		0x00000180
#define	WXREG2_MTA_BASE		0x00000200
#define	WXREG2_MTA(x)		(WXREG2_MTA_BASE + ((x) << 2))
#define	WXREG_TCTL		0x00000400
#define	WXREG2_TQSAL		0x00000408
#define	WXREG2_TQSAH		0x0000040c
#define	WXREG_TIPG		0x00000410
#define	WXREG2_TQC		0x00000418
#define	WXREG2_TDBAL		0x00000420
#define	WXREG2_TDBAH		0x00000424
#define	WXREG2_TDLEN		0x00000428
#define	WXREG2_TDH		0x00000430
#define	WXREG2_TDT		0x00000438
#define	WXREG2_TIDV		0x00000440
#define	WXREG3_TBT		0x00000448
#define	WXREG3_AIT		0x00000458
#define	WXREG2_VFTA		0x00000600
#define	WXREG3_FCRTL		0x00002160
#define	WXREG3_FCRTH		0x00002168
#define	WXREG3_RDBAL		0x00002800
#define	WXREG3_RDBAH		0x00002804
#define	WXREG3_RDLEN		0x00002808
#define	WXREG3_RDH		0x00002810
#define	WXREG3_RDT		0x00002818
#define	WXREG3_RDTR		0x00002820
#define	WXREG3_RXDCTL		0x00002828
#define	WXREG3_TXDMAC		0x00003000
#define	WXREG3_TDBAL		0x00003800
#define	WXREG3_TDBAH		0x00003804
#define	WXREG3_TDLEN		0x00003808
#define	WXREG3_TDH		0x00003810
#define	WXREG3_TDT		0x00003818
#define	WXREG3_TIDV		0x00003820
#define	WXREG3_TXDCTL		0x00003828
#define	WXREG_CRCERRS		0x00004000
#define	WXREG3_ALGNERRC		0x00004004
#define	WXREG_SYMERRS		0x00004008
#define	WXREG3_RXERRC		0x0000400c
#define	WXREG_MPC		0x00004010
#define	WXREG_SCC		0x00004014
#define	WXREG_ECOL		0x00004018
#define	WXREG_MCC		0x0000401c
#define	WXREG_LATECOL		0x00004020
#define	WXREG_COLC		0x00004028
#define	WXREG_DC		0x00004030
#define	WXREG3_TNCRS		0x00004034	/* don't use */
#define	WXREG_SEC		0x00004038
#define	WXREG3_CEXTERR		0x0000403c
#define	WXREG_RLEC		0x00004040
#define	WXREG_XONRXC		0x00004048
#define	WXREG_XONTXC		0x0000404c
#define	WXREG_XOFFRXC		0x00004050
#define	WXREG_XOFFTXC		0x00004054
#define	WXREG_FCRUC		0x00004058
#define	WXREG_PRC64		0x0000405c
#define	WXREG_PRC127		0x00004060
#define	WXREG_PRC255		0x00004064
#define	WXREG_PRC511		0x00004068
#define	WXREG_PRC1023		0x0000406c
#define	WXREG_PRC1522		0x00004070
#define	WXREG_GPRC		0x00004074
#define	WXREG_BPRC		0x00004078
#define	WXREG_MPRC		0x0000407c
#define	WXREG_GPTC		0x00004080
#define	WXREG_GORCL		0x00004088
#define	WXREG_GORCH		0x0000408c
#define	WXREG_GOTCL		0x00004090
#define	WXREG_GOTCH		0x00004094
#define	WXREG_RNBC		0x000040a0
#define	WXREG_RUC		0x000040a4
#define	WXREG_RFC		0x000040a8
#define	WXREG_ROC		0x000040ac
#define	WXREG_RJC		0x000040b0
#define	WXREG_TORL		0x000040c0
#define	WXREG_TORH		0x000040c4
#define	WXREG_TOTL		0x000040c8
#define	WXREG_TOTH		0x000040cc
#define	WXREG_TPR		0x000040d0
#define	WXREG_TPT		0x000040d4
#define	WXREG_PTC64		0x000040d8
#define	WXREG_PTC127		0x000040dc
#define	WXREG_PTC255		0x000040e0
#define	WXREG_PTC511		0x000040e4
#define	WXREG_PTC1023		0x000040e8
#define	WXREG_PTC1522		0x000040ec
#define	WXREG_MPTC		0x000040f0
#define	WXREG_BPTC		0x000040f4
#define	WXREG3_MTA_BASE		0x00005200
#define	WXREG3_MTA(x)		(WXREG3_MTA_BASE + ((x) << 2))
#define	WXREG3_RAL_BASE		0x00005400
#define	WXREG3_RAL_LO(x)	(WXREG3_RAL_BASE + ((x) << 3))
#define	WXREG3_RAL_HI(x)	(WXREG3_RAL_LO(x) + 4)
#define	WXREG3_VFTA		0x00005600

#define	WX_RAL_TAB_SIZE		16
#define	WX_RAL_AV		0x80000000

#define	WX_MC_TAB_SIZE		128
#define	WX_VLAN_TAB_SIZE	128

/*
 * Device Control Register Defines
 */
#define	WXCTRL_FD		0x00000001	/* full duplex */
#define	WXCTRL_BEM		0x00000002	/* big endian mode */
#define	WXCTRL_FAIR		0x00000004	/* 1->Fair, 0->Rx Prio */
#define	WXCTRL_LRST		0x00000008	/* Link Reset */
#define	WXCTRL_ASDE		0x00000020	/* 543: aut-speed det enable */
#define	WXCTRL_SLU		0x00000040	/* Set Link Up */
#define	WXCTRL_ILOS		0x00000080	/* Invert Loss-of-Signal */
#define	WXCTRL_SPEED_MASK	0x00000300	/* 543: speed bits mask */
#define	WXCTRL_SPEED_10		0x00000000	/* 543: 10 Mbit/sec */
#define	WXCTRL_SPEED_100	0x00000100	/* 543: 100 Mbit/sec */
#define	WXCTRL_SPEED_1000	0x00000200	/* 543: 1000 Mbit/sec */
#define	WXCTRL_FRCSPD		0x00000800	/* 543: Force Speed */
#define	WXCTRL_FRCDPLX		0x00001000	/* 543: Force Duplex */
#define	WXCTRL_RST		0x04000000	/* Reset (self clearing) */
#define	WXCTRL_RFCE		0x08000000	/* RX Flow Control Enable */
#define	WXCTRL_TFCE		0x10000000	/* TX Flow Control Enable */
#define	WXCTRL_RTE		0x20000000	/* Routing Tag Enable */
#define	WXCTRL_VME		0x40000000	/* VLAN Mode Enable */

#define	WXCTRL_SWDPINSLO_SHIFT	18
#define	WXCTRL_SWDPINSLO_MASK	0xf
#define	 WXCTRL_SWDPINLO0	(1 << 18)
#define	 WXCTRL_SWDPINLO1	(1 << 19)
#define	 WXCTRL_SWDPINLO2	(1 << 20)
#define	 WXCTRL_SWDPINLO3	(1 << 21)
#define	WXCTRL_SWDPIOLO_SHIFT	22
#define	WXCTRL_SWDPIOLO_MASK	0xf
#define	 WXCTRL_SWDPIOLO0	(1 << 22)
#define	 WXCTRL_SWDPIOLO1	(1 << 23)
#define	 WXCTRL_SWDPIOLO2	(1 << 24)
#define	 WXCTRL_SWDPIOLO3	(1 << 25)

/*
 * Device Extended Control Register Defines (543)
 */
#define	WXCTRLEXT_ASDCHK	0x00001000	/* 543: Initiate Speed Det */
#define	WXCTRLEXT_EERST		0x00002000	/* 543: EEPROM Reset */
#define	WXCTRLEXT_IPS		0x00004000	/* 543: Invert Power State */
#define	WXCTRLEXT_BYPS		0x00008000	/* 543: Speed Select Bypass */

#define	WXCTRLEXT_GPIEN_SHIFT	0
#define	WXCTRLEXT_GPIEN_MASK	0xf
#define	 WXCTRLEXT_GPIEN4	(1 << 0)
#define	 WXCTRLEXT_GPIEN5	(1 << 1)
#define	 WXCTRLEXT_GPIEN6	(1 << 2)
#define	 WXCTRLEXT_GPIEN7	(1 << 3)
#define	WXCTRLEXT_SWDPINSHI_SHIFT 4
#define	WXCTRLEXT_SWDPINHI_MASK	0xf
#define	 WXCTRLEXT_SWDPINHI4	(1 << 4)
#define	 WXCTRLEXT_SWDPINHI5	(1 << 5)
#define	 WXCTRLEXT_SWDPINHI6	(1 << 6)
#define	 WXCTRLEXT_SWDPINHI7	(1 << 8)
#define	WXCTRLEXT_SWDPIOHI_SHIFT 8
#define	WXCTRLEXT_SWDPIOHI_MASK	0xf
#define	 WXCTRLEXT_SWDPIOHI4	(1 << 9)
#define	 WXCTRLEXT_SWDPIOHI5	(1 << 10)
#define	 WXCTRLEXT_SWDPIOHI6	(1 << 11)
#define	 WXCTRLEXT_SWDPIOHI7	(1 << 12)

/*
 * Device Status Register Defines
 */
#define	WXSTATUS_FD		0x00000001	/* full duplex */
#define	WXSTATUS_LU		0x00000002	/* link up */
#define	WXSTATUS_TXCLK		0x00000004	/* TX clock running */
#define	WXSTATUS_RBCLK		0x00000008	/* RX clock running */
#define	WXSTATUS_TXOFF		0x00000010	/* TX paused */
#define	WXSTATUS_TBIMODE 	0x00000020	/* 543: 1=TBI,0=GMII */
#define	WXSTATUS_SPEED_MASK	0x000000c0	/* 543: speed bits mask */
#define	 WXSTATUS_SPEED_10	0x00000000	/* 543: 10 Mbit/sec */
#define	 WXSTATUS_SPEED_100	0x00000040	/* 543: 100 Mbit/sec */
#define	 WXSTATUS_SPEED_1000A	0x00000080	/* 543: 1000 Mbit/sec */
#define	 WXSTATUS_SPEED_1000B	0x000000c0	/* 543: 1000 Mbit/sec */
#define	WXSTATUS_ASDV_MASK	0x00000300	/* 543: speed detection value */
#define	WXSTATUS_MTXCKOK	0x00000400	/* 543: MTX clock running */
#define	WXSTATUS_PCI66		0x00000800	/* 543: PCI 66 MHz bus */
#define	WXSTATUS_BUS64		0x00001000	/* 543: PCI 64-bit bus */

/*
 * EEPROM Register Defines
 */
#define	WXEECD_SK		0x1		/* enable clock */
#define	WXEECD_CS		0x2		/* chip select */
#define	WXEECD_DI		0x4		/* data input */
#define	WXEECD_DO		0x8		/* data output */

#define	EEPROM_READ_OPCODE	0x6

/*
 * Bits pertinent for the Receive Address register pairs. The low address
 * is the low 32 bits of a 48 bit MAC address. The high address contains
 * bits 32-47 of the 48 bit MAC address. The top bit in the high address
 * is a 'valid' bit.
 */
#define	WXRAH_RDR1		0x40000000	/* 2nd rx descriptor ring */
#define	WXRAH_VALID		0x80000000

/*
 * Interrupt Cause Bits
 */
#define	WXISR_TXDW		0x00000001	/* TX descr written back */
#define	WXISR_TXQE		0x00000002	/* TX queue empty */
#define	WXISR_LSC		0x00000004	/* link status change */
#define	WXISR_RXSEQ		0x00000008	/* RX sequence error */
#define	WXISR_RXDMT0		0x00000010	/* RX ring 0 getting empty */
#define	WXISR_RXO		0x00000040	/* RX overrun */
#define	WXISR_RXT0		0x00000080	/* RX ring 0 timer interrupt */
#define	WXISR_PCIE		0x00000200	/* 542: PCI int error ???*/
#define	WXISR_RXCFG		0x00000400	/* 543: TX conf symbols */
#define	WXISR_GPI_4		0x00000800	/* 543: GPI bit 4 */
#define	WXISR_GPI_5		0x00001000	/* 543: GPI bit 5 */
#define	WXISR_GPI_6		0x00002000	/* 543: GPI bit 6 */
#define	WXISR_GPI_7		0x00004000	/* 543: GPI bit 7 */

#define	WXIENABLE_DEFAULT_542	\
	 (WXISR_RXO|WXISR_RXT0|WXISR_RXDMT0|WXISR_RXSEQ|WXISR_LSC|WXISR_PCIE)

#define	WXIENABLE_DEFAULT_543	\
	 (WXISR_RXO|WXISR_RXT0|WXISR_RXDMT0|WXISR_RXSEQ|WXISR_LSC)

#define	WXDISABLE		0xffffffff

/*
 * Receive Control Register bits.
 */
#define	WXRCTL_RST		0x00000001	/* receiver reset */
#define	WXRCTL_EN		0x00000002	/* receiver enable */
#define	WXRCTL_SBP		0x00000004	/* store bad packets */
#define	WXRCTL_UPE		0x00000008	/* unicast promiscuos mode */
#define	WXRCTL_MPE		0x00000010	/* multicast promiscuous mode */
#define	WXRCTL_LPE		0x00000020	/* large packet enable */
#define	WXRCTL_BAM		0x00008000	/* broadcast accept mode */
#define	WXRCTL_DPF		0x00400000	/* ignore pause frames */

#define	WXRCTL_2KRBUF		(0 << 16)	/* 2-Kbyte Receive Buffers */
#define	WXRCTL_1KRBUF		(1 << 16)	/* 1-Kbyte Receive Buffers */
#define	WXRCTL_512BRBUF		(2 << 16)	/* 512 Byte Receive Buffers */
#define	WXRCTL_256BRBUF		(3 << 16)	/* 256 Byte Receive Buffers */


/*
 * Receive Delay Timer Register bits.
 */
#define	WXRDTR_FPD		0x80000000	/* flush partial descriptor */

/*
 * Transmit Configuration Word defines
 */
#define	WXTXCW_FD		0x00000020	/* Full Duplex */
#define	WXTXCW_PMASK		0x00000180	/* pause mask */
#define	WXTXCW_ANE		0x80000000	/* AutoNegotiate */
#define	WXTXCW_DEFAULT		0x800001A0

/*
 * Transmit Control Register defines.
 */
#define	WXTCTL_RST		0x00000001	/* TX reset */
#define	WXTCTL_EN		0x00000002	/* TX enable */
#define	WXTCTL_PSP		0x00000008	/* pad short packets */
#define	WXTCTL_SWXOFF		0x00400000	/* Software XOFF */
#define	WXTCTL_PBE		0x00800000	/* 543: Packet Burst Enable */
#define	WXTCTL_RTLC		0x01000000	/* 543: Retr on Late Coll */
#define	WXTCTL_NRTU		0x02000000	/* 543: No Retr on Underrun */
#define	WXTCTL_CT(x)		(((x) & 0xff) << 4) /* 4:11 - Coll Thresh */
#define	WXTCTL_COLD(x)		(((x) & 0x3ff) << 12) /* 12:21 - Coll Dist */

#define	WX_COLLISION_THRESHOLD	16
#define	WX_FDX_COLLISION_DX	64
#define	WX_HDX_COLLISION_DX	64
#define	WX_GB_HDX_COLLISION_DX	512

/*
 * Miscellaneous
 */
#define	WX_EEPROM_MAC_OFF	0
#define	WX_EEPROM_PBA_OFF	8
#define	WX_EEPROM_SIZE		0x40
#define	WX_EEPROM_SUM		0xbaba

/*
 * Offset for Initialization Control Word #1
 */
#define	WX_EEPROM_CTLR1_OFF	0xa
#define	WX_EEPROM_CTLR1_FD	(1 << 10)
#define	WX_EEPROM_CTLR1_SWDPIO_SHIFT	5
#define	WX_EEPROM_CTLR1_ILOS	(1 << 4)

/*
 * Offset for Initialization Control Word #2
 */
#define	WX_EEPROM_CTLR2_OFF	0xf
#define	WX_EEPROM_CTLR2_SWDPIOEXT_SHIFT	4
#define	WX_EEPROM_CTLR2_ANE	0x0800

#define	WX_XTIMER_DFLT		0x0100
#define	WX_RCV_FLOW_HI_DFLT	0x8000
#define	WX_RCV_FLOW_LO_DFLT	0x4000
#define	WX_TXINT_DELAY_DFLT	128

#define	WX_TIPG_542		(10 | (2 << 10) | (10 << 20))
#define	WX_TIPG_543TBI		(6  | (8 << 10) | (6 << 20))
#define	WX_TIPG_543MII		(8  | (8 << 10) | (6 << 20))

#define	WX_CRC_LENGTH		4

/*
 * On goodhope boards, the SWD pins are used to MII management
 */
#define	WXCTRL_MDIO		WXCTRL_SWDPINLO2
#define	WXCTRL_MDIO_DIR		WXCTRL_SWDPIOLO2
#define	WXCTRL_MDC		WXCTRL_SWDPINLO3
#define	WXCTRLEXT_RESET4	WXCTRLEXT_SWDPINHI4

/*
 * On Intel boards, WXCTRL_SWDPINLO0 is connected to an (unlabelled) LED.
 */
#define	WXCTRL_LED		WXCTRL_SWDPINLO0

