/*-
 * Copyright (c) 1995, 1998 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI pci.h,v 2.16.6.1 2001/06/30 00:06:01 geertj Exp
 */

/*
 * PCI
 */

/* 
 * Definitions needed to talk to PCI configuration mechanism 1.
 */
#define	PCI_M1_CAR	0x0cf8	/* Configuration space address register */
#define	PCI_M1_CDR	0x0cfc	/* Configuration space data register */

#define	PCI_M1_CM	0x80000000
#define	PCI_M1_BUS_S	16
#define	PCI_M1_AGENT_S	11
#define	PCI_M1_FN_S	8
#define	PCI_M1_OFFSET_M 0xfc

/* 
 * Definitions needed to talk to PCI configuration mechanism 2.
 */
#define	PCI_M2_CSE	0x0cf8	/* Configuration space enable register */
#define	PCI_M2_FORW	0x0cfa	/* Forward register */

#define	PCI_M2_CM	0x80	/* configuration mode */
#define	PCI_M2_FN_S	1
#define	PCI_M2_FN_M	0xe0
#define	PCI_M2_CBP	0xc000	/* configuration base port */
#define	PCI_M2_AGENT_S	8

/* 
 * Offsets into standard part of a devices pci configuration address space.
 */
#define	PCI_VENDOR_ID	0x00
#define	PCI_DEVICE_ID	0x02
#define	PCI_COMMAND	0x04
#define	PCI_STATUS	0x06
#define	PCI_REVISION_ID	0x08
#define	PCI_CLASSCODE_L	0x09		/* low order byte of class code */
#define	PCI_CLASSCODE_H	0x0a		/* high 16 bits of class code */
#define PCI_CLS         0x0c
#define	PCI_LATENCY	0x0d
#define	PCI_HEADER 	0x0e
#define	PCI_BIST   	0x0f
#define	PCI_MEMORY_BA	0x14		/* XXX - use pci_getres() */
#define	PCI_PORT_BA	0x10		/* XXX - use pci_getres() */
#define	PCI_SUB_VENDOR	0x2c		/* Subsystem vendor ID */
#define	PCI_SUB_ID	0x2e		/* Subsystem ID */
#define	PCI_CAPPTR	0x34		/* Capabilities pointer */
#define	PCI_I_PIN	0x3d
#define	PCI_I_LINE	0x3c

#define	PCI_CB_CAPPTR	0x14		/* Capabilities pointer (CardBus) */

/*
 * Base register definitions
 */
#define	PCI_FIRST_BASE	0x10		/* First base register */
#define	PCI_NBASE	6		/* Number of base registers */
#define	PCI_IOSEL	0x01		/* I/O region indicator */
#define	PCI_32BIT	0x00		/* Anywhere in 32 bit addr space */
#define	PCI_UNDER1M	0x02		/* Locate below 1M line */
#define	PCI_64BIT	0x04		/* Anywhere in 64 bit addr space */
#define	PCI_PREFETCH	0x08		/* Region prefetchable */
#define	PCI_IOMASK	0x03		/* I/O region info */
#define	PCI_MEMMASK	0x0f		/* Memory region info */

/*
 * PCI_COMMAND register definitions
 */
#define PCI_CMD_IOR	0x0001	/* I/O address area enable */
#define PCI_CMD_MAR	0x0002	/* memory address area enable */
#define PCI_CMD_BM	0x0004	/* bus master enable */
#define PCI_CMD_SC	0x0008	/* Special cycles (1=include) */
#define PCI_CMD_MWI	0x0010	/* memory write access with invalidation */
#define PCI_CMD_VPS	0x0020	/* VGA pallette snoop (1=no reaction) */
#define PCI_CMD_PER	0x0040	/* Parity error response (1=perform) */
#define PCI_CMD_WC	0x0080	/* Wait cycle control (1=data/addr step poss)*/
#define PCI_CMD_SEE	0x0100	/* SERR enable (1=activate) */
#define PCI_CMD_BBE	0x0200	/* fast back-to-back cycles (1=enable) */

/*
 * PCI_STATUS register definitions
 */
#define PCI_STATUS_CAPLIST 0x0010 /* has capability list (1=supported) */
#define PCI_STATUS_66MHZ 0x0020	/* 66 MHz capable (1=supported) */
#define PCI_STATUS_FBB	0x0080	/* fast back-to-back cycles (1=supported) */
#define PCI_STATUS_DP	0x0100	/* data parity error */
#define PCI_STATUS_DEVTIM 0x0400 /* DEVSEL timing */
#define PCI_STATUS_STA	0x0800	/* target abort (1= target abort signalled) */
#define PCI_STATUS_TAB	0x1000	/* target abort (1= target abort received) */
#define PCI_STATUS_MAB	0x2000	/* master abort (1= master abort received) */
#define PCI_STATUS_SER	0x4000	/* system error (1=signalled) */
#define PCI_STATUS_PER	0x8000	/* parity error */

/* PCI_STATUS_DEVTIM definitions */
#define PCI_DEVSEL_SHIFT	9	/* shift for DEVSEL field */
#define PCI_DEVSEL_FAST		0	/* fast timing */
#define PCI_DEVSEL_MED		1	/* medium timing */
#define PCI_DEVSEL_SLOW		2	/* slow timing */
#define PCI_DEVSEL_RSRVD	3	/* reserved */

/*
 * PCI_HEADER register definitions
 */
#define	PCI_HDR_TYPE(x)	((x) & 0x7f)	/* Header type */
#define	PCI_HDR_MULTI	0x80		/* Multi-function device */

/* PCI header types */
#define	PCI_HT_NORM	0x00		/* regular device */
#define	PCI_HT_BRIDGE	0x01		/* PCI bridge */
#define	PCI_HT_CBBRIDGE	0x02		/* CardBus bridge */

/*
 * PCI_I_LINE definitions
 * Note that while the standard says that unassigned IRQ's should have
 * PCI_I_LINE == 0xff, some older BIOSes leave it to 0x0.
 * Fortunately, on i386, IRQ0 is always connected to the timer,
 * so we can safely work around this.
 */
#define	PCI_I_LINE_NONE	0xff		/* No interrupt available */
#define	PCI_I_LINE_VALID(i)  (((i) != PCI_I_LINE_NONE) && ((i) != 0x0))

/*
 * PCI_CAPPTR definitions
 */
#define	PCI_CAPPTR_MASK	0xfc		/* bottom bits are reserved */

/*
 * PCI capability ID's
 */
#define	PCI_CT_PM	0x01		/* Power management */
#define	PCI_CT_AGP	0x02		/* AGP */
#define	PCI_CT_VPD	0x03		/* Vital Product Data */
#define	PCI_CT_SLOT	0x04		/* Slot ID */
#define	PCI_CT_MSI	0x05		/* Message Signaled Interrupts */
#define	PCI_CT_HS	0x06		/* CompactPCI Hot Swap */
#define	PCI_CT_PCIX	0x07		/* PCI-X */

/*
 * PCI Capability format (common part)
 */
#define	PCI_CAP_ID	0x00		/* Capability ID */
#define	PCI_CAP_NEXT	0x01		/* Ptr to next */

/*
 * PCI PCI-X Capability Registers
 */
#define	PCI_PCIX_COMMAND 0x02		/* PCI-X Command */
#define	PCI_PCIX_STATUS 0x04		/* PCI-X Status */

/*
 * PCI-X command register (non-bridge)
 */
#define	PCIXCMD_DPERE	0x0001		/* Data Parity Error Recover Enable */
#define	PCIXCMD_ERO	0x0002		/* Enable Relaxed Ordering */
#define	PCIXCMD_MAXRD_512  0x0000	/* Max 512 Bytes Memory Read Count */
#define	PCIXCMD_MAXRD_1024 0x0004	/* Max 1024 Bytes Memory Read Count */
#define	PCIXCMD_MAXRD_2048 0x0008	/* Max 2048 Bytes Memory Read Count */
#define	PCIXCMD_MAXRD_4096 0x000c	/* Max 4096 Bytes Memory Read Count */
#define	PCIXCMD_MAXRDMASK  0x000c	/* Max Memory Read Count Mask*/
#define	PCIXCMD_MAXSPLIT_1   0x0000	/* Max 1 Split Transactions */
#define	PCIXCMD_MAXSPLIT_2   0x0010	/* Max 2 Split Transactions */
#define	PCIXCMD_MAXSPLIT_3   0x0020	/* Max 3 Split Transactions */
#define	PCIXCMD_MAXSPLIT_4   0x0030	/* Max 4 Split Transactions */
#define	PCIXCMD_MAXSPLIT_8   0x0040	/* Max 8 Split Transactions */
#define	PCIXCMD_MAXSPLIT_12  0x0050	/* Max 12 Split Transactions */
#define	PCIXCMD_MAXSPLIT_16  0x0060	/* Max 16 Split Transactions */
#define	PCIXCMD_MAXSPLIT_32  0x0070	/* Max 32 Split Transactions */
#define	PCIXCMD_MAXSPLITMASK 0x0070	/* Max Split Transactions Mask */

/*
 * Structure used to define a pci configuration address.
 * This structure is typically treated as opaque by the
 * various drivers though there is no real reason they
 * shouldn't look in it if need be.
 */
typedef struct pci_devaddr {
	u_char		d_bus;
	u_char		d_agent;
	u_char		d_function;
} pci_devaddr_t;

/*
 * Structure returned from pci_bscan(), describes shared memory and I/O
 * ports for a device.
 */
typedef struct pci_devres {
	int	nio;		/* Number of I/O regions */
	struct {
		int base;	/* IO base address */
		int len;	/* Number of I/O ports */
	} io[PCI_NBASE];
	int	nmem;		/* Number of memory regions */
	struct {
		u_long	base;	/* Base address in physical memory */
		int	len;	/* Length of region in bytes */
		caddr_t	addr;	/* Kernel virtual address */
	} mem[PCI_NBASE];
	int pci_irq;
} pci_devres_t;

#define	pci_maddr	mem[0].base
#define	pci_msize	mem[0].len
#define	pci_vaddr	mem[0].addr
#define	pci_ioaddr	io[0].base
#define	pci_iosize	io[0].len

/* 
 * Define size of various pieces of pci configuration address
 */
#define	PCI_M2_AGENTS	16		/* 16 mechanism 2 agents */
#define	PCI_M1_AGENTS	32		/* 32 mechanism 2 agents */
#define	PCI_FUNCTIONS	8
#define	PCI_BUSES	256

/*
 * Linked list of devices found on PCI so we only need to scan the PCI bus once.
 */
struct pci_dev {
	LIST_ENTRY(pci_dev)	pd_next;
	pci_devaddr_t		pd_pa;
	int			pd_flags;
};
#define	PCI_DEV_F_FOUND		0x0001	/* PCI device found by device driver */

extern int pci_log2_burstsize;
extern LIST_HEAD(pci_dev_head, pci_dev) pci_dev_head;

u_char	pci_inb __P((pci_devaddr_t *, u_char offset));
u_short	pci_inw __P((pci_devaddr_t *, u_char offset));
u_long	pci_inl __P((pci_devaddr_t *, u_char offset));
void	pci_outb __P((pci_devaddr_t *, u_char offset, u_char value));
void	pci_outw __P((pci_devaddr_t *, u_char offset, u_short value));
void	pci_outl __P((pci_devaddr_t *, u_char offset, u_long value));
pci_devaddr_t *pci_scan __P((int (*matcher)(pci_devaddr_t*)));
pci_devaddr_t *pci_find __P((int vendorid, int deviceid));
void	pci_getres __P((pci_devaddr_t *, pci_devres_t *, int,
    struct isa_attach_args *));
int	pci_findcap __P((pci_devaddr_t *pa, int cap));

