/*-
 * Copyright (c) 2000 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI pciwdc.h,v 2.4 2000/12/13 20:26:35 karels Exp
 */

/* derived from FreeBSD ata code, with cooperation of the author */

/*
 * Structure for passing ioaddresses etc for DMA
 */
typedef struct wddma {
	u_long  base;		/* ISA port base */
	u_long  abase;		/* alternate port base, for discontig. ports */
	u_long  bmbase;		/* busmaster registers */
	int     unit;		/* channel 0/1 on DMA controller */
	/* following should only be in a struct wddma_attach_args */
	int	found;		/* someone has attached */
	struct	wddma_ops *ops;	/* DMA entry points for DMA controller */
} pciwdc_address_t;	/* XXX not pciwdc specific */

#define LOC_PORT	0	/* locator for I/O port */

/* ATA transfer modes */
#define 	ATA_PIO			0x00
#define 	ATA_PIO0		0x08
#define		ATA_PIO1		0x09
#define		ATA_PIO2		0x0a
#define		ATA_PIO3		0x0b
#define		ATA_PIO4		0x0c
#define		ATA_DMA			0x10
#define		ATA_WDMA2		0x22
#define		ATA_UDMA2		0x42
#define		ATA_UDMA4		0x44
#define		ATA_UDMA5		0x45
#define		ATA_DMAMODE(x)		((x) & 0xf0)

/*
 * PCI class info for ATA.  Perhaps the following should be in pci.h,
 * but nothing else like this is there at the moment.
 */
#define	PCI_ATACLASSCODE_H		0x0101	/* ATA class (high 16 bits) */
#define	PCI_ATACLASSCODE_L_MASK		0x80	/* must be set */

/* "chip ID" constructed from vendor and device IDs */
#define	PCI_ID(vend, dev) (((dev) << 16) | (vend))

#define	_VENDOR_INTEL	0x8086
#define	Intel_PIIX	PCI_ID(_VENDOR_INTEL, 0x1230)	/* Intel PIIX */
#define	Intel_PIIX3	PCI_ID(_VENDOR_INTEL, 0x7010)	/* Intel PIIX3 */
#define	Intel_PIIX4	PCI_ID(_VENDOR_INTEL, 0x7111)	/* Intel PIIX4 */
#define	Intel_PIIX4e	PCI_ID(_VENDOR_INTEL, 0x7199)	/* " */
#define	Intel_ICH	PCI_ID(_VENDOR_INTEL, 0x2411)	/* Intel ICH */
#define	Intel_ICH0	PCI_ID(_VENDOR_INTEL, 0x2421)	/* Intel ICH0 */
#define	Intel_ICH2	PCI_ID(_VENDOR_INTEL, 0x244b)	/* Intel ICH2 */

#define	AcerLabs_Aladdin PCI_ID(0x10b9, 0x5229)
#define	_VENDOR_VIA	0x1106
#define	VIA_Apollo	PCI_ID(_VENDOR_VIA, 0x0571)	/* VIA Apollo */
#define	Cyrix_5530	PCI_ID(0x1078, 0x0102)	/* Cyrix 5530 */
#define	SiS_5591	PCI_ID(0x1039, 0x5513)	/* SiS 5591 */
#define	AMD_756		PCI_ID(0x1022, 0x7409)	/* AMD 756 */
#define	ROSB4		PCI_ID(0x1166, 0x0211)	/* ServerWorks ROSB4 */

#define	_VENDOR_Promise	0x105a
#define	Promise_33	PCI_ID(_VENDOR_Promise, 0x4d33)	/* Promise 33 */
#define	Promise_66	PCI_ID(_VENDOR_Promise, 0x4d38)	/* Promise 66 */
#define	Promise_100	PCI_ID(_VENDOR_Promise, 0x4d30)	/* Promise 100 */
#define	Promise_100OEM	PCI_ID(_VENDOR_Promise, 0x0d30)	/* Promise 100 */

#define	HighPoint	PCI_ID(0x1103, 0x0004)	/* HighPoint */

#define	RZ_100X		PCI_ID(0x1042, 0x1000)	/* RZ 100X */
#define	RZ_X		PCI_ID(0x1042, 0x1001)

#define	_VENDOR_CMD	0x1095
#define	CMD_640		PCI_ID(_VENDOR_CMD, 0x0640)	/* CMD 640 */
#define	CMD_646		PCI_ID(_VENDOR_CMD, 0x0646)	/* CMD 646 */
#define	CMD_648		PCI_ID(_VENDOR_CMD, 0x0648)	/* CMD 648 */
#define	CMD_649		PCI_ID(_VENDOR_CMD, 0x0649)	/* CMD 649 */


/* ATA/ATAPI device parameter information (byte order dependent!) */
struct ata_params {
#if BYTE_ORDER == LITTLE_ENDIAN
    u_int8_t    cmdsize         :2;             /* packet command size */
#define         ATAPI_PSIZE_12          0       /* 12 bytes */
#define         ATAPI_PSIZE_16          1       /* 16 bytes */

    u_int8_t                    :3;
    u_int8_t    drqtype         :2;             /* DRQ type */
#define         ATAPI_DRQT_MPROC        0       /* cpu    3 ms delay */
#define         ATAPI_DRQT_INTR         1       /* intr  10 ms delay */
#define         ATAPI_DRQT_ACCEL        2       /* accel 50 us delay */

    u_int8_t    removable       :1;             /* device is removable */
    u_int8_t    device_type     :5;             /* device type */
#define         ATAPI_TYPE_DIRECT       0       /* disk/floppy */
#define         ATAPI_TYPE_TAPE         1       /* streaming tape */
#define         ATAPI_TYPE_CDROM        5       /* CD-ROM device */
#define         ATAPI_TYPE_OPTICAL      7       /* optical disk */

    u_int8_t                    :1;
    u_int8_t    proto           :2;             /* command protocol */
#define         ATAPI_PROTO_ATAPI       2

    u_int16_t	cylinders;			/* number of cylinders */
    int16_t	reserved2;
    u_int16_t	heads;				/* # heads */
    int16_t	unfbytespertrk;			/* # unformatted bytes/track */
    int16_t	unfbytes;			/* # unformatted bytes/sector */
    u_int16_t	sectors;			/* # sectors/track */
    int16_t	vendorunique0[3];
    int8_t	serial[20];			/* serial number */
    int16_t	buffertype;			/* buffer type */
#define ATA_BT_SINGLEPORTSECTOR		1	/* 1 port, 1 sector buffer */
#define ATA_BT_DUALPORTMULTI		2	/* 2 port, mult sector buffer */
#define ATA_BT_DUALPORTMULTICACHE	3	/* above plus track cache */

    int16_t	buffersize;			/* buf size, 512-byte units */
    int16_t	necc;				/* ecc bytes appended */
    int8_t	revision[8];			/* firmware revision */
    int8_t	model[40];			/* model name */
    int8_t	nsecperint;			/* sectors per interrupt */
    int8_t	vendorunique1;
    int16_t	usedmovsd;			/* double word read/write? */

    u_int8_t	vendorcap;			/* vendor capabilities */
    u_int8_t	dmaflag		:1;		/* DMA supported - always 1 */
    u_int8_t	lbaflag		:1;		/* LBA supported - always 1 */
    u_int8_t	iordydis	:1;		/* IORDY may be disabled */
    u_int8_t	iordyflag	:1;		/* IORDY supported */
    u_int8_t	softreset	:1;		/* needs softreset when busy */
    u_int8_t	stdby_ovlap	:1;		/* standby/overlap supported */
    u_int8_t	queuing		:1;		/* supports queuing overlap */
    u_int8_t	idmaflag	:1;		/* interleaved DMA supported */
    int16_t	capvalidate;			/* validation for above */

    int8_t	vendorunique3;
    int8_t	opiomode;			/* PIO modes 0-2 */
    int8_t	vendorunique4;
    int8_t	odmamode;			/* old DMA modes, not ATA-3 */

    int16_t	atavalid;			/* fields valid */
#define		ATA_FLAG_54_58	      1		/* words 54-58 valid */
#define		ATA_FLAG_64_70	      2		/* words 64-70 valid */
#define		ATA_FLAG_88	      4		/* word 88 valid */

    int16_t	currcyls;
    int16_t	currheads;
    int16_t	currsectors;
    int16_t	currsize0;
    int16_t	currsize1;
    int8_t	currmultsect;
    int8_t	multsectvalid;
    int32_t	lbasize;

    int16_t	sdmamodes;			/* singleword DMA modes */ 
    int16_t	wdmamodes;			/* multiword DMA modes */ 
    int16_t	apiomodes;			/* advanced PIO modes */ 

    u_int16_t	mwdmamin;			/* min. M/W DMA time/word ns */
    u_int16_t	mwdmarec;			/* rec. M/W DMA time ns */
    u_int16_t	pioblind;			/* min. PIO cycle w/o flow */
    u_int16_t	pioiordy;			/* min. PIO cycle IORDY flow */

    int16_t	reserved69;
    int16_t	reserved70;
    u_int16_t	rlsovlap;			/* rel time (us) for overlap */
    u_int16_t	rlsservice;			/* rel time (us) for service */
    int16_t	reserved73;
    int16_t	reserved74;
    int16_t	queuelen;
    int16_t	reserved76;
    int16_t	reserved77;
    int16_t	reserved78;
    int16_t	reserved79;
    int16_t	versmajor;
    int16_t	versminor;
    int16_t	featsupp1;
    int16_t	featsupp2;
    int16_t	featsupp3;
    int16_t	featenab1;
    int16_t	featenab2;
    int16_t	featenab3;
    int16_t	udmamodes;			/* UltraDMA modes */
    int16_t	erasetime;
    int16_t	enherasetime;
    int16_t	apmlevel;
    int16_t	masterpasswdrev;
    u_int16_t	masterhwres	:8;
    u_int16_t	slavehwres	:5;
    u_int16_t	cblid		:1;
    u_int16_t	reserved93_1415	:2;
    int16_t	reserved94[32];
    int16_t	rmvstat;
    int16_t	securstat;
    int16_t	reserved129[30];
    int16_t	cfapwrmode;
    int16_t	reserved161[84];
    int16_t	integrity;
#endif
};

/* busmaster DMA related defines */
#define ATA_BM_OFFSET1			0x08
#define ATA_DMA_ENTRIES			256
#define ATA_DMA_EOT			0x80000000

#define ATA_BMCMD_PORT			0x00
#define ATA_BMCMD_START_STOP		0x01
#define ATA_BMCMD_WRITE_READ		0x08

#define ATA_BMSTAT_PORT			0x02
#define ATA_BMSTAT_ACTIVE		0x01
#define ATA_BMSTAT_ERROR		0x02
#define ATA_BMSTAT_INTERRUPT		0x04
#define ATA_BMSTAT_MASK			0x07
#define ATA_BMSTAT_DMA_MASTER		0x20
#define ATA_BMSTAT_DMA_SLAVE		0x40
#define ATA_BMSTAT_DMA_SIMPLEX		0x80

#define ATA_BMDTP_PORT			0x04

/* structure for holding DMA address data */
struct ata_dmaentry {
	u_int32_t base;
	u_int32_t count;
}; 

int pciwdc_intr(struct device *dev, int channel);
int pciwdc_dmainit(struct device *dev, int channel, int device, void *params);
char *pciwdc_mode2str(int mode);
int pciwdc_dmasetup(struct device *dev, int channel, int device, char *data, 
			long count, int flags, int moretocome, int ix);
void pciwdc_dmastart(struct device *dev, int channel);
int pciwdc_dmadone(struct device *dev, int channel);
int pciwdc_dmastatus(struct device *dev, int channel);
