/*	BSDI cs_cisutil.h,v 1.2 1996/07/25 22:09:21 prb Exp */
/* WILDBOAR $Wildboar: cs_cisutil.h,v 1.5 1996/02/13 13:02:08 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


struct tpcc {
	u_char	tpcc_last ;	/* Last index */
	u_char	tpcc_osbtpl ;	/* Offset of first i/f sub-tuple in buffer */
	u_char	tpcc_rmsk[16] ;	/* Configration register presence bits */
	u_long	tpcc_radr ;	/* Base address of the configration regs */
} ;

struct tpce_cv {
	u_long	tpce_cv_h ;	/* mili-volts / mili-amperes */
	u_long	tpce_cv_l ;	/* nano-volts / nano-amperes */
	u_char	tpce_cv_valid:1;
	u_char	tpce_cv_pwrdwn_may_nc:1;	/* not applied for current */
	u_char	tpce_cv_pwrdwn_zero_req:1;	/* not applied for current */
	u_char	tpce_cv_pwrdwn_hi_z_req:1;	/* not applied for current */
} ;

struct tp_spd {
	u_long	tpspd_h ;	/* mili-seconds */
	u_long	tpspd_l ;	/* nano-seconds */
	u_char	tpspd_valid ;	/* h/l format is valid */
	u_char	tpspd_x_valid ;	/* extended format is valid */
	u_char	tpspd_x_man:4;
	u_char	tpspd_x_exp:3;
} ;

struct ce {
	u_char	ce_index ;	/* Index of this configuration entry */
	u_char	ce_default ;	/* 1 if default bit is on */

	/* things from TPCE_IF */
	u_char	ce_if_type:4;
	u_char	ce_if_mwait:1;
	u_char	ce_if_rdybsy:1;
	u_char	ce_if_wp:1;
	u_char	ce_if_bvd:1;

	/* things from TPCE_PD */
	struct tpce_pd {
		struct tpce_cv ce_pd_nom_v ;
		struct tpce_cv ce_pd_min_v ;
		struct tpce_cv ce_pd_max_v ;
		struct tpce_cv ce_pd_static_c ;
		struct tpce_cv ce_pd_avg_c ;
		struct tpce_cv ce_pd_peak_c ;
		struct tpce_cv ce_pd_pdwn_c ;
	} ce_pd_vcc, ce_pd_vpp1, ce_pd_vpp2 ;

	/* things from TPCE_TD */
	struct tp_spd ce_td_maxwait ;
	struct tp_spd ce_td_maxbusy ;

	/* things from TPCE_IO */
	u_char	ce_io_bussize:2 ;	/* bus16/bus8 */
#		define TPCE_IO_BUS8	1
#		define TPCE_IO_BUS16	2
#		define TPCE_IO_BUSANY	3
	u_char	ce_io_addrline:5 ;
	char	ce_io_count ;
	struct tpce_io {
		int	tpce_io_base ;	/* -1 if invalid */
		int	tpce_io_len ;	/* -1 if invalid */
	} ce_io[16] ;

	/* things from TPCE_IR */
	u_char	ce_ir;			/* original tpl data byte */
	u_char	ce_ir_shared:1;
	u_char	ce_ir_pulse:1;
	u_char	ce_ir_level:1;
	u_char	ce_ir_mskfmt:1;
		/* getting tired of making unions... */
	u_char	ce_ir_vend:1;
	u_char	ce_ir_berr:1;
	u_char	ce_ir_iock:1;
	u_char	ce_ir_nmi:1;
	int	ce_ir_irqn;
	int	ce_ir_mask;

	/* things from TPCE_MS */
	char	ce_ms_type ;
	char	ce_ms_count ;
	struct tpce_ms {
		int	tpce_ms_wsize ;	/* 256 byte pages, -1 if invalid */
		int	tpce_ms_cbase ;	/* 256 byte pages, -1 if invalid */
		int	tpce_ms_hbase ;	/* 256 byte pages, -1 if invalid */
	} ce_ms[8] ;

	/* things from TPCE_MI */
	u_char	ce_mi_maxcard:4;
	u_char	ce_mi_audio:1;
	u_char	ce_mi_rdonly:1;
	u_char	ce_mi_pwrdwn:1;
} ;

struct tpce {
	struct ce ce ;
	struct ce defce ;
} ;
