/*	BSDI cs_cli.h,v 1.2 1996/07/25 22:09:22 prb Exp */
/* WILDBOAR $Wildboar: cs_cli.h,v 1.5 1996/02/13 13:02:09 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * RegisterClient
 */
typedef struct cs_rclient {
	u_short	Attributes ;
	u_short	EventMask ;
	int	(*CallBack)() ;
	void 	*CallBackArg ;
} cs_rclient_t ;

/* Attributes */
#define	CSCLI_MEM		0x0001
#define	CSCLI_MTD		0x0002
#define	CSCLI_IO		0x0004
#define	CSCLI_SHARED		0x0008
#define	CSCLI_EXCLUSIVE		0x0010

/* EventMasks */
#define	CSEM_WP			0x0001
#define	CSEM_CARD_LOCK		0x0002
#define	CSEM_EJECTION_REQ	0x0004
#define	CSEM_INSERTION_REQ	0x0008
#define	CSEM_BATTERY_DEAD	0x0010
#define	CSEM_BATTERY_LOW	0x0020
#define	CSEM_RDY_CHANGE		0x0040
#define	CSEM_CD_CHANGE		0x0080
#define	CSEM_PM			0x0100
#define	CSEM_RESET		0x0200
#define	CSEM_SS_UPDATE		0x0400

typedef struct cs_gcli {
	u_short	Socket ;
	u_short	Attributes ;
} cs_gcli_t ;

/* Bits in 'Attributes'. Only bit 0 is defined. */

#define CSGCLI_SOCKET	1	/* Get client for this socket only */
#define	CSGCLI_ALL	0	/* Get all clients */

int cs_RegisterClient __P((CliHandle_t *, cs_rclient_t *));
int cs_DeregisterClient __P((CliHandle_t *));
int cs_GetFirstClient __P((CliHandle_t *, cs_gcli_t *));
int cs_GetNextClient __P((CliHandle_t *, cs_gcli_t *));
