/*	BSDI cs_conf.h,v 1.2 1996/07/25 22:09:23 prb Exp */
/* WILDBOAR $Wildboar: cs_conf.h,v 1.5 1996/02/13 13:02:11 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


/*
 * For cs_RequestConfiguration() and cs_GetConfigurationInfo().
 * cs_RequestConfiguration() only uses fields up to cscfg_Present.
 *
 */
#ifndef _CS_CONF_H_
#define _CS_CONF_H_

#include <i386/pcmcia/cs_iop.h>
#include <i386/pcmcia/cs_handle.h>
#include <i386/pcmcia/pccs_cif.h>

typedef struct cs_cfg {
	u_short	cscfg_Socket ;		/* Logical socket number */
	u_short	cscfg_Attributes ;	/* Attributes, Bit 1: Enable IRQ */
	u_char	cscfg_Vcc ;		/* VCC spec in 1/10 volts */
	u_char	cscfg_Vpp1 ;		/* VPP1 spec in 1/10 volts */
	u_char	cscfg_Vpp2 ;		/* VPP2 spec in 1/10 volts */
	u_char	cscfg_IntType ;		/* Bit 0: Mem ,bit 1: Mem and I/O */
	u_long	cscfg_ConfigBase ;
	u_char	cscfg_Status ;
	u_char	cscfg_Pin ;
	u_char	cscfg_Copy ;
	u_char	cscfg_ConfigIndex ;
	u_char	cscfg_Present ;		/* See CREGMAP_XXX */
	/*
	 * Fields only used by GetConfigurationInfo()
	 */
	char	cscfg_FirstDevType ;
	char	cscfg_FuncCode ;
	char	cscfg_SysInitMask ;
	short	cscfg_ManufCode ;
	short	cscfg_ManufInfo ;
	char	cscfg_CardValues ;
	char	cscfg_AssignedIRQ ;
	short	cscfg_IRQAttributes ;
	struct cs_ioport cscfg_IOPort[2] ;
#define	cscfg_BasePort1	cscfg_IOPort[0].csio_BasePort
#define	cscfg_NumPorts1	cscfg_IOPort[0].csio_NumPorts
#define	cscfg_PortAttr1	cscfg_IOPort[0].csio_PortAttr
#define	cscfg_BasePort2	cscfg_IOPort[1].csio_BasePort
#define	cscfg_NumPorts2	cscfg_IOPort[1].csio_NumPorts
#define	cscfg_PortAttr2	cscfg_IOPort[1].csio_PortAttr
	char	cscfg_IOAddrLines ;
	u_char	cscfg_V1_str[256] ;	/* too much? */
	u_short	cscfg_V1_len ;
	char	cscfg_devname[16];
} cs_cfg_t ;

/*
 * Bits in Attributes
 */
/* To use with RequestConfiguration() */
#define	CSCFG_ENABLE_IRQ	(1 << 1)

/* Bits additionally defined by GetConfigurationInfo */
#define	CSCFG_EXCLUSIVE		(1 << 0)
#define	CSCFG_VALID_CLIENT	(1 << 8)

/* Bits in Present */
#define	CSCFG_OPTION		CREGMAP_COR
#define	CSCFG_STATUS		CREGMAP_CCSR
#define	CSCFG_PIN		CREGMAP_PRR
#define	CSCFG_COPY		CREGMAP_SCR

/* Bits in IntType */
#define	CSCFG_MEMORY		(1 << 0)
#define	CSCFG_IO		(1 << 1)

int cs_RequestConfiguration __P((CliHandle_t *hClient, cs_cfg_t *pCfgreq));
int cs_GetConfigurationInfo __P((CliHandle_t *hCli, CliHandle_t *hCfg, cs_cfg_t *pCfg));
int cs_ModifyConfiguration ();
int cs_ReleaseConfiguration __P((CliHandle_t *hClient, cs_cfg_t *pCfgreq));

#endif
