/*	BSDI cs_intern.h,v 1.2 1996/07/25 22:09:27 prb Exp */
/* WILDBOAR $Wildboar: cs_intern.h,v 1.6 1996/03/17 08:07:09 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef _CS_INTERN_H_
#define _CS_INTERN_H_

#include <i386/pcmcia/cs_conf.h>
#include <i386/pcmcia/ss_types.h>
#include <i386/pcmcia/ss_debug.h>

/*
 * Per adapter structure.
 */
typedef struct cs_adp {
	ss_adpinfo_t	csa_info ;
#define	csa_nsock	csa_info.NumSockets
#define	csa_nwin	csa_info.NumWindows
#define	csa_nedc	csa_info.NumEDCs
	int		csa_sock ;	/* Base CS Socket # */
	struct cs_win	*csa_win ;

    /* Private memory module. */

	/*
	 * This is a piece of private memory allocated for this adapter.
	 */
	caddr_t		csa_pmaddr ;
	int		csa_pmsize ;

	/*
	 * This is the socket using the memory above.
	 */
	int		csa_pmsock ;	/* Socket using the privmem */

	/*
	 * And this is the current mapping.
	 */
	int		csa_pmattr ;	/* Mapped space */
	int		csa_pmoff ;	/* Mapped offset */
} cs_adp_t ;

/*
 * Per (CS logical) socket data structure.
 */
typedef struct cs_sock {
	int		css_adp ;	/* SS Physical adapter # */
	int		css_sock ;	/* SS Physical socket # */
	ss_sockinfo_t	css_info ;	/* ss_InquireSocket() */
	ss_sgsocket_t	css_sgsock ;	/* ss_[Get|Set]Socket */
	ss_status_t	css_status ;	/* ss_GetStatus */

	/*
	 * State machine
	 */
	int		css_state ;

#define	CSS_ST_IDLE	1	/* Socket is empty and idle */
#define	CSS_ST_INSWAIT	2	/* CD is detected. Bounce timer active */
#define	CSS_ST_RSTWAIT	3	/* Wait after reset in progress */
#define	CSS_ST_RDYWAIT	4	/* Wait for RDY in progress */
#define	CSS_ST_CSINT	5	/* CS internal processing in progress */
#define	CSS_ST_UP	6	/* Socket is up, client processing in progress*/
#define	CSS_ST_DOWN	7	/* Socket is forced down */

#define	CSS_EV_INS	1
#define	CSS_EV_DEL	2
#define	CSS_EV_TIMO	3

	int		css_wcount ;	/* To limit time to wait for RDY */

	/*
	 * Configuration related.
	 */
	int		css_cfgstate ;

	/* bits in css_cfgstate */
#define	SCS_IO		1	/* I/O is allocated */
#define	SCS_IRQ		2	/* IRQ is allocated */
#define SCS_CFG		4	/* socket is configured */

	cs_cfg_t	css_cfg ;	/* Configuration Info */
	struct cs_client *css_cfgcli ;	/* Client configured this sock/card */

	int		css_wincount ;	/* # of windows assigned to this sock */
	int		css_sockmask ;

	/*
	 * This is the memory window allocated for CS internal use
	 * (CIS and configuration register access).
	 */
	struct cs_win	*css_pmwin ;
	int		css_pmwinno ;	/* Same info, window # */
	struct timeval	css_lastattach ; /* Last attach time */
} cs_sock_t ;

/*
 * Per window data structure.
 */
typedef struct cs_win {
	ss_wininfo_t	csw_info ;	/* From ss_InquireWindow() */
	int		csw_adp ;	/* Back link to cs_adp[] */
	int		csw_sock ; 	/* CS Sock this window is assigned to */
					/*    -1 if none */
	vm_offset_t	csw_base ;
	u_long		csw_size ;
	ss_sgwindow_t	csw_sgwin ;
	int		csw_rattr ;	/* Attributes field of RequestWindow()*/
	ss_sgpage_t	csw_sgpage ;
	int		csw_priv ;	/* Reserved for CS internal use */

	struct cs_win	*csw_next ;	/* Allocation chain */
} cs_win_t ;

typedef struct cs_client {
	struct cs_client *csc_next ;	/* Next client in chain */
	int		csc_attr ;
	int		csc_evmask ;
	int		(*csc_fun)() ;
	void		*csc_arg ;
	cs_win_t	*csc_win ;	/* List of windows */
} cs_client_t ;

cs_client_t *cs_validate_client __P((CliHandle_t *hClient)) ;

#endif
