/*	BSDI cs_ioctl.h,v 1.2 1996/07/25 22:09:29 prb Exp */
/* WILDBOAR $Wildboar: cs_ioctl.h,v 1.6 1996/03/17 08:07:10 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef _CS_IOCTL_H_
#define _CS_IOCTL_H_

#include <i386/pcmcia/cs_spec.h>

typedef struct csparam {
	int	slot ;		/* slot number */
	int	cmd ;		/* CSC_XXX */
	int	result ;	/* CSR_XXX */
	void	*data ;
} csparam_t;

#define	CIS_MAXSIZE		2048

#define	CSC_SET_SLOT_FLAGS	0	/* data (int *) */
#define	CSC_GET_SLOT_FLAGS	1	/* result */
#define	CSC_GET_CIS		2	/* data (char * == [CIS_MAXSIZE]) */
#define	CSC_GET_CLIENT_INFO	3	/* data (cs_cfg_t *) */
#define	CSC_GET_LAST_ATTACH	4	/* data (struct timeval) */

#define	CSF_SLOT_UP		0x1
#define	CSF_SLOT_RUNNING	0x2
#define	CSF_SLOT_EMPTY		0x4

#define	CSIOCGMAXSLOT	_IOR('C', 1, int)
#define	CSIOCREQ	_IOWR('C', 2, csparam_t)
#define	CSIOCADDSPEC	_IOW('C', 3, csspec_t)
#define	CSIOCDELSPEC	_IOW('C', 4, csspec_t)
#define	CSIOCRESETSPEC	_IO('C', 5)
#define	CSIOCLISTSPEC	_IOWR('C', 6, csspecconf_t)

#endif
