/*	BSDI cs_irq.h,v 1.3 1997/08/14 20:03:26 prb Exp */
/* WILDBOAR $Wildboar: cs_irq.h,v 1.5 1996/02/13 13:02:19 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

typedef struct cs_rirq {
	u_short	Socket ;
	u_short	Attributes ;
	u_char	AssignedIRQ ;
	u_char	IRQInfo1 ;	/* first byte of the TPCE_IR */
	u_short	IRQInfo2 ;	/* IRQ level mask (if necessary) */
} cs_rirq_t ;

/*
 * Bits in Attributes field
 */
#define	CSRIRQ_TYPE_MASK		3
#define		CSRIRQ_TYPE_EXCLUSIVE		0
#define		CSRIRQ_TYPE_TSS			1
#define		CSRIRQ_TYPE_DYNA_SHARE		2

#define	CSRIRQ_FORCE_PULSE		4
#define	CSRIRQ_FIRST_SHARED		8
#define	CSRIRQ_PULSE_ALLOCATED		0x100

/*
 * Bits in IRQInfo1
 */
#define	CSIRQ_SHARED	CISTPL_IR_SHARED
#define	CSIRQ_PULSE	CISTPL_IR_PULSE
#define	CSIRQ_LEVEL	CISTPL_IR_LEVEL
#define	CSIRQ_MASKS	CISTPL_IR_MASKS
#define	CSIRQ_IRQN_MASK	CISTPL_IR_IRQN_MASK
#define	CSIRQ_VEND	CISTPL_IR_VEND
#define	CSIRQ_BERR	CISTPL_IR_BERR
#define	CSIRQ_IOCK	CISTPL_IR_IOCK
#define	CSIRQ_NMI	CISTPL_IR_NMI

/*
 * Prototypes
 */
int cs_RequestIRQ __P((CliHandle_t *hClient, cs_rirq_t *pIRQreq));
int cs_ReleaseIRQ __P((CliHandle_t *hClient, cs_rirq_t *pIRQreq));
