/*	BSDI cs_memory.h,v 1.3 1996/09/10 14:25:00 pjd Exp */
/* WILDBOAR $Wildboar: cs_memory.h,v 1.5 1996/02/13 13:02:21 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _CS_MEMORY_H_
#define _CS_MEMORY_H_
/*
 * CS_PGSZ should be integer multiple of IOM_PGSZ and integer multiple
 * of SS_ADDR_UNIT.
 */

#if SS_ADDRSHIFT > IOM_PGSHIFT
#  define CS_PGSHIFT		SS_ADDRSHIFT
#else
#  define CS_PGSHIFT		IOM_PGSHIFT
#endif

#define	CS_PGSZ			(1 << CS_PGSHIFT)
#define	CS_PGMASK		(CS_PGSZ - 1)
#define	CS_PG_ROUNDUP(n)	((((n) + (CS_PGSZ-1))/CS_PGSZ)*CS_PGSZ)
#define	CSPGTOB(n)		((n) << CS_PGSHIFT)
#define	BTOCSPG(n)		((n) >> CS_PGSHIFT)

#if (CS_PGSZ/IOM_PGSZ)*IOM_PGSZ != CS_PGSZ
	Error CS_PGSHIFT Inconsistency_between_CS_PGSZ_and_IOM_PGSZ_detected
#endif

#if (CS_PGSZ/4096)*4096 != CS_PGSZ
	Error CS_PGSZ_must_be_integer_multiple_of_4096
#endif

int cs_kvmtop __P((caddr_t va)) ;
caddr_t cs_ptokvm __P((int pa)) ;
void cs_mfree __P((int base, int size)) ;
int cs_malloc __P((int base, int size)) ;
int cs_bmalloc __P((int base, int size)) ;

#endif
