/*	BSDI cs_memrw.h,v 1.2 1996/07/25 22:09:32 prb Exp */
/* WILDBOAR $Wildboar: cs_memrw.h,v 1.5 1996/02/13 13:02:22 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _CS_MEMRW_H_
#define _CS_MEMRW_H_

typedef struct cs_rmem {
	u_short	Socket ;
	u_short	Attributes ;
	u_long	Offset ;
} cs_rmem_t ;

/* Bits in Attributes */

#define	CSMEMRW_ATTRIBUTE	0x0001
#define	CSMEMRW_EXCLUSIVE	0x0002

typedef struct cs_rmemrw {
	u_long	CardOffset ;
	u_long	Count ;
} cs_rmemrw_t ;

int cs_OpenMemory(CliHandle_t *hCli, MemHandle_t *hMem, cs_rmem_t *rmem) ;
int cs_CloseMemory(CliHandle_t *hCli, MemHandle_t *hMem) ;
int cs_ReadMemory(CliHandle_t *hCli, MemHandle_t *hMem, u_char *buf, cs_rmemrw_t *rmemrw) ;
int cs_WriteMemory(CliHandle_t *hCli, MemHandle_t *hMem, u_char *buf, cs_rmemrw_t *rmemrw) ;

#endif
