/*	BSDI cs_spec.h,v 1.2 1996/07/25 22:09:35 prb Exp */
/* WILDBOAR $Wildboar: cs_spec.h,v 1.2 1996/03/17 11:02:52 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef _CS_SPEC_H_
#define _CS_SPEC_H_

#define	CSS_DNAMELEN		16
#define	CSS_MAXPARM		5

typedef struct csspec {
	struct csspec *	css_next;
	char		css_dname[CSS_DNAMELEN];	/* driver name */
	char	      *	css_str;			/* VERS_1 string */
	short		css_len;			/* length of css_str */
	short		css_flags;			/* CSSF_XXX */
	int		css_parm[CSS_MAXPARM];		/* parameters */
} csspec_t;

#define	CSSF_ALLOC		0x01			/* allocated entry */

typedef struct csspecconf {
	int		cssc_buflen;			/* bytes of cssc_buf */
	csspec_t *	cssc_buf;			/* list of csspec */
} csspecconf_t;

#ifdef KERNEL
void cs_spec_init __P((void));
int cs_spec_lookup __P((int socket, char *dname, int *parmp, int parmlen));
void cs_notify_event __P((void));

extern csspec_t csspec_default[];
#endif

#endif
