/*	BSDI cs_tplsvc.h,v 1.2 1996/07/25 22:09:37 prb Exp */
/* WILDBOAR $Wildboar: cs_tplsvc.h,v 1.5 1996/02/13 13:02:27 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


/*
 * For cs_GetFirstTuple(), cs_GetNextTuple() and cs_GetTupleData().
 *
 * Also used for utility functions cs_OpenTuple().
 *
 * Implementation Note:
 *
 * TupleCode/TupleLink and TupleDataMax/TupleDataLen/TupleData fields
 * are union-like structure in the CS specification. They are expanded
 * here so that sequence like GetFirstTuple(), GetTupleData(),
 * GetNextTuple(), GetTupleData() can be written without exchanging
 * these fields.
 */
#ifndef _CS_TPLSVC_H_
#define _CS_TPLSVC_H_

typedef struct cs_rtpl {
	u_short	Socket ;	/* Logical socket number */
	u_short	Attributes ;	/* Attribute bitmap */
	u_char	Desired ;	/* Tuple id of the desired tuple */
	u_char	TupleOffset ;	/* MBZ for Get{First,Next}Tuple() */
	u_long	Flags ;
	u_long	LinkOffset ;
	u_long	CISOffset ;
	u_char	TupleCode ;	/* Tuple id of the found tuple */
	u_char	TupleLink ;	/* Link value of the found tuple */
	u_short	TupleDataMax ;
	u_short	TupleDataLen ;
	u_char	*TupleData ;
} cs_rtpl_t ;

/* short hand for determining what actually read */
#define	TupleLen(t)	min((t).TupleDataLen, (t).TupleDataMax)

/* Bit functions of Attr */

#define	CSTPLREQ_RETURN_LINK	1	/* Returns long link info also */

int cs_GetFirstTuple __P((cs_rtpl_t *));
int cs_GetNextTuple __P((cs_rtpl_t *));
int cs_GetTupleData __P((cs_rtpl_t *));
int cs_OpenTuple __P((cs_rtpl_t *));
int cs_GetTuple __P((cs_rtpl_t *));

#endif
