/*	BSDI cs_win.h,v 1.2 1996/07/25 22:09:39 prb Exp */
/* WILDBOAR $Wildboar: cs_win.h,v 1.5 1996/02/13 13:02:30 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _CS_WIN_H_
#define _CS_WIN_H_

typedef struct cs_rwin {
	u_short	Socket ;
	u_short	Attributes ;
	u_long	Base ;		/* PHYSICAL address in bytes */
	u_long	Size ;		/* In bytes */
	u_char	AccessSpeed ;
} cs_rwin_t ;

#define	CSRWIN_MEM_TYPE_ATTR		(1 << 1)
#define	CSRWIN_ENABLE			(1 << 2)
#define	CSRWIN_DATA_PATH_16		(1 << 3)
#define	CSRWIN_PAGED			(1 << 4)
#define	CSRWIN_SHARED			(1 << 5)
#define	CSRWIN_FIRST_SHARED		(1 << 6)
#define	CSRWIN_BINDING_SPECIFIC		(1 << 7)
#define	CSRWIN_CARDOFF_IS_WINSIZE	(1 << 8)

typedef struct cs_rpage {
	u_long	CardOffset ;
	u_char	Page ;
} cs_rpage_t ;


int cs_RequestWindow __P((CliHandle_t *hClient, WinHandle_t *hWindow, cs_rwin_t *prwin));
int cs_ReleaseWindow __P((CliHandle_t *hClient, WinHandle_t *hWindow));
int cs_ModifyWindow __P((CliHandle_t *hClient, WinHandle_t *hWindow));
int cs_MapMemPage __P((CliHandle_t *hClient, WinHandle_t *hWindow, cs_rpage_t *prpage));

#endif
