/*	BSDI pccs_cif.h,v 1.2 1996/07/25 22:09:40 prb Exp */
/* WILDBOAR $Wildboar: pccs_cif.h,v 1.5 1996/02/13 13:02:30 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * PC Card Specification: Card Interface
 */
#ifndef _PCCS_CIF_H_
#define _PCCS_CIF_H_

/*
 * Base definition
 */
#define	_CREG_COR	0	/* Configuration Option Register */
#define	_CREG_CCSR	1	/* Card Configuration and Status Reg */
#define	_CREG_PRR	2	/* Pin Replacement Register */
#define	_CREG_SCR	3	/* Socket and Copy Register */

/*
 * Configuration register presence bitmaps
 */
#define	CREGMAP_COR	(1 << _CREG_COR)
#define	CREGMAP_CCSR	(1 << _CREG_CCSR)
#define	CREGMAP_PRR	(1 << _CREG_PRR)
#define	CREGMAP_SCR	(1 << _CREG_SCR)

/*
 * Configuration register offsets
 */
#define	CREGOFF_COR	(_CREG_COR << 1)
#define	CREGOFF_CCSR	(_CREG_CCSR << 1)
#define	CREGOFF_PRR	(_CREG_PRR << 1)
#define	CREGOFF_SCR	(_CREG_SCR << 1)

/*
 * COR bit/bit-field assignments
 */
#define	COR_SRESET	0x80
#define	COR_LEVIRQ	0x40
#define	COR_CFGMSK	0x3f

/*
 * CCSR bit assignments
 */
#define	CCSR_CHANGED	0x80
#define	CCSR_SIGCHG	0x40
#define	CCSR_IOIS8	0x20
#define	CCSR_RSVD1	0x10
#define	CCSR_AUDIO	0x08
#define	CCSR_PWRDWN	0x04
#define	CCSR_INTR	0x02
#define	CCSR_RSVD0	0x01

/*
 * PRR bit assignments
 */
#define	PRR_CBVD1	0x80
#define	PRR_CBVD2	0x40
#define	PRR_CRDYBSY	0x20
#define	PRR_CWPROT	0x10
#define	PRR_RBVD1	0x08
#define	PRR_RBVD2	0x04
#define	PRR_RRDYBSY	0x02
#define	PRR_RWPROT	0x01

#endif
