/*	BSDI pccs_meta.h,v 1.2 1996/07/25 22:09:41 prb Exp */
/* WILDBOAR $Wildboar: pccs_meta.h,v 1.5 1996/02/13 13:02:31 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


/*
 * PC Card Specification: Card Metaformat
 */

#if 0
#define BFLEN(f)	f/**/_bflen
#define BFPOS(f)	f/**/_bfpos
#define BITF(n,f)	(((n) >> BFPOS(f)) & ((1 << BFLEN(f)) - 1))
#else
#define BITF(n,p,l)	(((n) >> (p)) & ((1 << (l)) - 1))
#endif

#define	CISTPL_NULL		0x00	/* Null tuple */
#define	CISTPL_DEVICE		0x01

#define	CISTPL_CHECKSUM		0x10	/* Checksum */
#define	CISTPL_LONGLINK_A	0x11	/* Long link to attr mem space */
#define	CISTPL_LONGLINK_C	0x12	/* Long link to common mem space */
#define	CISTPL_LINKTARGET	0x13	/* Link target */
#define	CISTPL_NO_LINK		0x14	/* No more link */
#define	CISTPL_VERS_1		0x15	/* Version 1 */
#define	CISTPL_ALTSTR		0x16
#define	CISTPL_DEVICE_A		0x17	/* Device identifier for attr mem */
#define	CISTPL_JEDEC_C		0x18	/* JEDEC Device (common mem) */
#define	CISTPL_JEDEC_A		0x19	/* JEDEC Device (attr mem) */

/*
 * CISTPL_CONF:
 *	TPCC_LAST	: Index # of last CISTPL_CE
 *	TPCC_SZ		: Sizes of following fields
 *	TPCC_RADR
 *	TPCC_RMSK
 *	TPCC_RFU
 */

#define	CISTPL_CONF		0x1a	/* Configuration */

/* Structure of TPCC_SZ byte */

# define TPCC_RASZ_bfpos	0
# define TPCC_RASZ_bflen	2
# define TPCC_RMSZ_bfpos	2
# define TPCC_RMSZ_bflen	4
# define TPCC_RFSZ_bfpos	6
# define TPCC_RFSZ_bflen	2

/* Configuration register presence bits defined by TPCC_RMSK */
#  define TPCC_RMSK_COR		1
#  define TPCC_RMSK_CCSR	2
#  define TPCC_RMSK_PRR		4
#  define TPCC_RMSK_SCR		8

/* Offset of defined configuration registers */
/* XXX this should belong to something like pcmcia_phys.h */
#  define CREG_COR		0	/* Configuration Option Register */
#  define CREG_CCSR		2	/* Card Configuration and Status Reg */
#  define CREG_PRR		4	/* Pin Replacement Register */
#  define CREG_SCR		6	/* Socket and Copy Register */

/* Bit function of COR (Configuration Option Register) */
#   define COR_SOFTRESET	0x80	/* Soft Reset */
#   define COR_LVLINTR		0x40	/* Level Interrupt */
#   define COR_CARDENABLE	0x20	/* Intel iCU110/210 defines this */

/* Bit function of CCSR (Card Configuration and Status Register) */
#   define CCSR_RI		0x10	/* Drive Ring Indication */
#   define CCSR_AUDIO		0x08	/* Drive audio pin */
#   define CCSR_PWRDWN		0x04	/* Power down mode */
#   define CCSR_INTR		0x02	/* Interrupt pending (RO) */


/*
 * CISTPL_CE:
 *
 *	Repeated occurences of:
 *
 *	TPCE_IFDIDX	: Contains TPCE_IF, TPCE_DEFAULT, TPCE_INDEX
 *	TPCE_IF		: Interface byte
 *	TPCE_FS		: Feature Selector (Presence and sizes of TPCE_PD,
 *			  TPCE_TD, TPCE_IO, TPCE_IR, TPCE_WIN, TPCE_MI
 *	(TPCE_PD)	: Power description
 *	(TPCE_TD)	: Timing description
 *	(TPCE_IO)	: I/O description
 *	(TPCE_IR)	: Interrupt types and level masks
 *	(TPCE_MI)	: Misc. Info. (Max.card, audio, ro, power down)
 */

#define	CISTPL_CE		0x1b	/* Configuration Entry */

/* Structure of the TPCE_INDX */

# define TPCE_INDEX_bfpos	0
# define TPCE_INDEX_bflen	6
# define TPCE_DEFAULT_bfpos	6
# define TPCE_DEFAULT_bflen	1
# define TPCE_IF_bfpos		7
# define TPCE_IF_bflen		1

/* Structure of the TPCE_IF */
# define TPCE_IF_TYPE_bfpos	0
# define TPCE_IF_TYPE_bflen	4
# define TPCE_IF_BVD_bfpos	4
# define TPCE_IF_BVD_bflen	1
# define TPCE_IF_WP_bfpos	5
# define TPCE_IF_WP_bflen	1
# define TPCE_IF_RDYBSY_bfpos	6
# define TPCE_IF_RDYBSY_bflen	1
# define TPCE_IF_MWAIT_bfpos	7
# define TPCE_IF_MWAIT_bflen	1

/* Values for TPCE_IF_TYPE */
#  define TPCE_IF_TYPE_MEMORY	0
#  define TPCE_IF_TYPE_IO	1
#  define TPCE_IF_TYPE_RFU1	2
#  define TPCE_IF_TYPE_RFU2	3
#  define TPCE_IF_TYPE_DEDIC1	4
#  define TPCE_IF_TYPE_DEDIC2	5
#  define TPCE_IF_TYPE_DEDIC3	6
#  define TPCE_IF_TYPE_DEDIC4	7

/* TPCE_FS */
# define TPCE_FS_PD_bfpos	0
# define TPCE_FS_PD_bflen	2
# define TPCE_FS_TD_bfpos	2
# define TPCE_FS_TD_bflen	1
# define TPCE_FS_IO_bfpos	3
# define TPCE_FS_IO_bflen	1
# define TPCE_FS_IR_bfpos	4
# define TPCE_FS_IR_bflen	1
# define TPCE_FS_MS_bfpos	5
# define TPCE_FS_MS_bflen	2
# define TPCE_FS_MI_bfpos	7
# define TPCE_FS_MI_bflen	1

/* TPCE_PD */
# define TPCE_PD_NOM_V_bfpos	0
# define TPCE_PD_NOM_V_bflen	1
# define TPCE_PD_MIN_V_bfpos	1
# define TPCE_PD_MIN_V_bflen	1
# define TPCE_PD_MAX_V_bfpos	2
# define TPCE_PD_MAX_V_bflen	1
# define TPCE_PD_STATIC_C_bfpos	3
# define TPCE_PD_STATIC_C_bflen	1
# define TPCE_PD_AVG_C_bfpos	4
# define TPCE_PD_AVG_C_bflen	1
# define TPCE_PD_PEAK_C_bfpos	5
# define TPCE_PD_PEAK_C_bflen	1
# define TPCE_PD_PDWN_C_bfpos	6
# define TPCE_PD_PDWN_C_bflen	1

/* I'm little tired of doing this ... */

/* TPCE_TD */

/* TPCE_IO */

/* TPCE_MEM */

/* TPCE_IR */
#define	CISTPL_IR_SHARED	(1 << 7)
#define	CISTPL_IR_PULSE		(1 << 6)
#define	CISTPL_IR_LEVEL		(1 << 5)
#define	CISTPL_IR_MASKS		(1 << 4)
#define	CISTPL_IR_IRQN_MASK	0x0f
#define	CISTPL_IR_VEND		(1 << 3)
#define	CISTPL_IR_BERR		(1 << 2)
#define	CISTPL_IR_IOCK		(1 << 1)
#define	CISTPL_IR_NMI		(1 << 0)

/* TPCE_MI */

#define	CISTPL_DEVICE_OC	0x1c
#define	CISTPL_DEVICE_OA	0x1d
#define	CISTPL_DEVICEGEO	0x1e	/* Device geometry (common mem) */
#define	CISTPL_DEVICEGEO_A	0x1f	/* Device geometry (attr mem) */
#define	CISTPL_MANFID		0x20	/* Mfr ID */

#define	CISTPL_FUNCID		0x21	/* Function ID */
# define TPLFID_MULTIFUNC	0x00	/* Multi-function card */
# define TPLFID_MEMORY		0x01	/* RAM, ROM, EEPROM, Flash, etc. */
# define TPLFID_SERIAL		0x02	/* Serial I/O (incl. Fax/Modem) */
# define TPLFID_PARALLEL	0x03	/* Parallel I/O (incl. Bidir) */
# define TPLFID_ATA		0x04	/* ATA */
# define TPLFID_VIDEO		0x05	/* Video adapter */
# define TPLFID_LAN		0x06	/* LAN interface */
# define TPLFID_AIMS		0x07	/* Auto Indexing Mass Storage */

#define	CISTPL_FUNCE		0x22	/* Extended function ID */

#define	CISTPL_VERS_2		0x40	/* Version 2 */
#define	CISTPL_FORMAT		0x41
#define	CISTPL_GEOMETRY		0x42
#define	CISTPL_BYTEORDER	0x43
#define	CISTPL_DATE		0x44
#define	CISTPL_BATTERY		0x45	/* Last battery replacement date */
#define	CISTPL_ORG		0x46

#define	CISTPL_END		0xff
