/*	BSDI ss_types.h,v 1.2 1996/07/25 22:09:43 prb Exp */
/* WILDBOAR $Wildboar: ss_types.h,v 1.5 1996/02/13 13:02:34 shigeya Exp $ */
/*
 *  Portions or all of this file are Copyright(c) 1994,1995,1996
 *  Yoichi Shinoda, Yoshitaka Tokugawa, WIDE Project, Wildboar Project
 *  and Foretune.  All rights reserved.
 *
 *  This code has been contributed to Berkeley Software Design, Inc.
 *  by the Wildboar Project and its contributors.
 *
 *  The Berkeley Software Design Inc. software License Agreement specifies
 *  the terms and conditions for redistribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE WILDBOAR PROJECT AND CONTRIBUTORS
 *  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 *  WILDBOAR PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _SS_TYPES_H_
#define _SS_TYPES_H_

typedef int ss_retcode_t ;

/*
 * Some additional flags
 *
 * In addition to error codes defined in SS2.1, we make the use of following
 * error codes.
 */

/*
 * Failure on power supply circuit.
 * Some cases this error code is returned are:
 *
 *	1. Voltages couldn't reach its nominal value when firing up a card.
 *	2. Current limitter was activated.
 */
#define	SSERR_POW_FAILURE	0x20

typedef	unsigned char ss_byte_t ;
typedef	unsigned short ss_word_t ;
typedef	unsigned int ss_dword_t ;
typedef	int ss_adapter_t ;
typedef ss_word_t ss_base_t ;
typedef ss_word_t ss_bcd_t ;
typedef int ss_count_t ;
typedef ss_byte_t ss_edc_t ;
typedef ss_byte_t ss_flags8_t ;
typedef ss_word_t ss_flags16_t ;
typedef ss_dword_t ss_flags32_t ;
typedef ss_byte_t ss_irq_t ;
typedef ss_word_t ss_offset_t  ;
typedef int ss_page_t ;
typedef int ss_pwrindex_t ;
typedef ss_word_t ss_signature_t ;
typedef ss_word_t ss_size_t ;
typedef int ss_socket_t ;
typedef ss_byte_t ss_speed_t ;
typedef int ss_window_t;
typedef ss_word_t ss_sktbits_t ;

typedef struct pwrentry {
	ss_byte_t	PowerLevel ;
	ss_flags8_t	ValidSignals ;	
} ss_pwrentry_t ;

/* Power signal indicators */

#define	SS_VCC	0x80
#define	SS_VPP1	0x40
#define	SS_VPP2	0x20

typedef struct chartbl {
	union {
		ss_flags16_t	u_ct_AdpCaps ;
		ss_flags16_t	u_ct_SktCaps ;
	} u_ct ;
#	define AdpCaps	u_ct.u_ct_AdpCaps
#	define SktCaps	u_ct.u_ct_SktCaps
	ss_flags32_t	ActiveHigh ;
	ss_flags32_t	ActiveLow ;
} ss_chartbl_t ;

typedef struct memwintbl {
	ss_flags16_t	MemWndCaps ;
	ss_base_t	FirstByte ;
	ss_base_t	LastByte ;
	ss_size_t	MinSize ;
	ss_size_t	MaxSize ;
	ss_size_t	ReqGran ;
	ss_size_t	ReqBase ;
	ss_size_t	ReqOffset ;
	ss_speed_t	Slowest ;
	ss_speed_t	Fastest ;
} ss_memwintbl_t ;

typedef struct iowintbl {
	ss_flags16_t	IOWndCaps ;
	ss_base_t	FirstByte ;
	ss_base_t	LastByte ;
	ss_size_t	MinSize ;
	ss_size_t	MaxSize ;
	ss_size_t	ReqGran ;
	ss_count_t	AddrLines ;
	ss_flags8_t	EISASlot ;
} ss_iowintbl_t ;

/* Memory window base/size unit size */

#define	SS_ADDRSHIFT	12
#define	SS_ADDRUNIT	(1 << SS_ADDR_SHIFT)

/* Window capabilities */
#define	WC_COMMON	0x01
#define	WC_ATTRIBUTE	0x02
#define	WC_IO		0x04
#define	WC_MEM		0x08	/* Not defined in SS spec JEIDA4.2/PCMCIA2.1*/
#define	WC_WAIT		0x80

/* Adapter capabilities */
#define	AC_IND	0x0001
#define	AC_PWR	0x0002
#define	AC_DBW	0x0004

/* Adapter status */
#define	AS_POWERDOWN	0x01
#define	AS_MAINTAIN	0x02


/* Memory and I/O window common capabilities */

#define	WC_BASE		0x0001
#define	WC_SIZE		0x0002
#define	WC_WENABLE	0x0004
#define	WC_8BIT		0x0008
#define	WC_16BIT	0x0010
#define	WC_BALIGN	0x0020
#define	WC_POW2		0x0040

/* Memory window, paging capabilities */

#define	WC_CALIGN	0x0080
#define	WC_PAVAIL	0x0100
#define	WC_PSHARED	0x0200
#define	WC_PENABLE	0x0400
#define	WC_WP		0x0800

/* I/O window capabilities */

#define	WC_INPACK	0x0080
#define	WC_EISA		0x0100
#define	WC_CENABLE	0x0200

/* Memory, I/O window common status */

#define	WS_IO		0x01
#define	WS_ENABLED	0x02
#define	WS_16BIT	0x04

/* Memory window status */

#define	WS_PAGED	0x08

/* I/O window status */

#define	WS_EISA		0x08
#define	WS_CENABLE	0x10

/* Page status */

#define	PS_ATTRIBUTE	0x01
#define	PS_ENABLED	0x02
#define	PS_WP		0x04

/* Socket capabilities/status */

#define	SBM_WP		0x01
#define	SBM_LOCKED	0x02
#define	SBM_EJECT	0x04
#define	SBM_INSERT	0x08
#define	SBM_BVD1	0x10
#define	SBM_BVD2	0x20
#define	SBM_RDYBSY	0x40
#define	SBM_CD		0x80

#define	SBM_LOCK	0x10
#define	SBM_BATT	0x20
#define	SBM_BUSY	0x40
#define	SBM_XIP		0x80

/* Interface type */

#define	IF_MEMORY	0x01
#define	IF_IO		0x02

/* EDC functions */

#define	EDC_UNI		0x01
#define	EDC_BI		0x02
#define	EDC_REGISTER	0x04
#define	EDC_MEMORY	0x08
#define	EDC_PAUSABLE	0x10

#define	EDC_WRITE	0x02

#define	ET_CHECK8	0x01
#define	ET_SDLC16	0x02

typedef struct adpinfo_t {
	ss_count_t	NumSockets ;
	ss_count_t	NumWindows ;
	ss_count_t	NumEDCs ;
	ss_chartbl_t	CharTable ;
	ss_word_t	NumPwrEntries ;
	ss_pwrentry_t	PwrEntry[5] ;	/* 0, 3, 3.3, 5, 12 */
} ss_adpinfo_t ;

/*
 * ss_wininfo_t used for InquireWindow() function.
 *
 * What a bummer! PCMCIA/JEIDA people was stupid enough to make the
 * specification to use variable length member in a structure, just to
 * handle something that takes either 1 or 2 in structure count.  Spare
 * those thoughts for Bevis or ButtHeads (or both), or they should stop
 * watching MTV or do I have to use some kind of aminutions to wake these
 * people up?
 *
 * This is something that ANY DESCENT designer would NEVER EVER do, so I
 * will add WC_MEM to WndCaps to indicate that a window is capable of
 * handling memory interface, and expand WinTbl member to MemWinTbl and
 * IOWinTbl so that nightmares associated with variable length structure
 * will just disappear from the set I already have to deal with.
 *
 */

typedef struct wininfo_t {
	ss_flags8_t	WndCaps ;
	ss_sktbits_t	Sockets ;
	ss_memwintbl_t	MemWinTbl ;
	ss_iowintbl_t	IOWinTbl ;
} ss_wininfo_t ;

/*
 * Utility structures
 */
/* GetAdapter/SetAdapter */

typedef struct sgadapter {
	ss_flags8_t	AdapterState ;
	ss_irq_t	SCRouting ;
	int		(*EventHandler)() ;	/* BSDI specific */
	void		*EventTag ;		/* BSDI specific */
} ss_sgadapter_t ;

#define IRQ_LOW		0x20
#define	IRQ_HIGH	0x40
#define	IRQ_ENABLED	0x80

typedef struct sockinfo {
	ss_chartbl_t CharTable ;
	ss_flags8_t SCIntCaps ;
	ss_flags8_t SCRptCaps ;
	ss_flags8_t CtlIndCaps ;
} ss_sockinfo_t ;

/*
 * GetSocket/SetSocket/GetStatus
 *
 * Implementation Note:
 *
 * 'State' field for [Get|Set]Socket and 'SocketState' field for 
 * GetStatus in the original Socket Services Version 2.1 Specification
 * is misleading.  These fields are meant to convey transition of
 * states, not the state them selves.  They are renamed to 'SChange'
 * in this implementation.  'CardState' is also renamed to 'SState'.
 */

typedef struct sgsocket {
	ss_flags8_t	SCIntMask ;
	ss_pwrindex_t	VccLevel, Vpp1Level, Vpp2Level ;
	ss_flags8_t	SChange ;	/* Was 'State' */
	ss_flags8_t	CtlInd ;
	ss_irq_t	IREQRouting ;
	ss_flags8_t	IFType ;
} ss_sgsocket_t ;

typedef struct getstatus {
	ss_flags8_t	SState ;	/* Was 'CardState' */
	ss_flags8_t	SChange ;	/* Was 'SocketState' */
	ss_flags8_t	CtlInd ;
	ss_irq_t	IREQRouting ;
	ss_flags8_t	IFType ;
} ss_status_t ;

/* GetWindow/SetWindow */

typedef struct sgwindow {
	ss_socket_t	Socket ;
	ss_size_t	Size ;
	ss_flags8_t	State ;
	ss_speed_t	Speed ;
	ss_base_t	Base ;
} ss_sgwindow_t ;

/* GetPage/SetPage */

typedef struct sgpage {
	ss_flags8_t	State ;
	ss_offset_t	Offset ;
} ss_sgpage_t ;

typedef struct vinfo {
	ss_word_t	DataLength ;
	char		*Implementor ;
} ss_vinfo_t ;

/*
 * GetSSInfo
 */
#define SS_REV_MAJ(rev)		(((rev) >> 8) & 0xff)
#define SS_REV_MIN(rev)		((rev) & 0xff)

ss_retcode_t
ss_AcknowledgeInterrupt __P((ss_adapter_t Adapter, ss_sktbits_t *pSockets));

ss_retcode_t
ss_GetSSInfo __P((ss_adapter_t, int *pCompliance, int *pNumAdp, int *pFirstAdp)) ;

ss_retcode_t
ss_GetVendorInfo __P((ss_adapter_t Adapter , int Type, ss_vinfo_t *pVInfo)) ;

ss_retcode_t
ss_GetAdapterCount
	__P((ss_count_t *, ss_signature_t *)) ;

ss_retcode_t
ss_InquireAdapter __P((ss_adapter_t Adapter, ss_adpinfo_t *)) ;

ss_retcode_t
ss_GetAdapter __P((ss_adapter_t, ss_sgadapter_t *)) ;

ss_retcode_t
ss_SetAdapter __P((ss_adapter_t, ss_sgadapter_t *)) ;

ss_retcode_t
ss_InquireSocket __P((ss_adapter_t, ss_socket_t, ss_sockinfo_t *)) ;

ss_retcode_t
ss_GetSocket __P((ss_adapter_t, ss_socket_t, ss_sgsocket_t *)) ;

ss_retcode_t
ss_SetSocket __P((ss_adapter_t, ss_socket_t, ss_sgsocket_t *)) ;

ss_retcode_t
ss_ResetSocket __P((ss_adapter_t , ss_socket_t)) ;

ss_retcode_t
ss_GetStatus __P((ss_adapter_t, ss_socket_t, ss_status_t *)) ;

ss_retcode_t
ss_InquireWindow __P((ss_adapter_t, ss_window_t, ss_wininfo_t *)) ;

ss_retcode_t
ss_GetWindow __P((ss_adapter_t, ss_window_t, ss_sgwindow_t *)) ;

ss_retcode_t
ss_SetWindow __P((ss_adapter_t, ss_window_t, ss_sgwindow_t *)) ;

ss_retcode_t
ss_GetPage __P((ss_adapter_t, ss_window_t, ss_page_t, ss_sgpage_t *)) ;

ss_retcode_t
ss_SetPage __P((ss_adapter_t, ss_window_t, ss_page_t, ss_sgpage_t *)) ;

ss_retcode_t
ss_PeekMemory __P((ss_adapter_t, ss_socket_t, u_char *, int, int, u_char *)) ;

ss_retcode_t
ss_Debug __P((ss_adapter_t, ss_socket_t, int, int)) ;

#endif
