	/*
	 * Initialize the serial port
	 */
#define COMPORT		0x3f8

#define COM_DATA	0
#define COM_DLBL	0
#define COM_DLBH	1
#define COM_IER		2
#define COM_IIR		2
#define COM_CFCR	3
#define COM_MCR		4
#define COM_LSR		5

#define COM_DLAB	0x80
#define COM_8BITS	3
#define COM_IERBITS	7	/* IER_ERXRDY | IER_ETXRDY | IER_ERLS */
#define COM_MCRBITS	6	/* MCR_DTR | MCR_RTS */
#define COM_TXRDY	0x20

#define Out(x,y) \
	movw	$(COMPORT + x), %dx ;\
	movb	y, %al ;\
	outb	%al,%dx

#define In(x) \
	movw	$(COMPORT + x), %dx ;\
	inb	%dx,%al
