/*-
 * Copyright (c) 1996 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI PUT.h,v 2.1.20.2 2001/08/02 21:53:27 prb Exp
 */

/*
 * Debug characters start on column 40 of the last line
 */

#define CRT_MONO	(0xb0000+(24*80*2)+40)
#define CRT_COLOR	(0xb8000+(24*80*2)+40)

#define	PUT_MONO(a, c, col)	movw	$(a<<8)+(c), CRT_MONO+2*(col);
#define	PUT_COLOR(a, c, col)	movw	$(a<<8)+(c), CRT_COLOR+2*(col);

/*
 * Note that the assembler will strip the upper 16 bits of the address
 */
#define	PUT_MONO16(a, c, col)	movw	$(a<<8)+(c), %gs:CRT_MONO+2*(col);
#define	PUT_COLOR16(a, c, col)	movw	$(a<<8)+(c), %gs:CRT_COLOR+2*(col);

#ifndef	PUT_DELAY
#define	PUT_DELAY		/* void */
#endif

#define	PUT16_INIT	pushw $0xb000; pop %gs

#ifndef	PUT_C_MOD
#define	PUT_C_MOD
#endif

#define	PUT(c,col) \
	PUT_MONO(0x1f, c PUT_C_MOD, col) \
	PUT_COLOR(0x1f, c PUT_C_MOD, col) \
	PUT_DELAY

#define	PUT16(c,col) \
	PUT_MONO16(0x1f, c PUT_C_MOD, col) \
	PUT_COLOR16(0x1f, c PUT_C_MOD, col) \
	PUT_DELAY

/* erase debugging PUT; assumes black background */
#define	UNPUT(col) \
	PUT_MONO(0x07, 0x20, col) \
	PUT_COLOR(0x07, 0x20, col)
