/*-
 * Copyright (c) 2001 Wind River Systems
 * Copyright (c) 1994 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *      bioscall.h,v 2.5.2.1 2001/06/07 04:59:15 prb Exp
 */

#define	BIOS_BUFSIZE	0x1000

#ifdef	LOCORE
#define	BIOSARGSOFF_EAX	0
#define	BIOSARGSOFF_EBX	4
#define	BIOSARGSOFF_ECX	8
#define	BIOSARGSOFF_EDX	12
#define	BIOSARGSOFF_EDI	16
#define	BIOSARGSOFF_ESI	20
#define	BIOSARGSOFF_ES	24
#define	BIOSARGSOFF_EFL	28

#else	/* LOCORE */

union wordchar {
	struct highlowbyte {
		u_char low;
		u_char high;
		u_char dummy[2];
	} byte;
	struct highlowword {
		u_int16_t low;
		u_int16_t dummy;
	} word;
	u_int32_t dblword;
};


/*
 * The exact layout of this structure is assumed
 * by the code in bios_call.s.  Changes here must
 * be reflected there.
 */
struct bios_args {
	union wordchar ba_wa;
	union wordchar ba_wb;
	union wordchar ba_wc;
	union wordchar ba_wd;
	union wordchar ba_wdi;
	union wordchar ba_wsi;
	union wordchar ba_wes;
	union wordchar ba_fl;
} __attribute__ ((packed));

#define	ba_eax	ba_wa.dblword
#define ba_ax 	ba_wa.word.low
#define ba_ah	ba_wa.byte.high
#define ba_al	ba_wa.byte.low

#define	ba_ebx	ba_wb.dblword
#define ba_bx	ba_wb.word.low
#define ba_bh	ba_wb.byte.high
#define ba_bl	ba_wb.byte.low

#define	ba_ecx	ba_wc.dblword
#define ba_cx	ba_wc.word.low
#define ba_ch	ba_wc.byte.high
#define ba_cl	ba_wc.byte.low

#define	ba_edx	ba_wd.dblword
#define ba_dx	ba_wd.word.low
#define ba_dh	ba_wd.byte.high
#define ba_dl	ba_wd.byte.low

#define	ba_edi	ba_wdi.dblword
#define	ba_di	ba_wdi.word.low

#define	ba_esi	ba_wsi.dblword
#define	ba_si	ba_wsi.word.low

#define	ba_flags	ba_fl.word.low
#define	ba_eflags	ba_fl.dblword

#define	ba_es	ba_wes.word.low

void bios_call __P((int, struct bios_args *));
void _bios_call __P((int, struct bios_args *));

struct bios_dap {
	u_char	length;		/* should be 0x10 */
	u_char	reserved;	/* must be 0 */
	u_int16_t nblocks;	/* number of blocks to read/write */
	u_int16_t bufoff;	/* transfer buffer address - offset */
	u_int16_t bufseg;	/* transfer buffer address - segment */
	u_int32_t offset;	/* lower 32 bits of block offset into disk */
	u_int32_t offsethi;	/* upper 32 bits of block offset into disk */
};
	

extern char bios_call_buffer[];		/* Bounce buffer for BIOS calls */
extern struct bios_dap bios_call_dap;	/* Disk Address Packet for LBA calls */

#endif /* LOCORE */
