/*	BSDI bootany.h,v 2.1 2001/02/27 16:53:54 donn Exp	*/

#define	off(addr)	((addr) - NewBootLocation)

	.set	Numeric,0x30			# First numeric value

	.set	BootLocation,0x7c00		# Address where DOS loads us
	.set	BootSeg,BootLocation >> 4	# Segment where DOS loads us
	.set	NewBootLocation,0x0600		# Address where we relocate
	.set	NewBootSeg,NewBootLocation >> 4	# Segment where we relocate
	.set	SecSize,0x200

	.set	max_partitions,4		# Can't fit any more
	.set	part_text_len,7			# max bytes for partition desc
	.set	size_PartitionEntry,16
	.set	size_PartData,13
	.set	NoActivePart,size_PartitionEntry * 4
	.set	DataAddr,SecSize - ((size_PartitionEntry*4) + (size_PartData*max_partitions) + 2 + 2)

	.set	PartAddr,off(part)		# offset to partition table
	.set	part.partition,off(part+0)
	.set	part.drivehead,off(part+1)
	.set	part.sectorcyl,off(part+3)
	.set	part.text,off(part+5)
	.set	part.term,off(part+5+part_text_len)

	.set	partitionTable.BootIndicator,off(partitionTable+0)
	.set	partitionTable.BeginHead,off(partitionTable+1)
	.set	partitionTable.BeginSector,off(partitionTable+2)
	.set	partitionTable.BeginCyl,off(partitionTable+3)
	.set	partitionTable.SystemID,off(partitionTable+4)
	.set	partitionTable.EndHead,off(partitionTable+5)
	.set	partitionTable.EndSector,off(partitionTable+6)
	.set	partitionTable.EndCyl,off(partitionTable+7)
	.set	partitionTable.RelSectorLow,off(partitionTable+8)
	.set	partitionTable.RelSectorHigh,off(partitionTable+10)
	.set	partitionTable.NumSectorsLow,off(partitionTable+12)
	.set	partitionTable.NumSectorsHigh,off(partitionTable+14)
