/*-
 * Copyright (c) 1994, 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI stand.h,v 2.13.2.2 2001/08/06 19:56:43 seebs Exp
 */

#define NET_MAJORDEV	4	/* from conf.c */
#define WD_MAJORDEV	3	/* from conf.c */
#define FD_MAJORDEV	9	/* from conf.c */
#define SD_MAJORDEV	18	/* from conf.c */
#define SR_MAJORDEV	34	/* from conf.c */
#define TF_MAJORDEV	42	/* from conf.c */
#define ROBIN_MAJORDEV	43	/* fomr conf.c */
#define CR_MAJORDEV	46	/* from conf.c */
#define DC2_MAJORDEV	47	/* from conf.c */
#define BD_MAJORDEV	0

#define ISO_DEFAULT_BLOCK_SIZE	2048 
#define ISO_DEFAULT_BLOCK_SIZE_SHIFT	11

/*
 * For SCSI, ORing TWOK_BLOCKS into the adapter field
 * indicates use of a CD-ROM with 2K blocks.
 */
#define TWOK_BLOCKS	0x8


#ifndef SMALL
#define	KB_ABORT			/* abort I/O on keyboard input */
#endif

/* convert kilobytes to a multiple of the page size, in bytes */
#define k2truncpage(k)  (((k) * 1024) &~ (NBPG - 1))


#ifndef LOCORE
#include <stand/stand.h>
/*
 * Machine-dependent fields in standalone file structure.
 */
typedef struct iob {
	int	i_adapt;	/* adapter (XXX) */
	int	i_ctlr;		/* controller index */
	int	i_unit;		/* disk unit */
	int	i_part;		/* and partition */
	daddr_t	i_boff;
	struct	open_file *i_open_file;

	daddr_t	is_bn;		/* only used by scsi */
	char	*is_ma;		/* only used by scsi */
	u_int	is_cc;		/* only used by scsi */
	u_int	i_dbs;		/* dev block size of device */
	u_int	i_dbshift;	/* dev block shift value */
} iob_t;


struct md_boot_options {
	struct mi_boot_options o_mi;
	int	o_apm;
	u_int	o_basemem;
	int	o_entry;
	u_int	o_extmem;
	int	o_sizemem;
	int	o_noflushcache;
	int	o_rootdev;
	int	o_rootdevset;
	int	o_searchend;		/* -1 means use CMOS */
};

#define o_cmd		o_mi.o_cmd
#define o_defaultboot	o_mi.o_defaultboot
#define o_howto		o_mi.o_howto
#define o_loaded	o_mi.o_loaded
#define o_ramdisksize	o_mi.o_ramdisksize
#define o_ramdiskimage	o_mi.o_ramdiskimage

/* Method to use for sizing memory */
#define	SIZEMEM_BASE_ACPI		0x01	/* Use ACPI info */
#define	SIZEMEM_BASE_BIOS		0x02	/* Use INT 12 */
#define	SIZEMEM_BASE_BEST		0x03	/* All of the above */
#define	SIZEMEM_EXT_ACPI		0x04	/* Use ACPI info */
#define	SIZEMEM_EXT_BIOS		0x08	/* Use INT 15,E801 */
#define	SIZEMEM_EXT_SCAN		0x10	/* Scan for memory */
#define	SIZEMEM_EXT_BEST		0x1C	/* All of the above */
#define	SIZEMEM_BEST			0x1f	/* All of the above */
#define	SIZEMEM_ACPI			(SIZEMEM_EXT_ACPI | SIZEMEM_BASE_ACPI)
#define	SIZEMEM_BIOS			(SIZEMEM_EXT_BIOS | SIZEMEM_BASE_BIOS)

void	addisaparam __P((void));
void	cardparamprint __P((void));
void	cgacnputc __P((int));
void	cninit __P((void));
int	cnpoll __P((char *));
int	comcngetc __P((void));
int	comcninit __P((void));
int	comcnpoll __P((char *));
void	comcnputc __P((int));
void	configure __P((void));
void	delay __P((int));
int	dev_decode __P((char *, char **));
void	erase_status_line __P((void));
void	getbiosgeom __P((int, struct biosgeom *));
struct bootparam *getbootparam __P((int, struct bootparam *));
void   *getbspace __P((int len, char *desc));
int	inb __P((u_int));
void	insw __P((int, void *, int));
void	isa_irqprint __P((void));
void	isa_memprint __P((void));
void	isa_portprint __P((void));
int	iomemcmd __P((char *, char *, int ));
int	ioportcmd __P((char *, char *, int ));
void	iowaitcmd __P((int ));
int	irqcmd __P((char *, int));
void	isa_init __P((void ));
void	isa_memalloc __P((int, int));
int	isa_memcheck __P((int, int));
void	isa_memfree __P((int, int));
void	isa_portalloc __P((int, int));
void	isa_portfree __P((int, int));
int	kbdcngetc __P((void));
int	kbdcninit __P((void));
int	kbdcnpoll __P((char *));
void	lidt __P((void *, int));
void	load_init __P((struct md_boot_options *));
int	load_io __P((char *, size_t));
void	outb __P((u_int, u_char));
void	outsw __P((int, void *, int));
int	probe_apm __P((void));
int	rcr2 __P((void));
void	reboot __P((void));
int	sdopen __P((void *));
void	setbiosgeom __P((struct biosgeom *));
int	setcomconsole __P((char *, struct bootcons *bc));
void	setconsole __P((char *));
void	sizemem __P((struct md_boot_options *));
void	trapinit __P((void));
void	wait __P((int));

#endif
