/*	BSDI if.h,v 2.36.6.1 2001/03/13 21:03:48 dab Exp	*/

/*
 * Copyright (c) 1982, 1986, 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)if.h	8.3 (Berkeley) 2/9/95
 */

#ifndef _NET_IF_H_
#define _NET_IF_H_

/*
 * Structures defining a network interface, providing a packet
 * transport mechanism (ala level 0 of the PUP protocols).
 *
 * Each interface accepts output datagrams of a specified maximum
 * length, and provides higher level routines with input datagrams
 * received from its medium.
 *
 * Output occurs when the routine if_output is called, with three parameters:
 *	(*ifp->if_output)(ifp, m, dst, rt)
 * Here m is the mbuf chain to be sent and dst is the destination address.
 * The output routine encapsulates the supplied datagram if necessary,
 * and then transmits it on its medium.
 *
 * On input, each interface unwraps the data received by it, and either
 * places it on the input queue of a internetwork datagram routine
 * and posts the associated software interrupt, or passes the datagram to a raw
 * packet input routine.
 *
 * Routines exist for locating interfaces by their addresses
 * or for locating a interface on a certain network, as well as more general
 * routing and gateway routines maintaining information used to locate
 * interfaces.  These routines live in the files if.c and route.c
 */
#ifndef _TIME_ /*  XXX fast fix for SNMP, going away soon */
#include <sys/time.h>
#endif

#if defined(KERNEL) && !defined(ATSH_ADD)
#include <sys/systm.h>
#endif

#ifdef __STDC__
/*
 * Forward structure declarations for function prototypes [sic].
 */
struct	mbuf;
struct	proc;
struct	rtentry;	
struct	socket;
struct	ether_header;
struct	rt_addrinfo;
struct	sockaddr_dl;
#endif

/* Externally-visible interface information */
struct if_data {
/* generic interface information */
	u_char	ifi_type;		/* ethernet, tokenring, etc */
	u_char	ifi_addrlen;		/* media address length */
	u_char	ifi_hdrlen;		/* media header length */
	u_long	ifi_mtu;		/* maximum transmission unit */
	u_long	ifi_metric;		/* routing metric (external only) */
	u_long	ifi_baudrate;		/* linespeed */
/* volatile statistics */
	u_quad_t ifi_ipackets;		/* packets received on interface */
	u_quad_t ifi_ierrors;		/* input errors on interface */
	u_quad_t ifi_opackets;		/* packets sent on interface */
	u_quad_t ifi_oerrors;		/* output errors on interface */
	u_quad_t ifi_collisions;	/* collisions on csma interfaces */
	u_quad_t ifi_ibytes;		/* total number of octets received */
	u_quad_t ifi_obytes;		/* total number of octets sent */
	u_quad_t ifi_imcasts;		/* packets received via multicast */
	u_quad_t ifi_omcasts;		/* packets sent via multicast */
	u_quad_t ifi_iqdrops;		/* dropped on input, this interface */
	u_quad_t ifi_noproto;		/* destined for unsupported protocol */
	struct	timeval ifi_lastchange;	/* last updated */
	u_quad_t ifi_oqdrops;		/* dropped on output, this interface */
};

/*
 * Structure defining a queue for a network interface
 * or network protocol.
 */
struct ifqueue {
	struct	mbuf *ifq_head;
	struct	mbuf *ifq_tail;
	int	ifq_len;
	int	ifq_maxlen;
	int	ifq_drops;
};

/*
 * Structure describing information about an interface
 * which may be of interest to management entities.
 *
 * (Would like to call this struct ``if'', but C isn't PL/1.)
 */

struct ifnet {
	void	*if_softc;		/* pointer to driver state */
	char	*if_name;		/* name, e.g. ``en'' or ``lo'' */
	struct	ifnet *if_next;		/* all struct ifnets are chained */
	struct	ifaddr *if_addrlist;	/* linked list of addresses per if */
        int	if_pcount;		/* number of promiscuous listeners */
	void	*if_bpf;		/* packet filter structure */
	u_short	if_index;		/* numeric abbreviation for this if  */
	short	if_unit;		/* sub-unit for lower level driver */
	short	if_timer;		/* time 'til if_watchdog called */
	short	if_flags;		/* up/down, broadcast, etc. */
	struct	if_data if_data;
/* procedure handles */
	void	(*if_init)		/* init routine */
		__P((void *));
	int	(*if_output)		/* output routine (enqueue) */
		__P((struct ifnet *, struct mbuf *, struct sockaddr *,
		     struct rtentry *));
	int	(*if_ctloutput)		/* control output routine */
		__P((int op, struct ifnet *ifp, int level,
		    int optname, struct mbuf **m));
	void	(*if_start)		/* initiate output routine */
		__P((struct ifnet *));
	int	(*if_done)		/* output complete routine */
		__P((struct ifnet *));	/* (XXX not used; fake prototype) */
	int	(*if_ioctl)		/* ioctl routine */
		__P((struct ifnet *, u_long, caddr_t/*, struct proc * */));
	void	(*if_watchdog)		/* timer routine */
		__P((struct ifnet *));
	int	(*if_sysctl)		/* sysctl routine */
		__P((struct ifnet *, int *, u_int, void *, size_t *, void *,
		    size_t));

	struct	ifqueue if_snd;		/* output queue */
	struct	ifnet *if_pif;		/* back pointer to pif */
	int	if_addrmask;		/* af's on this i/f */

	struct ifprefix *if_prefixlist;	/* linked list of prefixes per if */

	void	(*if_input)
		__P((struct ifnet *, struct mbuf *, int, int));
};
#define	if_mtu		if_data.ifi_mtu
#define	if_type		if_data.ifi_type
#define	if_addrlen	if_data.ifi_addrlen
#define	if_hdrlen	if_data.ifi_hdrlen
#define	if_metric	if_data.ifi_metric
#define	if_baudrate	if_data.ifi_baudrate
#define	if_ipackets	if_data.ifi_ipackets
#define	if_ierrors	if_data.ifi_ierrors
#define	if_opackets	if_data.ifi_opackets
#define	if_oerrors	if_data.ifi_oerrors
#define	if_collisions	if_data.ifi_collisions
#define	if_ibytes	if_data.ifi_ibytes
#define	if_obytes	if_data.ifi_obytes
#define	if_imcasts	if_data.ifi_imcasts
#define	if_omcasts	if_data.ifi_omcasts
#define	if_iqdrops	if_data.ifi_iqdrops
#define	if_noproto	if_data.ifi_noproto
#define	if_lastchange	if_data.ifi_lastchange

#define	IFF_UP		0x1		/* interface is up */
#define	IFF_BROADCAST	0x2		/* broadcast address valid */
#define	IFF_DEBUG	0x4		/* turn on debugging */
#define	IFF_LOOPBACK	0x8		/* is a loopback net */
#define	IFF_POINTOPOINT	0x10		/* interface is point-to-point link */
#define	IFF_RUNNING	0x40		/* resources allocated */
#define	IFF_NOARP	0x80		/* no address resolution protocol */
#define	IFF_PROMISC	0x100		/* receive all packets */
#define	IFF_ALLMULTI	0x200		/* receive all multicast packets */
#define	IFF_OACTIVE	0x400		/* transmission in progress */
#define	IFF_SIMPLEX	0x800		/* can't hear own transmissions */
#define	IFF_LINK0	0x1000		/* per link layer defined bit */
#define	IFF_LINK1	0x2000		/* per link layer defined bit */
#define	IFF_LINK2	0x4000		/* per link layer defined bit */
#define	IFF_MULTICAST	0x8000		/* supports multicast */

/* flags set internally only: */
#define	IFF_CANTCHANGE \
	(IFF_BROADCAST|IFF_POINTOPOINT|IFF_RUNNING|IFF_OACTIVE|\
	    IFF_SIMPLEX|IFF_MULTICAST)

/*
 * Output queues (ifp->if_snd) and internetwork datagram level (pup level 1)
 * input routines have queues of messages stored on ifqueue structures
 * (defined above).  Entries are added to and deleted from these structures
 * by these macros, which should be called with ipl raised to splimp().
 */
#define	IF_QFULL(ifq)		((ifq)->ifq_len >= (ifq)->ifq_maxlen)
#define	IF_DROP(ifq)		((ifq)->ifq_drops++)
#define	IF_ENQUEUE(ifq, m) { \
	(m)->m_nextpkt = 0; \
	if ((ifq)->ifq_tail == 0) \
		(ifq)->ifq_head = m; \
	else \
		(ifq)->ifq_tail->m_nextpkt = m; \
	(ifq)->ifq_tail = m; \
	(ifq)->ifq_len++; \
}
#define	IF_PREPEND(ifq, m) { \
	(m)->m_nextpkt = (ifq)->ifq_head; \
	if ((ifq)->ifq_tail == 0) \
		(ifq)->ifq_tail = (m); \
	(ifq)->ifq_head = (m); \
	(ifq)->ifq_len++; \
}
#define	IF_DEQUEUE(ifq, m) { \
	(m) = (ifq)->ifq_head; \
	if (m) { \
		if (((ifq)->ifq_head = (m)->m_nextpkt) == 0) \
			(ifq)->ifq_tail = 0; \
		(m)->m_nextpkt = 0; \
		(ifq)->ifq_len--; \
	} \
}

#define	IFQ_MAXLEN	50
#define	IFNET_SLOWHZ	1		/* granularity is 1 second */

/*
 * control message types sent for an interface
 */
#define	IFS_FLAGS	1		/* if_flags changed */
#define	IFS_DCD		2		/* data carrier detect changed */

#ifdef	KERNEL
struct protoq {
	struct	wayout pq_wayout;	/* how we get called */
	struct	ifqueue pq_queue;	/* input queue for protocol */
};

#define	PQ_INIT(pq, fn)	{ \
	(pq)->pq_queue.ifq_maxlen = ifqmaxlen; \
	(pq)->pq_wayout.func = (fn); \
	(pq)->pq_wayout.arg = (pq); \
}

/* must be protected by splimp */
#define	PQ_ENQUEUE(pq, m) { \
	IF_ENQUEUE(&(pq)->pq_queue, (m)); \
	if ((pq)->pq_wayout.pending == 0) \
		wayout(&(pq)->pq_wayout); \
}
#endif

struct ifa_data {
	u_quad_t ifai_ibytes;		/* total number of octets received */
	u_quad_t ifai_obytes;		/* total number of octets sent */
	u_quad_t ifai_ipackets;		/* packets received on interface */
	u_quad_t ifai_opackets;		/* packets sent on interface */
	int	ifai_metric;		/* cost of going out this interface */
};

/*
 * The ifaddr structure contains information about one address
 * of an interface.  They are maintained by the different address families,
 * are allocated and attached when an address is set, and are linked
 * together so all addresses for an interface can be located.
 */
struct ifaddr {
	struct	sockaddr *ifa_addr;	/* address of interface */
	struct	sockaddr *ifa_dstaddr;	/* other end of p-to-p link */
#define	ifa_broadaddr	ifa_dstaddr	/* broadcast address interface */
	struct	sockaddr *ifa_netmask;	/* used to determine subnet */
	struct	ifnet *ifa_ifp;		/* back-pointer to interface */
	struct	ifaddr *ifa_next;	/* next address for interface */
	void	(*ifa_rtrequest)	/* check or clean routes (+ or -)'d */
		__P((int, struct rtentry *, struct rt_addrinfo *));
	u_short	ifa_flags;		/* mostly rt_flags for cloning */
	int	ifa_refcnt;		/* # of references */
#ifdef notdef
	struct	rtentry *ifa_rt;	/* XXXX for ROUTETOIF ????? */
#endif
	struct	ifa_data ifa_data;	/* Statistics */
};
#define	IFA_ROUTE	RTF_UP		/* route installed */

#define	ifa_ibytes	ifa_data.ifai_ibytes
#define	ifa_obytes	ifa_data.ifai_obytes
#define	ifa_ipackets	ifa_data.ifai_ipackets
#define	ifa_opackets	ifa_data.ifai_opackets
#define	ifa_metric	ifa_data.ifai_metric

/*
 * The prefix structure contains information about one prefix
 * of an interface.  They are maintained by the different address families,
 * are allocated and attached when an prefix or an address is set,
 * and are linked together so all prfefixes for an interface can be located.
 */
struct ifprefix {
	struct	sockaddr *ifpr_prefix;	/* prefix of interface */
	struct	ifnet *ifpr_ifp;	/* back-pointer to interface */
	struct ifprefix *ifpr_next;
	u_char	ifpr_plen;		/* prefix length in bits */
	u_char	ifpr_type;		/* protocol dependent prefix type */
};

/*
 * Message format for use in obtaining information about interfaces
 * from sysctl and the routing socket
 */
struct if_msghdr {
	u_short	ifm_msglen;	/* to skip over non-understood messages */
	u_char	ifm_version;	/* future binary compatability */
	u_char	ifm_type;	/* message type */
	int	ifm_addrs;	/* like rtm_addrs */
	int	ifm_flags;	/* value of if_flags */
	u_short	ifm_index;	/* index for associated ifp */
	u_short ifm_pif;	/* index for associated pif */
	struct	if_data ifm_data;/* statistics and other data about if */
};

/*
 * Message format for use in obtaining information about interface addresses
 * from sysctl and the routing socket
 */
struct ifa_msghdr {
	u_short	ifam_msglen;	/* to skip over non-understood messages */
	u_char	ifam_version;	/* future binary compatability */
	u_char	ifam_type;	/* message type */
	int	ifam_addrs;	/* like rtm_addrs */
	int	ifam_flags;	/* value of ifa_flags */
	u_short	ifam_index;	/* index for associated ifp */
	struct	ifa_data ifam_data;	/* statistics */
};
#define	ifam_metric	ifam_data.ifai_metric

/*
 * Interface request structure used for socket
 * ioctl's.  All interface ioctl's must have parameter
 * definitions which begin with ifr_name.  The
 * remainder may be interface specific.
 */
struct	ifreq {
#define	IFNAMSIZ	16
#define	IF_NAMESIZE	IFNAMSIZ
	char	ifr_name[IFNAMSIZ];		/* if name, e.g. "en0" */
	union {
		struct	sockaddr ifru_addr;
		struct	sockaddr ifru_dstaddr;
		struct	sockaddr ifru_broadaddr;
		short	ifru_flags;
		int	ifru_metric;
		caddr_t	ifru_data;
	} ifr_ifru;
#define	ifr_addr	ifr_ifru.ifru_addr	/* address */
#define	ifr_dstaddr	ifr_ifru.ifru_dstaddr	/* other end of p-to-p link */
#define	ifr_broadaddr	ifr_ifru.ifru_broadaddr	/* broadcast address */
#define	ifr_flags	ifr_ifru.ifru_flags	/* flags */
#define	ifr_metric	ifr_ifru.ifru_metric	/* metric */
#define	ifr_media	ifr_ifru.ifru_metric	/* media options */
#define	ifr_mtu		ifr_ifru.ifru_metric	/* MTU */
#define	ifr_data	ifr_ifru.ifru_data	/* for use by interface */
};

struct ifaliasreq {
	char	ifra_name[IFNAMSIZ];		/* if name, e.g. "en0" */
	struct	sockaddr ifra_addr;
	struct	sockaddr ifra_broadaddr;
	struct	sockaddr ifra_mask;
};

struct ifmediareq {
	char	ifm_name[IFNAMSIZ];		/* if name, e.g. "en0" */
	int	ifm_current;			/* return: current media opts */
	int	ifm_mask;			/* return: current mask */
	int	ifm_status;			/* return: current media stat */
	int	ifm_active;			/* return: active opts */
	int	ifm_count;			/* input: words in ifm_ulist */
	int	*ifm_ulist;			/* output: media words */
};

/*
 * Structure used in SIOCGIFCONF request.
 * Used to retrieve interface configuration
 * for machine (useful for programs which
 * must know all networks accessible).
 */
struct	ifconf {
	int	ifc_len;		/* size of associated buffer */
	union {
		caddr_t	ifcu_buf;
		struct	ifreq *ifcu_req;
	} ifc_ifcu;
#define	ifc_buf	ifc_ifcu.ifcu_buf	/* buffer address */
#define	ifc_req	ifc_ifcu.ifcu_req	/* array of structures returned */
};

/*
 * Structure for SIOC[AGD]LIFADDR
 */
struct if_laddrreq {
	char iflr_name[IFNAMSIZ];
	unsigned int flags;
#define IFLR_PREFIX	0x8000	/* in: prefix given  out: kernel fills id */
	unsigned int prefixlen;		/* in/out */
	struct sockaddr_storage addr;	/* in/out */
	struct sockaddr_storage dstaddr; /* out */
};

/*
 * Definitions for link sysctl operations.
 *
 * If third level is generic(=0), fourth level is operation.
 * Otherwise third level is interface index.
 */

/*
 * Names for link types
 */
#define	CTL_LINK_TYPE_NAMES { \
	{ 0, 0 },			/* 0x00 */ \
	{ 0, 0 },			/* 0x01 */ \
	{ 0, 0 },			/* 0x02 */ \
	{ 0, 0 },			/* 0x03 */ \
	{ 0, 0 },			/* 0x04 */ \
	{ 0, 0 },			/* 0x05 */ \
	{ 0, 0 },			/* 0x06 */ \
	{ 0, 0 },			/* 0x07 */ \
	{ 0, 0 },			/* 0x08 */ \
	{ 0, 0 },			/* 0x09 */ \
	{ 0, 0 },			/* 0x0a */ \
	{ 0, 0 },			/* 0x0b */ \
	{ 0, 0 },			/* 0x0c */ \
	{ 0, 0 },			/* 0x0d */ \
	{ 0, 0 },			/* 0x0e */ \
	{ 0, 0 },			/* 0x0f */ \
	{ 0, 0 },			/* 0x10 */ \
	{ 0, 0 },			/* 0x11 */ \
	{ 0, 0 },			/* 0x10 */ \
	{ 0, 0 },			/* 0x13 */ \
	{ 0, 0 },			/* 0x14 */ \
	{ 0, 0 },			/* 0x15 */ \
	{ 0, 0 },			/* 0x16 */ \
	{ "ppp", CTLTYPE_NODE },	/* 0x17 */ \
	{ "lo", CTLTYPE_NODE },		/* 0x18 */ \
	{ 0, 0 },			/* 0x19 */ \
	{ 0, 0 },			/* 0x1a */ \
	{ 0, 0 },			/* 0x1b */ \
	{ 0, 0 },			/* 0x1c */ \
	{ 0, 0 },			/* 0x1d */ \
	{ 0, 0 },			/* 0x1e */ \
	{ 0, 0 },			/* 0x1f */ \
	{ 0, 0 },			/* 0x20 */ \
	{ 0, 0 },			/* 0x21 */ \
	{ 0, 0 },			/* 0x22 */ \
	{ 0, 0 },			/* 0x23 */ \
	{ 0, 0 },			/* 0x24 */ \
	{ 0, 0 },			/* 0x25 */ \
	{ 0, 0 },			/* 0x26 */ \
	{ 0, 0 },			/* 0x27 */ \
	{ 0, 0 },			/* 0x28 */ \
	{ 0, 0 },			/* 0x29 */ \
	{ 0, 0 },			/* 0x2a */ \
	{ 0, 0 },			/* 0x2b */ \
	{ 0, 0 },			/* 0x2c */ \
	{ 0, 0 },			/* 0x2d */ \
	{ 0, 0 },			/* 0x2e */ \
	{ 0, 0 },			/* 0x2f */ \
	{ 0, 0 },			/* 0x30 */ \
	{ 0, 0 },			/* 0x31 */ \
	{ 0, 0 },			/* 0x32 */ \
	{ 0, 0 },			/* 0x33 */ \
	{ 0, 0 },			/* 0x34 */ \
	{ "tun", CTLTYPE_NODE },	/* 0x35 */ \
	{ "pif", CTLTYPE_NODE },	/* 0x36 */ \
	{ 0, 0 },			/* 55 */ \
	{ 0, 0 },			/* 56 */ \
	{ 0, 0 },			/* 57 */ \
	{ 0, 0 },			/* 58 */ \
	{ 0, 0 },			/* 59 */ \
	{ 0, 0 },			/* 60 */ \
	{ 0, 0 },			/* 61 */ \
	{ 0, 0 },			/* 62 */ \
	{ 0, 0 },			/* 63 */ \
	{ 0, 0 },			/* 64 */ \
	{ 0, 0 },			/* 65 */ \
	{ 0, 0 },			/* 66 */ \
	{ 0, 0 },			/* 67 */ \
	{ 0, 0 },			/* 68 */ \
	{ 0, 0 },			/* 69 */ \
	{ 0, 0 },			/* 70 */ \
	{ 0, 0 },			/* 71 */ \
	{ 0, 0 },			/* 72 */ \
	{ 0, 0 },			/* 73 */ \
	{ 0, 0 },			/* 74 */ \
	{ 0, 0 },			/* 75 */ \
	{ 0, 0 },			/* 76 */ \
	{ 0, 0 },			/* 77 */ \
	{ 0, 0 },			/* 78 */ \
	{ 0, 0 },			/* 79 */ \
	{ 0, 0 },			/* 80 */ \
	{ 0, 0 },			/* 81 */ \
	{ 0, 0 },			/* 82 */ \
	{ 0, 0 },			/* 83 */ \
	{ 0, 0 },			/* 84 */ \
	{ 0, 0 },			/* 85 */ \
	{ 0, 0 },			/* 86 */ \
	{ 0, 0 },			/* 87 */ \
	{ 0, 0 },			/* 88 */ \
	{ 0, 0 },			/* 89 */ \
	{ 0, 0 },			/* 90 */ \
	{ 0, 0 },			/* 91 */ \
	{ 0, 0 },			/* 92 */ \
	{ 0, 0 },			/* 93 */ \
	{ 0, 0 },			/* 94 */ \
	{ 0, 0 },			/* 95 */ \
	{ 0, 0 },			/* 96 */ \
	{ 0, 0 },			/* 97 */ \
	{ 0, 0 },			/* 98 */ \
	{ 0, 0 },			/* 99 */ \
	{ 0, 0 },			/* 100 */ \
	{ 0, 0 },			/* 101 */ \
	{ 0, 0 },			/* 102 */ \
	{ 0, 0 },			/* 103 */ \
	{ 0, 0 },			/* 104 */ \
	{ 0, 0 },			/* 105 */ \
	{ 0, 0 },			/* 106 */ \
	{ 0, 0 },			/* 107 */ \
	{ 0, 0 },			/* 108 */ \
	{ 0, 0 },			/* 109 */ \
	{ 0, 0 },			/* 110 */ \
	{ 0, 0 },			/* 111 */ \
	{ 0, 0 },			/* 112 */ \
	{ 0, 0 },			/* 113 */ \
	{ 0, 0 },			/* 114 */ \
	{ 0, 0 },			/* 115 */ \
	{ 0, 0 },			/* 116 */ \
	{ 0, 0 },			/* 117 */ \
	{ 0, 0 },			/* 118 */ \
	{ 0, 0 },			/* 119 */ \
	{ 0, 0 },			/* 120 */ \
	{ 0, 0 },			/* 121 */ \
	{ 0, 0 },			/* 122 */ \
	{ 0, 0 },			/* 123 */ \
	{ 0, 0 },			/* 124 */ \
	{ 0, 0 },			/* 125 */ \
	{ 0, 0 },			/* 126 */ \
	{ 0, 0 },			/* 127 */ \
	{ 0, 0 },			/* 128 */ \
	{ 0, 0 },			/* 129 */ \
	{ 0, 0 },			/* 130 */ \
	{ 0, 0 },			/* 131 */ \
	{ 0, 0 },			/* 132 */ \
	{ 0, 0 },			/* 133 */ \
	{ 0, 0 },			/* 134 */ \
	{ "vlan", CTLTYPE_NODE },	/* 135 */ \
	{ 0, 0 },			/* 136 */ \
	{ 0, 0 },			/* 137 */ \
	{ 0, 0 },			/* 138 */ \
	{ 0, 0 },			/* 139 */ \
	{ 0, 0 },			/* 140 */ \
	{ 0, 0 },			/* 141 */ \
	{ 0, 0 },			/* 142 */ \
	{ 0, 0 },			/* 143 */ \
	{ 0, 0 },			/* 144 */ \
	{ 0, 0 },			/* 145 */ \
	{ 0, 0 },			/* 146 */ \
	{ 0, 0 },			/* 147 */ \
	{ 0, 0 },			/* 148 */ \
	{ 0, 0 },			/* 149 */ \
	{ 0, 0 },			/* 150 */ \
	{ 0, 0 },			/* 151 */ \
	{ 0, 0 },			/* 152 */ \
	{ 0, 0 },			/* 153 */ \
	{ 0, 0 },			/* 154 */ \
	{ 0, 0 },			/* 155 */ \
	{ 0, 0 },			/* 156 */ \
	{ 0, 0 },			/* 157 */ \
	{ 0, 0 },			/* 158 */ \
	{ 0, 0 },			/* 159 */ \
	{ 0, 0 },			/* 160 */ \
	{ 0, 0 },			/* 161 */ \
	{ 0, 0 },			/* 162 */ \
	{ 0, 0 },			/* 163 */ \
	{ 0, 0 },			/* 164 */ \
	{ 0, 0 },			/* 165 */ \
	{ 0, 0 },			/* 166 */ \
	{ 0, 0 },			/* 167 */ \
	{ 0, 0 },			/* 168 */ \
	{ 0, 0 },			/* 169 */ \
	{ 0, 0 },			/* 170 */ \
	{ 0, 0 },			/* 171 */ \
	{ 0, 0 },			/* 172 */ \
	{ 0, 0 },			/* 173 */ \
	{ 0, 0 },			/* 174 */ \
	{ 0, 0 },			/* 175 */ \
	{ 0, 0 },			/* 176 */ \
	{ 0, 0 },			/* 177 */ \
	{ 0, 0 },			/* 178 */ \
	{ 0, 0 },			/* 179 */ \
	{ 0, 0 },			/* 180 */ \
	{ 0, 0 },			/* 181 */ \
	{ 0, 0 },			/* 182 */ \
	{ 0, 0 },			/* 183 */ \
	{ 0, 0 },			/* 184 */ \
	{ 0, 0 },			/* 185 */ \
	{ 0, 0 },			/* 186 */ \
	{ 0, 0 },			/* 187 */ \
	{ 0, 0 },			/* 188 */ \
	{ 0, 0 },			/* 189 */ \
	{ 0, 0 },			/* 190 */ \
	{ 0, 0 },			/* 191 */ \
	{ 0, 0 },			/* 192 */ \
	{ 0, 0 },			/* 193 */ \
	{ 0, 0 },			/* 194 */ \
	{ 0, 0 },			/* 195 */ \
	{ 0, 0 },			/* 196 */ \
	{ 0, 0 },			/* 197 */ \
	{ 0, 0 },			/* 198 */ \
	{ 0, 0 },			/* 199 */ \
	{ "aif", CTLTYPE_NODE },	/* 200 */ \
	{ 0, 0 },			/* 201 */ \
	{ 0, 0 },			/* 202 */ \
	{ 0, 0 },			/* 203 */ \
	{ 0, 0 },			/* 204 */ \
	{ 0, 0 },			/* 205 */ \
	{ 0, 0 },			/* 206 */ \
	{ 0, 0 },			/* 207 */ \
	{ 0, 0 },			/* 208 */ \
	{ 0, 0 },			/* 209 */ \
	{ 0, 0 },			/* 210 */ \
	{ 0, 0 },			/* 211 */ \
	{ 0, 0 },			/* 212 */ \
	{ 0, 0 },			/* 213 */ \
	{ 0, 0 },			/* 214 */ \
	{ 0, 0 },			/* 215 */ \
	{ 0, 0 },			/* 216 */ \
	{ 0, 0 },			/* 217 */ \
	{ 0, 0 },			/* 218 */ \
	{ 0, 0 },			/* 219 */ \
	{ 0, 0 },			/* 220 */ \
	{ 0, 0 },			/* 221 */ \
	{ 0, 0 },			/* 222 */ \
	{ 0, 0 },			/* 223 */ \
	{ 0, 0 },			/* 224 */ \
	{ 0, 0 },			/* 225 */ \
	{ 0, 0 },			/* 226 */ \
	{ 0, 0 },			/* 227 */ \
	{ 0, 0 },			/* 228 */ \
	{ 0, 0 },			/* 229 */ \
	{ 0, 0 },			/* 230 */ \
	{ 0, 0 },			/* 231 */ \
	{ 0, 0 },			/* 232 */ \
	{ 0, 0 },			/* 233 */ \
	{ 0, 0 },			/* 234 */ \
	{ 0, 0 },			/* 235 */ \
	{ 0, 0 },			/* 236 */ \
	{ 0, 0 },			/* 237 */ \
	{ 0, 0 },			/* 238 */ \
	{ 0, 0 },			/* 239 */ \
	{ "gif", CTLTYPE_NODE },	/* 240 (0xf0) */ \
	{ "dummy", CTLTYPE_NODE },	/* 241 (0xf1) */ \
	{ "pvc", CTLTYPE_NODE },	/* 242 (0xf2) */ \
	{ "faith", CTLTYPE_NODE },	/* 243 (0xf3) */ \
	{ "stf", CTLTYPE_NODE },	/* 244 (0xf4) */ \
	{ 0, 0 },			/* 245 (0xf5) */ \
	{ 0, 0 },			/* 246 (0xf6) */ \
	{ 0, 0 },			/* 247 (0xf7) */ \
	{ 0, 0 },			/* 248 (0xf8) */ \
	{ 0, 0 },			/* 249 (0xf9) */ \
	{ 0, 0 },			/* 250 (0xfa) */ \
	{ 0, 0 },			/* 251 (0xfb) */ \
	{ 0, 0 },			/* 252 (0xfc) */ \
	{ 0, 0 },			/* 253 (0xfd) */ \
	{ 0, 0 },			/* 254 (0xfe) */ \
	{ 0, 0 },			/* 255 (0xff) */ \
}

/*
 * Names for generic link sysctls
 */
#define	CTL_LINK_IFTYPE_NUMIF	0	/* Change the number of interfaces configured */
#define	CTL_LINK_IFTYPE_MAXID	1

#define	CTL_LINK_IFTYPE_NAMES { \
	{ "numif", CTLTYPE_INT }, \
}

/* Interface specific sysctls */

#define	CTL_LINK_GENERIC	1	/* Generic link operations */
#define	CTL_LINK_LINKTYPE	2	/* Link type operations */
#define	CTL_LINK_HWTYPE		3	/* HW type operations */
#define	CTL_LINK_PROTOTYPE	4	/* Protocol family operations */
#define	CTL_LINK_MAXID		5

#define	CTL_LINK_NAMES { \
	{ 0, 0 }, \
	{ "generic", CTLTYPE_NODE }, \
	{ "link_type", CTLTYPE_NODE }, \
	{ "hw_type", CTLTYPE_NODE }, \
	{ "proto_type", CTLTYPE_NODE }, \
};

#define	LINK_GENERIC_DATA	1	/* if_data */
#define	LINK_GENERIC_ADDR	2	/* address */
#define	LINK_GENERIC_ADDRMAP	3	/* addr to hw-addr mappings */
#define	LINK_GENERIC_MAXID	4

#define	LINK_GENERIC_NAMES { \
	{ 0, 0 }, \
	{ "data", CTLTYPE_STRUCT }, \
	{ "addr", CTLTYPE_STRUCT }, \
	{ "addrmap", CTLTYPE_STRUCT }, \
};

#define CTL_LINK_NET_NAMES { \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ "inet", CTLTYPE_NODE }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
}

#include <net/if_arp.h>

#ifdef KERNEL
#define	IFAFREE(ifa) \
	if ((ifa)->ifa_refcnt <= 0) \
		ifafree(ifa); \
	else \
		(ifa)->ifa_refcnt--;

struct	ifnet	*ifnet;
struct ifnet **ifindex2ifnet;
extern	int if_index;
extern	int ifqmaxlen;
extern	struct ifaddr **ifnet_addrs;

void	ether_attach __P((struct ifnet *));
void	ether_input __P((struct ifnet *, struct mbuf *));
int	ether_ioctl __P((struct ifnet *, int, caddr_t));
int	ether_output __P((struct ifnet *,
	   struct mbuf *, struct sockaddr *, struct rtentry *));

/*
 * 802.11 versions of ether_*
 */
void	ieee_802_11_attach __P((struct ifnet *));
void	ieee_802_11_input __P((struct ifnet *, struct mbuf *));
int	ieee_802_11_output __P((struct ifnet *,
	   struct mbuf *, struct sockaddr *, struct rtentry *));
int	ieee_802_11_sysctl __P((struct ifnet *, int *, u_int, void *, size_t *,
	    void *, size_t));

char	*ether_sprintf __P((u_char *));
int	ether_sysctl __P((struct ifnet *, int *, u_int, void *, size_t *,
	    void *, size_t));

void	if_attach __P((struct ifnet *));
void	if_newaddr __P((struct ifnet *, int, caddr_t));
void	if_down __P((struct ifnet *));
void	if_qflush __P((struct ifqueue *));
void	if_slowtimo __P((void *));
void	if_up __P((struct ifnet *));
void	if_statechg __P((struct ifnet *));
#ifdef vax
void	ifubareset __P((int));
#endif
int	ifconf __P((int, caddr_t));
void	ifinit __P((void));
int	ifioctl __P((struct socket *, u_long, caddr_t, struct proc *));
int	ifpromisc __P((struct ifnet *, int));
struct	ifnet *ifunit __P((char *));
struct	ifnet *if_withname __P((struct sockaddr *));

struct	ifaddr *ifa_ifwithaddr __P((struct sockaddr *));
struct	ifaddr *ifa_ifwithaf __P((int));
struct	ifaddr *ifa_ifwithdstaddr __P((struct sockaddr *));
struct	ifaddr *ifa_ifwithlink __P((struct sockaddr_dl *));
struct	ifaddr *ifa_ifwithnet __P((struct sockaddr *));
struct	ifaddr *ifa_ifwithroute __P((int, struct sockaddr *,
					struct sockaddr *));
struct	ifaddr *ifaof_ifpforaddr __P((struct sockaddr *, struct ifnet *));
void	ifafree __P((struct ifaddr *));
void	link_rtrequest __P((int, struct rtentry *, struct rt_addrinfo *));

int	loioctl __P((struct ifnet *, u_long, caddr_t));
void	loopattach __P((int));
int	looutput __P((struct ifnet *,
	   struct mbuf *, struct sockaddr *, struct rtentry *));
void	lortrequest __P((int, struct rtentry *, struct rt_addrinfo *));
#endif

#ifndef KERNEL
/*
 * Structure and function definitions for if_* library routines
 * that are defined in RFC 2553.
 */
struct if_nameindex {
	unsigned int	if_index;	/* 1, 2, ... */
	char		*if_name;	/* null terminated name: "le0", ... */
};

#include <sys/cdefs.h>

__BEGIN_DECLS
char		*if_indextoname __P((unsigned int, char *));
unsigned int	if_nametoindex __P((const char *));
void		if_freenameindex __P((struct if_nameindex *));
struct		if_nameindex *if_nameindex __P((void));
__END_DECLS

#endif /* !KERNEL */

#endif /* !_NET_IF_H_ */
