/*-
 * Copyright (c) 2000 Berkeley Software Design, Inc.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI if_aif.h,v 2.3 2000/11/06 19:13:14 dab Exp
 */

#ifndef _IF_AIF_H_
#define _IF_AIF_H_

#define	AIF_MIN_IF	5

struct aif_softc {
	struct	ifnet aif_if;
	u_int32_t aif_flags;			/* Flags: see below */
	u_long	aif_admin_mtu;			/* Admin set max MTU value */

	u_short	aif_nif;			/* # ifs assigned to this aif */
	u_short	aif_maxif;			/* # elements in *aif_inet */
	struct	ifnet **aif_list;		/* list of ifs */

	struct	ifnet *_aif_list[AIF_MIN_IF];	/* static initial aif_list */
};

#define AIF_MAX_MTU		(65*1024)

#define	AIF_ROAMING	1	/* allow hosts to roam between subnets */
#define	AIF_ARPOK	2	/* allow arp requests from unknown hosts */

#ifdef	KERNEL
LIST_HEAD(aif_head, ifnet);

void	aifattach __P((int));
int	aifioctl __P((struct ifnet *, u_long, caddr_t));
void	aifstart __P((struct ifnet *));
int	aif_add __P((struct aif_softc *, struct ifnet *));
int	aif_remove __P((struct aif_softc *, struct ifnet *));
void	aif_cominit __P((struct aif_softc *));
int	aifoutput __P((struct ifnet *, struct mbuf *,
	    struct sockaddr *, struct rtentry *));
#endif

struct aifreq {
	char		aifr_name[IFNAMSIZ];
	u_int32_t	aifr_flags;
	struct sockaddr	*aifr_addr;
	int		aifr_addrlen;
	union {
		char		aifru_subname[IFNAMSIZ];
		u_int		aifru_vid;
		u_char		aifru_ether[6];
	}aifr_u;
#define	aifr_subname aifr_u.aifru_subname
#define	aifr_vid aifr_u.aifru_vid
#define aifr_ether aifr_u.aifru_ether
};

/* Link/unlink an interface from an AIF. */
#define	AIFIOCADD	_IOWR('i', 200, struct aifreq)
#define	AIFIOCDEL	_IOWR('i', 201, struct aifreq)

#define	AIFIOCGFLG	_IOWR('i', 202, struct aifreq)
#define	AIFIOCSFLG	_IOWR('i', 203, struct aifreq)
#define	AIFIOCGAIF	_IOWR('i', 204, struct aifreq)

/*
 * Allow an address for a particulare sub-interface by specifying
 * either the sub-interface, vlan (802.1q) id, or ethernet address.
 */
#define	AIFIOCSADDRI	_IOWR('i', 205, struct aifreq)
#define	AIFIOCSADDRV	_IOWR('i', 206, struct aifreq)
#define	AIFIOCSADDRE	_IOWR('i', 207, struct aifreq)

#define	AIFIOCDADDRI	_IOWR('i', 208, struct aifreq)
#define	AIFIOCDADDR	_IOWR('i', 209, struct aifreq)

struct aif_map {
	struct aif_map	*am_next;
	struct sockaddr	*am_dst;	/* Destination address */
	struct sockaddr	*am_ll;		/* ifp & link level address */
};

#endif /* !_IF_AIF_H_ */
