/*-
 * Copyright (c) 2001 Berkeley Software Design, Inc.  
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI if_config.h,v 1.2.2.1 2001/04/18 16:11:40 prb Exp
 */

/*
 * This structure is passed in from /boot with the the tag of B_IFCONFIG.
 * It contains the configuration about a single network interface.
 */

struct bootparam_if {
	u_short	bif_linkoff;	/* Offset to sockaddr of link address */
	u_short	bif_addroff;	/* Offset to sockaddr of address */
	u_short	bif_maskoff;	/* Offset to sockaddr of mask */
	u_short	bif_broadoff;	/* Offset to sockaddr of broad */
	u_long	bif_media;	/* Media type to set (0 -> default) */
	u_long	bif_flags;	/* Flags */
};

#define	bif_what(b,w)	((b)->w ? ((char *)(b) + (b)->w) : NULL)

#define	bif_link(b)	((struct sockaddr_dl *)bif_what(b, bif_linkoff))
#define	bif_addr(b, t)	((t *)bif_what(b, bif_addroff))
#define	bif_mask(b, t)	((t *)bif_what(b, bif_maskoff))
#define	bif_broad(b, t)	((t *)bif_what(b, bif_broadoff))

/*
 * The list of all flags we can set from /boot
 * The default is for all flags to be turned off
 */
#define	BIF_FLAGS	(IFF_UP|IFF_DEBUG|IFF_LINK0|IFF_LINK1|IFF_LINK2)
