/*-
 * Copyright (c) 1993, 1994, 1995, 1996 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI if_p2pproto.c,v 2.9 1997/09/11 06:26:53 prb Exp
 */

/*
 * Common code for point-to-point synchronous serial links
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/kernel.h>
#include <sys/malloc.h>
#include <sys/mbuf.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/ioctl.h>

#include <net/if.h>
#include <net/netisr.h>
#include <net/route.h>
#include <net/if_dl.h>
#include <net/if_types.h>

#if INET
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>		/* XXX for slcompress */
#endif

#include <net/if_p2p.h>
#include <net/bpf.h>


extern int p2p_hdr();

extern int none_attach(), none_init(), none_output(), none_input();
extern void none_detach(), none_shutdown();

#ifdef CISCO_HDLC
extern int c_hdlc_attach(), c_hdlc_init(), c_hdlc_output(), c_hdlc_input();
extern void c_hdlc_detach(), c_hdlc_shutdown();
#endif
#ifdef PPP
#include <net/slcompress.h>
extern int ppp_attach(), ppp_init(), ppp_output(), ppp_input(), ppp_ioctl(),
	   ppp_hdr();
extern void ppp_detach(), ppp_modem(), ppp_shutdown();
#endif
#ifdef  FR
extern int fr_attach(), fr_init(), fr_output(), fr_input(), fr_hdr(),
	   fr_ioctl(), fr_hdr();
extern void fr_detach(), fr_modem(), fr_shutdown();
#endif
#ifdef	HDLC
extern int hd_attach(), hd_init(), hd_output(), hd_input();
extern void hd_detach(), hd_modem(), hd_shutdown();
#endif

/*
 * The table of available point-to-point encapsulation protocols
 */
struct p2pprotosw p2pprotosw[] = {
	/* UNITIALIZED STATE */
{	IFT_NONE,
	none_attach,	none_detach,	none_init,	none_shutdown,
	none_output,	none_input,	0,		0,
	p2p_hdr,	0,
	16,		DLT_NULL,	0,
},
#ifdef CISCO_HDLC
{	IFT_PTPSERIAL,
	c_hdlc_attach,	c_hdlc_detach,	c_hdlc_init,	c_hdlc_shutdown,
	c_hdlc_output,	c_hdlc_input,	0,		0,
	p2p_hdr,	0,
	16,		DLT_C_HDLC,	0,
},
#endif
#ifdef PPP
{	IFT_PPP,
	ppp_attach,	ppp_detach,	ppp_init,	ppp_shutdown,
	ppp_output,	ppp_input,	ppp_ioctl,	ppp_modem,
	ppp_hdr,	0,
	120,		DLT_PPP,	SLC_BPFHDR,
},
#endif
#ifdef  FR
{	IFT_FRELAY,
	fr_attach,	fr_detach,	fr_init,	fr_shutdown,
	fr_output,	fr_input,	fr_ioctl,	fr_modem,
	fr_hdr,		0,
	16,		DLT_FR,		0,
},
#endif
#ifdef HDLC
{	IFT_LAPB,
	hd_attach,	hd_detach,	hd_init,	hd_shutdown,
	hd_output,	hd_input,	0,		hd_modem,
	p2p_hdr,	0,
	16,		DLT_NULL,	0,
},
#endif
#ifdef X25
{	IFT_X25,
	hd_attach,	hd_detach,	hd_init,	hd_shutdown,
	hd_output,	hd_input,	0,		hd_modem,
	p2p_hdr,	0,
	16,		DLT_NULL,	0,
},
#endif
};

int np2pproto = (sizeof p2pprotosw / sizeof p2pprotosw[0]);
