/*-
 * Copyright (c) 1993, 1994, 1996 Berkeley Software Design, Inc.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI if_pppioctl.h,v 2.7 1998/01/24 00:19:18 chrisk Exp
 *	Urner Id: pppioctl.h,v 1.4 1994/12/03 00:16:18 dlu Exp
 */

#ifndef _IF_PPPIOCTL_H_
#define _IF_PPPIOCTL_H_

/*
 * Point-to-point protocol ioctls
 * (net/if.h should be included first)
 */

/* PPP parameters for ioctls */
struct ppp_ioctl {
	u_short ppp_control;
	u_short	ppp_flags;
	u_short	ppp_mtu;
	u_short ppp_idletime;	/* The inactivity timer (in seconds) */
	u_long	ppp_txcmap;
	u_long	ppp_rxcmap;
};

/* A kludge to fit the ppp_ioctl to the struct ifreq */
#define ifr_pppioctl(ifr)    ((struct ppp_ioctl *)&(((struct ifreq *)(ifr))->ifr_data))

struct ifpppreq {
	char	ifrp_name[IFNAMSIZ];		/* if name, e.g. "ppp0" */
	union {
		struct	ppp_ioctl ifrpu_ioctl;
		struct {
			struct	ppp_ed ifrps_ed;
			struct	ppp_auth ifrps_auth;
		} ifrpu_ifrps;
		char ifrpu_pif[IFNAMSIZ];	/* pif name, e.g. "pif0" */
		u_int32_t ifrpu_mrru;
	} ifrp_ifrpu;
#define	ifrp_ioctl	ifrp_ifrpu.ifrpu_ioctl
#define	ifrp_ed		ifrp_ifrpu.ifrpu_ifrps.ifrps_ed
#define	ifrp_auth	ifrp_ifrpu.ifrpu_ifrps.ifrps_auth
#define	ifrp_pif	ifrp_ifrpu.ifrpu_pif
#define	ifrp_mrru	ifrp_ifrpu.ifrpu_mrru
};


/* PPP option flags */
#define PPP_PFC		0x0001	/* Enable protocol field compression */
#define PPP_ACFC	0x0002	/* Enable addr and control field compression */
#define PPP_TCPC	0x0004	/* Enable Van Jacobson's TCP compression */
#define PPP_FTEL	0x0008	/* Enable "fast telnet" hack */

#define	PPP_IPOKAY	0x0100	/* Okay to send IP packets through */
#define	PPP_IPREJECT	0x0200	/* Reject any IP packets */
#define PPP_RUNNING	0x0400	/* Interface running */

#define	PPP_SND_SSEQ	0x0800	/* Multilink: Send short sequence numbers */
#define	PPP_RCV_SSEQ	0x1000	/* Multilink: Receive short sequence numbers */
#define	PPP_SSEQ	0x1800	/* Multilink: Send & Receive short seq. # */

#define	PPP_WAITING	0x10000	/* Waiting for packet to drop */

/* Flags that are common across a Multilink bundle */
#define	PPP_MLFLAGS	(PPP_TCPC|PPP_FTEL|PPP_IPOKAY|PPP_IPREJECT|PPP_SSEQ)

/* Value to set MP sequence number to when no packets have come yet */
#define	MP_PPP_SEQ_UNDEF	0xffffffff

/* PPP control options */
#define	PPP_CLRF	0x0001	/* Clear these flag bits */
#define	PPP_ADDF	0x0002	/* Or in these flag bits */
#define	PPP_SETF	0x0003	/* Set these flag bits */

#define	PPP_CLRTX	0x0004	/* Clear these txcmap bits */
#define	PPP_ADDTX	0x0008	/* Or in these txcmap bits */
#define	PPP_SETTX	0x000c	/* Set these txcmap bits */

#define	PPP_CLRRX	0x0010	/* Clear these rxcmap bits */
#define	PPP_ADDRX	0x0020	/* Or in these rxcmap bits */
#define	PPP_SETRX	0x0030	/* Set these rxcmap bits */

#define	PPP_SETMTU	0x0040	/* Set the interfaces MTU */
#define	PPP_SETIDLE	0x0080	/* Set the idle timer */
#define	PPP_FLUSHQ	0x0100	/* Flush input queue */
#define	PPP_FLUSHDQ	0x0200	/* Flush defered queue */
#define	PPP_PROCDQ	0x0400	/* Process defered queue */
#define	PPP_SLCINIT	0x0800	/* Initialize SL compress table */

/*
 * IOCTLs for ppp interfaces
 *
 * Note: interface ioctls starting at 200 are defined in if_pif.h
 */

/* Wait until outgoing packet comes to an interface with dropped connection */
#define PPPIOCWAIT	_IOWR('i', 103, struct ifreq)
#define	PPPIOCGSTATE	_IOWR('i', 105, struct ifreq)	/* get ppp state */
#define	PPPIOCSSTATE	_IOWR('i', 106, struct ifreq)	/* set ppp state */

/* Async PPP tty ioctls */
#define PPPIOCGUNIT	_IOR('P', 100, int)  /* Get interface # for the line */
#define PPPIOCSUNIT	_IOWR('P', 101, int) /* Set interface # for the line */

/* Get/Set/Find/Clear ID (Endpoint Discriminator and Authentication Name ) */
#define	PPPIOCGID	_IOR('i', 107, struct ifpppreq)
#define	PPPIOCSID	_IOWR('i', 108, struct ifpppreq)
#define	PPPIOCFID	_IOWR('i', 109, struct ifpppreq)
#define	PPPIOCCID	_IOWR('i', 110, struct ifpppreq)
/* Get PIF name */
#define	PPPIOCGPIF	_IOWR('i', 111, struct ifpppreq)
/* Get/Set Maximum Receive Reconstructed Unit */
#define	PPPIOCGMRRU	_IOWR('i', 112, struct ifpppreq)
#define	PPPIOCSMRRU	_IOWR('i', 113, struct ifpppreq)

#ifdef	no_longer_used
/* IOCTLs for ppp interfaces which no longer have meaning */
#define PPPIOCGPAR	_IOWR('i', 100, struct ifreq)
#define PPPIOCSPAR	_IOWR('i', 101, struct ifreq)
#define PPPIOCNPAR	_IOWR('i', 102, struct ifreq)
#define PPPIOCIPWBOS	_IOWR('i', 104, struct ifreq)
#define PPPIOCWEOS	_IO('P', 102)        /* Wait for the end of session */
#endif

#endif /* !_IF_PPPIOCTL_H_ */
